/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagedAutoBlockEntities;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.block.entity.PackagerExtensionBlockEntity;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.UnpackagerItemHandler;
import thelm.packagedauto.menu.UnpackagerMenu;
import thelm.packagedauto.util.MiscHelper;

public class UnpackagerBlockEntity
extends BaseBlockEntity {
    public static int energyCapacity = 5000;
    public static int energyUsage = 50;
    public static boolean drawMEEnergy = true;
    public boolean firstTick = true;
    public final PackageTracker[] trackers = new PackageTracker[10];
    public List<IPackageRecipeInfo> recipeList = new ArrayList<IPackageRecipeInfo>();
    public boolean powered = false;
    public boolean blocking = false;
    public int trackerCount = 6;

    public UnpackagerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedAutoBlockEntities.UNPACKAGER.get(), pos, state);
        this.setItemHandler(new UnpackagerItemHandler(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
        for (int i = 0; i < this.trackers.length; ++i) {
            this.trackers[i] = new PackageTracker();
        }
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedauto.unpackager");
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.level.isClientSide) {
                this.postPatternChange();
            }
            this.updatePowered();
        }
        if (!this.level.isClientSide) {
            this.chargeEnergy();
            if (this.level.getGameTime() % 8L == 0L) {
                this.fillTrackers();
                this.emptyTrackers();
            }
        }
    }

    protected void fillTrackers() {
        List<PackageTracker> emptyTrackers = Arrays.stream(this.trackers).limit(this.trackerCount).filter(t -> t.isEmpty()).toList();
        List<PackageTracker> nonEmptyTrackers = Arrays.stream(this.trackers).filter(t -> !t.isEmpty()).filter(t -> !t.isFilled()).toList();
        block0: for (int i = 0; i < 9; ++i) {
            ItemStack stack;
            if (this.energyStorage.getEnergyStored() < energyUsage || (stack = this.itemHandler.getStackInSlot(i)).isEmpty() || !MiscHelper.INSTANCE.isPackage(stack)) continue;
            boolean flag = false;
            for (PackageTracker tracker : nonEmptyTrackers) {
                if (tracker.tryAcceptPackage(stack, i)) {
                    flag = true;
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
                    } else {
                        tracker.setRejectedIndex(i, true);
                    }
                    this.energyStorage.extractEnergy(energyUsage, false);
                    break;
                }
                tracker.setRejectedIndex(i, true);
            }
            if (flag) continue;
            for (PackageTracker tracker : emptyTrackers) {
                if (tracker.tryAcceptPackage(stack, i)) {
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
                    } else {
                        tracker.setRejectedIndex(i, true);
                    }
                    this.energyStorage.extractEnergy(energyUsage, false);
                    continue block0;
                }
                tracker.setRejectedIndex(i, true);
            }
        }
    }

    protected void emptyTrackers() {
        ItemStack stackRem;
        ItemStack stack;
        PackageTracker trackerToEmpty;
        block0: for (Direction direction : Direction.values()) {
            PackageTracker[] packageTrackerArray = this.level.getBlockEntity(this.worldPosition.relative(direction));
            if (!(packageTrackerArray instanceof IPackageCraftingMachine)) continue;
            IPackageCraftingMachine machine = (IPackageCraftingMachine)packageTrackerArray;
            for (PackageTracker tracker : this.trackers) {
                if (!tracker.isFilled() || tracker.recipe == null || !tracker.recipe.getRecipeType().hasMachine() || machine.isBusy() || !machine.acceptPackage(tracker.recipe, Lists.transform(tracker.recipe.getInputs(), ItemStack::copy), direction.getOpposite())) continue;
                tracker.clearRecipe();
                this.sync(false);
                this.setChanged();
                continue block0;
            }
        }
        if (!this.powered) {
            block2: for (Direction direction : Direction.values()) {
                trackerToEmpty = Arrays.stream(this.trackers).filter(t -> t.isFilled() && t.direction == null && t.recipe != null && !t.recipe.getRecipeType().hasMachine()).findFirst().orElse(null);
                if (trackerToEmpty == null) continue;
                BlockPos offsetPos = this.worldPosition.relative(direction);
                BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(direction));
                if (!this.validSendTarget(blockEntity, direction.getOpposite())) continue;
                if (trackerToEmpty.toSend.isEmpty()) {
                    trackerToEmpty.setupToSend();
                }
                IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offsetPos, (Object)direction.getOpposite());
                if (this.blocking) {
                    for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                        ItemStack stack2 = trackerToEmpty.toSend.get(i);
                        if (stack2.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && ((IVolumeStackWrapper)stack2.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().hasBlockCapability(this.level, offsetPos, direction.getOpposite()) ? !((IVolumeStackWrapper)stack2.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().isEmpty(this.level, offsetPos, direction.getOpposite()) : itemHandler != null && !MiscHelper.INSTANCE.isEmpty(itemHandler)) continue block2;
                    }
                }
                boolean acceptsAll = true;
                for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                    stackRem = stack = trackerToEmpty.toSend.get(i);
                    if (stack.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && ((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().hasBlockCapability(this.level, offsetPos, direction.getOpposite())) {
                        stackRem = MiscHelper.INSTANCE.fillVolume(this.level, offsetPos, direction.getOpposite(), stack, true);
                    } else if (itemHandler != null) {
                        stackRem = MiscHelper.INSTANCE.insertItem(itemHandler, stack, false, true);
                    }
                    acceptsAll &= stackRem.getCount() < stack.getCount();
                }
                if (acceptsAll) {
                    trackerToEmpty.direction = direction;
                }
                this.setChanged();
            }
        }
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos;
            BlockEntity blockEntity;
            trackerToEmpty = Arrays.stream(this.trackers).filter(t -> t.direction == direction).findFirst().orElse(null);
            if (trackerToEmpty == null) continue;
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.setupToSend();
            }
            boolean ordered = false;
            if (trackerToEmpty.recipe != null) {
                ordered = trackerToEmpty.recipe.getRecipeType().isOrdered();
            }
            if (!this.validSendTarget(blockEntity = this.level.getBlockEntity(offsetPos = this.worldPosition.relative(direction)), direction.getOpposite())) {
                trackerToEmpty.direction = null;
                continue;
            }
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offsetPos, (Object)direction.getOpposite());
            for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                stackRem = stack = trackerToEmpty.toSend.get(i);
                if (stack.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && ((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().hasBlockCapability(this.level, offsetPos, direction.getOpposite())) {
                    stackRem = MiscHelper.INSTANCE.fillVolume(this.level, offsetPos, direction.getOpposite(), stack, false);
                } else if (itemHandler != null) {
                    stackRem = MiscHelper.INSTANCE.insertItem(itemHandler, stack, ordered, false);
                }
                trackerToEmpty.toSend.set(i, stackRem);
            }
            trackerToEmpty.toSend.removeIf(ItemStack::isEmpty);
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.clearRecipe();
            }
            this.setChanged();
        }
    }

    protected boolean validSendTarget(BlockEntity blockEntity, Direction direction) {
        return blockEntity != null && !(blockEntity instanceof PackagerBlockEntity) && !(blockEntity instanceof PackagerExtensionBlockEntity) && !(blockEntity instanceof UnpackagerBlockEntity);
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(10);
        IEnergyStorage itemEnergyStorage = (IEnergyStorage)energyStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergyStorage != null) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(itemEnergyStorage.extractEnergy(energyRequest, false), false);
            if (energyStack.getCount() <= 0) {
                this.itemHandler.setStackInSlot(10, ItemStack.EMPTY);
            }
        }
    }

    public void updatePowered() {
        if (this.level.getBestNeighborSignal(this.worldPosition) > 0 != this.powered) {
            this.powered = !this.powered;
            this.sync(false);
            this.setChanged();
        }
    }

    @Override
    public int getComparatorSignal() {
        return Math.min((int)Arrays.stream(this.trackers).filter(t -> t.isFilled()).count(), 15);
    }

    public void postPatternChange() {
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.blocking = nbt.getBoolean("blocking");
        this.trackerCount = nbt.contains("trackers") ? (int)nbt.getByte("trackers") : 6;
        this.powered = nbt.getBoolean("powered");
        for (int i = 0; i < this.trackers.length; ++i) {
            this.trackers[i].load(nbt.getCompound(String.format("tracker_%02d", i)), registries);
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putBoolean("blocking", this.blocking);
        nbt.putByte("trackers", (byte)this.trackerCount);
        nbt.putBoolean("powered", this.powered);
        for (int i = 0; i < this.trackers.length; ++i) {
            CompoundTag subNBT = new CompoundTag();
            this.trackers[i].save(subNBT, registries);
            nbt.put(String.format("tracker_%02d", i), (Tag)subNBT);
        }
    }

    public void changeBlockingMode() {
        this.blocking = !this.blocking;
        this.setChanged();
    }

    public void changeTrackerCount(boolean decrease) {
        this.trackerCount = Mth.clamp((int)(this.trackerCount + (decrease ? -1 : 1)), (int)1, (int)10);
        this.setChanged();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new UnpackagerMenu(windowId, inventory, this);
    }

    public class PackageTracker {
        public boolean[] rejectedIndexes = new boolean[9];
        public IPackageRecipeInfo recipe;
        public int amount;
        public BooleanList received = new BooleanArrayList(9);
        public List<ItemStack> toSend = new ArrayList<ItemStack>();
        public Direction direction;

        public void setRecipe(IPackageRecipeInfo recipe) {
            this.recipe = recipe;
        }

        public void clearRecipe() {
            this.clearRejectedIndexes();
            this.recipe = null;
            this.amount = 0;
            this.received.clear();
            this.direction = null;
            if (UnpackagerBlockEntity.this.level != null && !((UnpackagerBlockEntity)UnpackagerBlockEntity.this).level.isClientSide) {
                UnpackagerBlockEntity.this.sync(false);
                UnpackagerBlockEntity.this.setChanged();
            }
        }

        public boolean tryAcceptPackage(ItemStack stack, int invIndex) {
            if (this.rejectedIndexes[invIndex]) {
                return false;
            }
            if (MiscHelper.INSTANCE.isPackage(stack)) {
                IPackageRecipeInfo recipe = (IPackageRecipeInfo)stack.get(PackagedAutoDataComponents.RECIPE);
                int index = (Integer)stack.get(PackagedAutoDataComponents.PACKAGE_INDEX);
                if (recipe.isValid() && recipe.validPatternIndex(index)) {
                    if (this.recipe == null) {
                        this.recipe = recipe;
                        this.amount = recipe.getPatterns().size();
                        this.received.size(this.amount);
                        this.received.set(index, true);
                        UnpackagerBlockEntity.this.sync(false);
                        UnpackagerBlockEntity.this.setChanged();
                        return true;
                    }
                    if (this.recipe.equals(recipe) && !this.received.getBoolean(index)) {
                        this.received.set(index, true);
                        UnpackagerBlockEntity.this.sync(false);
                        UnpackagerBlockEntity.this.setChanged();
                        return true;
                    }
                }
            }
            return false;
        }

        public void setRejectedIndex(int index, boolean rejected) {
            this.rejectedIndexes[index] = rejected;
        }

        public void clearRejectedIndexes() {
            Arrays.fill(this.rejectedIndexes, false);
        }

        public boolean isFilled() {
            if (!this.toSend.isEmpty()) {
                return true;
            }
            if (this.received.isEmpty()) {
                return false;
            }
            BooleanListIterator booleanListIterator = this.received.iterator();
            while (booleanListIterator.hasNext()) {
                boolean b = (Boolean)booleanListIterator.next();
                if (b) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return this.recipe == null || !this.recipe.isValid();
        }

        public void setupToSend() {
            if (this.isEmpty() || this.recipe.getRecipeType().hasMachine() || !this.toSend.isEmpty()) {
                return;
            }
            this.toSend.addAll(Lists.transform(this.recipe.getInputs(), ItemStack::copy));
        }

        public void load(CompoundTag nbt, HolderLookup.Provider registries) {
            this.clearRecipe();
            CompoundTag tag = nbt.getCompound("recipe");
            IPackageRecipeInfo recipe = MiscHelper.INSTANCE.loadRecipe(tag, registries);
            if (recipe != null) {
                this.recipe = recipe;
                this.amount = nbt.getByte("amount");
                this.received.size(this.amount);
                byte[] receivedArray = nbt.getByteArray("received");
                for (int i = 0; i < this.received.size(); ++i) {
                    this.received.set(i, receivedArray[i] != 0);
                }
            }
            MiscHelper.INSTANCE.loadAllItems(nbt.getList("to_send", 10), this.toSend, registries);
            if (nbt.contains("direction")) {
                this.direction = Direction.from3DDataValue((int)nbt.getByte("direction"));
            }
        }

        public void save(CompoundTag nbt, HolderLookup.Provider registries) {
            if (this.recipe != null) {
                CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), this.recipe, registries);
                nbt.put("recipe", (Tag)tag);
                nbt.putByte("amount", (byte)this.amount);
                byte[] receivedArray = new byte[this.received.size()];
                for (int i = 0; i < this.received.size(); ++i) {
                    receivedArray[i] = (byte)(this.received.getBoolean(i) ? 1 : 0);
                }
                nbt.putByteArray("received", receivedArray);
            }
            nbt.put("to_send", (Tag)MiscHelper.INSTANCE.saveAllItems(new ListTag(), this.toSend, registries));
            if (this.direction != null) {
                nbt.putByte("direction", (byte)this.direction.get3DDataValue());
            }
        }

        public int getSyncValue() {
            int val = 0;
            for (int i = 0; i < this.received.size(); ++i) {
                if (!this.received.getBoolean(i)) continue;
                val |= 1 << i;
            }
            val <<= 4;
            return val |= this.amount;
        }

        public void setSyncValue(int val) {
            this.amount = val & 0xF;
            this.received.size(this.amount);
            val >>>= 4;
            for (int i = 0; i < this.received.size(); ++i) {
                this.received.set(i, (val >>> i & 1) != 0);
            }
        }
    }
}

