/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagedAutoBlockEntities;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.PackagerItemHandler;
import thelm.packagedauto.menu.PackagerMenu;
import thelm.packagedauto.util.MiscHelper;

public class PackagerBlockEntity
extends BaseBlockEntity {
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static boolean drawMEEnergy = true;
    public boolean firstTick = true;
    public boolean isWorking = false;
    public int remainingProgress = 0;
    public List<IPackagePattern> patternList = new ArrayList<IPackagePattern>();
    public IPackagePattern currentPattern;
    public boolean lockPattern = false;
    public Mode mode = Mode.EXACT;
    public boolean disjoint = false;
    public boolean powered = false;

    public PackagerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedAutoBlockEntities.PACKAGER.get(), pos, state);
        this.setItemHandler(new PackagerItemHandler(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedauto.packager");
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.level.isClientSide) {
                this.postPatternChange();
            }
            this.updatePowered();
        }
        if (!this.level.isClientSide) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0 && this.isInputValid()) {
                    this.finishProcess();
                    if (!this.itemHandler.getStackInSlot(9).isEmpty()) {
                        this.ejectItem();
                    }
                    if (!this.canStart()) {
                        this.endProcess();
                    } else {
                        this.startProcess();
                    }
                }
            } else if (this.level.getGameTime() % 8L == 0L && this.canStart()) {
                this.startProcess();
                this.tickProcess();
                this.isWorking = true;
            }
            this.chargeEnergy();
            if (this.level.getGameTime() % 8L == 0L && !this.itemHandler.getStackInSlot(9).isEmpty()) {
                this.ejectItem();
            }
        }
    }

    protected static Ingredient getIngredient(ItemStack stack) {
        return !stack.isComponentsPatchEmpty() ? DataComponentIngredient.of((boolean)true, (ItemStack)stack) : Ingredient.of((ItemStack[])new ItemStack[]{stack});
    }

    public boolean isInputValid() {
        if (this.currentPattern == null) {
            this.getPattern();
        }
        if (this.currentPattern == null) {
            return false;
        }
        List<ItemStack> input = this.itemHandler.getStacks().subList(0, 9).stream().filter(stack -> !stack.isEmpty()).toList();
        if (input.isEmpty()) {
            return false;
        }
        if (!this.lockPattern && this.disjoint) {
            return MiscHelper.INSTANCE.removeExactSet(input, this.currentPattern.getInputs(), true);
        }
        List matchers = Lists.transform(this.currentPattern.getInputs(), PackagerBlockEntity::getIngredient);
        int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
        if (matches == null) {
            return false;
        }
        for (int i = 0; i < matches.length; ++i) {
            if (input.get(i).getCount() >= this.currentPattern.getInputs().get(matches[i]).getCount()) continue;
            return false;
        }
        return true;
    }

    protected boolean canStart() {
        this.getPattern();
        if (this.currentPattern == null) {
            return false;
        }
        if (!this.isInputValid()) {
            return false;
        }
        ItemStack slotStack = this.itemHandler.getStackInSlot(9);
        ItemStack outputStack = this.currentPattern.getOutput();
        return slotStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.getCount() + 1 <= outputStack.getMaxStackSize();
    }

    protected boolean canFinish() {
        return this.remainingProgress <= 0 && this.isInputValid();
    }

    protected void getPattern() {
        if (this.currentPattern != null && this.lockPattern) {
            return;
        }
        this.lockPattern = false;
        this.currentPattern = null;
        if (this.powered) {
            return;
        }
        List<ItemStack> input = this.itemHandler.getStacks().subList(0, 9).stream().filter(stack -> !stack.isEmpty()).toList();
        if (input.isEmpty()) {
            return;
        }
        for (IPackagePattern pattern : this.patternList) {
            if (this.disjoint) {
                if (!MiscHelper.INSTANCE.removeExactSet(input, pattern.getInputs(), true)) continue;
                this.currentPattern = pattern;
                return;
            }
            List matchers = Lists.transform(pattern.getInputs(), PackagerBlockEntity::getIngredient);
            int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
            if (matches == null) continue;
            this.currentPattern = pattern;
            return;
        }
    }

    protected void tickProcess() {
        int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
        this.remainingProgress -= energy;
    }

    protected void finishProcess() {
        if (this.currentPattern == null) {
            this.getPattern();
        }
        if (this.currentPattern == null) {
            this.endProcess();
            return;
        }
        List<ItemStack> input = this.itemHandler.getStacks().subList(0, 9).stream().filter(stack -> !stack.isEmpty()).toList();
        if (input.isEmpty()) {
            this.endProcess();
            return;
        }
        if (!this.lockPattern && this.disjoint) {
            if (!MiscHelper.INSTANCE.removeExactSet(input, this.currentPattern.getInputs(), true)) {
                this.endProcess();
                return;
            }
            if (this.itemHandler.getStackInSlot(9).isEmpty()) {
                this.itemHandler.setStackInSlot(9, this.currentPattern.getOutput());
            } else if (MiscHelper.INSTANCE.isPackage(this.itemHandler.getStackInSlot(9))) {
                this.itemHandler.getStackInSlot(9).grow(1);
            } else {
                this.endProcess();
                return;
            }
            MiscHelper.INSTANCE.removeExactSet(input, this.currentPattern.getInputs(), false);
        } else {
            List matchers = Lists.transform(this.currentPattern.getInputs(), PackagerBlockEntity::getIngredient);
            int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
            if (matches == null) {
                this.endProcess();
                return;
            }
            if (this.itemHandler.getStackInSlot(9).isEmpty()) {
                this.itemHandler.setStackInSlot(9, this.currentPattern.getOutput());
            } else if (MiscHelper.INSTANCE.isPackage(this.itemHandler.getStackInSlot(9))) {
                this.itemHandler.getStackInSlot(9).grow(1);
            } else {
                this.endProcess();
                return;
            }
            for (int i = 0; i < matches.length; ++i) {
                input.get(i).shrink(this.currentPattern.getInputs().get(matches[i]).getCount());
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (!this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    protected void startProcess() {
        this.remainingProgress = energyReq;
        this.setChanged();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.isWorking = false;
        this.lockPattern = false;
        this.setChanged();
    }

    protected void ejectItem() {
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(direction));
            if (!(blockEntity instanceof UnpackagerBlockEntity)) continue;
            UnpackagerBlockEntity unpackager = (UnpackagerBlockEntity)blockEntity;
            ItemStack stack = this.itemHandler.getStackInSlot(9);
            if (stack.isEmpty()) continue;
            ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)unpackager.itemHandler, (ItemStack)stack, (boolean)false);
            this.itemHandler.setStackInSlot(9, stackRem);
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(11);
        IEnergyStorage itemEnergyStorage = (IEnergyStorage)energyStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergyStorage != null) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(itemEnergyStorage.extractEnergy(energyRequest, false), false);
            if (energyStack.getCount() <= 0) {
                this.itemHandler.setStackInSlot(11, ItemStack.EMPTY);
            }
        }
    }

    public void updatePowered() {
        if (this.level.getBestNeighborSignal(this.worldPosition) > 0 != this.powered) {
            this.powered = !this.powered;
            this.sync(false);
            this.setChanged();
        }
    }

    @Override
    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStackInSlot(9).isEmpty()) {
            return 15;
        }
        return 0;
    }

    public void postPatternChange() {
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        CompoundTag tag;
        IPackageRecipeInfo recipe;
        this.mode = Mode.values()[nbt.getByte("mode")];
        super.loadAdditional(nbt, registries);
        this.isWorking = nbt.getBoolean("working");
        this.remainingProgress = nbt.getInt("progress");
        this.powered = nbt.getBoolean("powered");
        this.lockPattern = false;
        this.currentPattern = null;
        if (nbt.contains("pattern") && (recipe = MiscHelper.INSTANCE.loadRecipe(tag = nbt.getCompound("pattern"), registries)) != null) {
            List<IPackagePattern> patterns = recipe.getPatterns();
            byte index = tag.getByte("index");
            if (index >= 0 && index < patterns.size()) {
                this.currentPattern = patterns.get(index);
                this.lockPattern = true;
            }
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putByte("mode", (byte)this.mode.ordinal());
        nbt.putBoolean("working", this.isWorking);
        nbt.putInt("progress", this.remainingProgress);
        nbt.putBoolean("powered", this.powered);
        if (this.lockPattern) {
            CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), this.currentPattern.getRecipeInfo(), registries);
            tag.putByte("index", (byte)this.currentPattern.getIndex());
            nbt.put("pattern", (Tag)tag);
        }
    }

    public void changePackagingMode() {
        this.mode = Mode.values()[(this.mode.ordinal() + 1) % 3];
        ((PackagerItemHandler)this.itemHandler).updatePatternList();
        this.setChanged();
    }

    public void setChanged() {
        if (this.isWorking && !this.isInputValid()) {
            this.endProcess();
        }
        super.setChanged();
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0 || energyReq <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new PackagerMenu(windowId, inventory, this);
    }

    public static enum Mode {
        EXACT,
        DISJOINT,
        FIRST;


        public Component getTooltip() {
            return Component.translatable((String)("block.packagedauto.packager.mode." + this.name().toLowerCase(Locale.US)));
        }
    }
}

