/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import thelm.packagedauto.block.PackagedAutoBlocks;
import thelm.packagedauto.block.entity.CrafterBlockEntity;
import thelm.packagedauto.block.entity.DistributorBlockEntity;
import thelm.packagedauto.block.entity.EncoderBlockEntity;
import thelm.packagedauto.block.entity.FluidPackageFillerBlockEntity;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.block.entity.PackagerExtensionBlockEntity;
import thelm.packagedauto.block.entity.PackagingProviderBlockEntity;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.integration.appeng.blockentity.AECrafterBlockEntity;
import thelm.packagedauto.integration.appeng.blockentity.AEDistributorBlockEntity;
import thelm.packagedauto.integration.appeng.blockentity.AEPackagerBlockEntity;
import thelm.packagedauto.integration.appeng.blockentity.AEPackagerExtensionBlockEntity;
import thelm.packagedauto.integration.appeng.blockentity.AEPackagingProviderBlockEntity;
import thelm.packagedauto.integration.appeng.blockentity.AEUnpackagerBlockEntity;
import thelm.packagedauto.util.MiscHelper;

public class PackagedAutoBlockEntities {
    public static final BooleanSupplier AE2_LOADED = () -> ModList.get().isLoaded("ae2");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"packagedauto");
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<EncoderBlockEntity>> ENCODER = BLOCK_ENTITIES.register("encoder", PackagedAutoBlockEntities.of(EncoderBlockEntity::new, new Supplier[]{PackagedAutoBlocks.ENCODER}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PackagerBlockEntity>> PACKAGER = BLOCK_ENTITIES.register("packager", PackagedAutoBlockEntities.of(AE2_LOADED, () -> () -> AEPackagerBlockEntity::new, () -> () -> PackagerBlockEntity::new, new Supplier[]{PackagedAutoBlocks.PACKAGER}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PackagerExtensionBlockEntity>> PACKAGER_EXTENSION = BLOCK_ENTITIES.register("packager_extension", PackagedAutoBlockEntities.of(AE2_LOADED, () -> () -> AEPackagerExtensionBlockEntity::new, () -> () -> PackagerExtensionBlockEntity::new, new Supplier[]{PackagedAutoBlocks.PACKAGER_EXTENSION}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<UnpackagerBlockEntity>> UNPACKAGER = BLOCK_ENTITIES.register("unpackager", PackagedAutoBlockEntities.of(AE2_LOADED, () -> () -> AEUnpackagerBlockEntity::new, () -> () -> UnpackagerBlockEntity::new, new Supplier[]{PackagedAutoBlocks.UNPACKAGER}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<DistributorBlockEntity>> DISTRIBUTOR = BLOCK_ENTITIES.register("distributor", PackagedAutoBlockEntities.of(AE2_LOADED, () -> () -> AEDistributorBlockEntity::new, () -> () -> DistributorBlockEntity::new, new Supplier[]{PackagedAutoBlocks.DISTRIBUTOR}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<CrafterBlockEntity>> CRAFTER = BLOCK_ENTITIES.register("crafter", PackagedAutoBlockEntities.of(AE2_LOADED, () -> () -> AECrafterBlockEntity::new, () -> () -> CrafterBlockEntity::new, new Supplier[]{PackagedAutoBlocks.CRAFTER}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FluidPackageFillerBlockEntity>> FLUID_PACKAGE_FILLER = BLOCK_ENTITIES.register("fluid_package_filler", PackagedAutoBlockEntities.of(FluidPackageFillerBlockEntity::new, new Supplier[]{PackagedAutoBlocks.FLUID_PACKAGE_FILLER}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PackagingProviderBlockEntity>> PACKAGING_PROVIDER = BLOCK_ENTITIES.register("packaging_provider", PackagedAutoBlockEntities.of(AE2_LOADED, () -> () -> AEPackagingProviderBlockEntity::new, () -> () -> PackagingProviderBlockEntity::new, new Supplier[]{PackagedAutoBlocks.PACKAGING_PROVIDER}));

    private PackagedAutoBlockEntities() {
    }

    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> of(BlockEntityType.BlockEntitySupplier<? extends T> factory, Supplier<Block> ... validBlocks) {
        return () -> new BlockEntityType(factory, Arrays.stream(validBlocks).map(Supplier::get).filter(Objects::nonNull).collect(Collectors.toSet()), null);
    }

    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> of(BooleanSupplier condition, Supplier<Supplier<BlockEntityType.BlockEntitySupplier<? extends T>>> trueSupplier, Supplier<Supplier<BlockEntityType.BlockEntitySupplier<? extends T>>> falseSupplier, Supplier<Block> ... validBlocks) {
        return () -> new BlockEntityType((BlockEntityType.BlockEntitySupplier)MiscHelper.INSTANCE.conditionalSupplier(condition, trueSupplier, falseSupplier).get(), Arrays.stream(validBlocks).map(Supplier::get).filter(Objects::nonNull).collect(Collectors.toSet()), null);
    }
}

