/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagedAutoBlockEntities;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.inventory.DistributorItemHandler;
import thelm.packagedauto.menu.DistributorMenu;
import thelm.packagedauto.packet.DistributorBeamPacket;
import thelm.packagedauto.recipe.IPositionedProcessingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;

public class DistributorBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine {
    public static int range = 16;
    public final Int2ObjectMap<DirectionalGlobalPos> positions = new Int2ObjectArrayMap(81);
    public final Int2ObjectMap<ItemStack> pending = new Int2ObjectArrayMap(81);

    public DistributorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedAutoBlockEntities.DISTRIBUTOR.get(), pos, state);
        this.setItemHandler(new DistributorItemHandler(this));
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedauto.distributor");
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide && this.level.getGameTime() % 8L == 0L && !this.pending.isEmpty()) {
            this.distributeItems();
        }
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        if (!this.isBusy() && recipeInfo instanceof IPositionedProcessingPackageRecipeInfo) {
            IPositionedProcessingPackageRecipeInfo recipe = (IPositionedProcessingPackageRecipeInfo)recipeInfo;
            boolean blocking = false;
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(direction));
            if (blockEntity instanceof UnpackagerBlockEntity) {
                UnpackagerBlockEntity unpackager = (UnpackagerBlockEntity)blockEntity;
                blocking = unpackager.blocking;
            }
            Int2ObjectMap<ItemStack> matrix = recipe.getMatrix();
            if (!this.positions.keySet().containsAll((IntCollection)matrix.keySet())) {
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                BlockPos pos = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).blockPos();
                if (!this.level.isLoaded(pos)) {
                    return false;
                }
                ItemStack stack = ((ItemStack)entry.getValue()).copy();
                Direction dir = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).direction();
                IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)dir);
                if (stack.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && ((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().hasBlockCapability(this.level, pos, dir)) {
                    if (blocking && !((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().isEmpty(this.level, pos, dir)) {
                        return false;
                    }
                    if (MiscHelper.INSTANCE.fillVolume(this.level, pos, dir, stack, true).getCount() != stack.getCount()) continue;
                    return false;
                }
                if (itemHandler != null) {
                    if (blocking && !MiscHelper.INSTANCE.isEmpty(itemHandler)) {
                        return false;
                    }
                    if (ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)true).getCount() != stack.getCount()) continue;
                    return false;
                }
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                this.pending.put(entry.getIntKey(), (Object)((ItemStack)entry.getValue()).copy());
            }
            this.distributeItems();
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        return !this.pending.isEmpty();
    }

    protected void distributeItems() {
        for (int i : this.pending.keySet().toIntArray()) {
            if (!this.positions.containsKey(i)) {
                this.ejectItems();
                return;
            }
            BlockPos pos = ((DirectionalGlobalPos)this.positions.get(i)).blockPos();
            if (!this.level.isLoaded(pos)) continue;
            ItemStack stack = (ItemStack)this.pending.get(i);
            Direction dir = ((DirectionalGlobalPos)this.positions.get(i)).direction();
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)dir);
            ItemStack stackRem = stack;
            if (stack.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && ((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().hasBlockCapability(this.level, pos, dir)) {
                stackRem = MiscHelper.INSTANCE.fillVolume(this.level, pos, dir, stack, false);
            } else if (itemHandler != null) {
                stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            } else {
                this.ejectItems();
                return;
            }
            if (!this.level.isClientSide && stackRem.getCount() < stack.getCount()) {
                Vec3 source = this.worldPosition.getCenter();
                Vec3 target = pos.getCenter().add((double)dir.getStepX() * 0.5, (double)dir.getStepY() * 0.5, (double)dir.getStepZ() * 0.5);
                DistributorBeamPacket.sendBeam((ServerLevel)this.level, source, target.subtract(source), 32.0);
            }
            if (stackRem.isEmpty()) {
                this.pending.remove(i);
            } else {
                this.pending.put(i, (Object)stackRem);
            }
            this.setChanged();
        }
    }

    protected void ejectItems() {
        for (int i = 0; i < 81; ++i) {
            ItemStack stack;
            if (!this.pending.containsKey(i) || (stack = (ItemStack)this.pending.remove(i)).isEmpty()) continue;
            double dx = (double)(this.level.random.nextFloat() / 2.0f) + 0.25;
            double dy = (double)(this.level.random.nextFloat() / 2.0f) + 0.75;
            double dz = (double)(this.level.random.nextFloat() / 2.0f) + 0.25;
            ItemEntity itemEntity = new ItemEntity(this.level, (double)this.worldPosition.getX() + dx, (double)this.worldPosition.getY() + dy, (double)this.worldPosition.getZ() + dz, stack);
            itemEntity.setDefaultPickUpDelay();
            this.level.addFreshEntity((Entity)itemEntity);
        }
        this.setChanged();
    }

    @Override
    public int getComparatorSignal() {
        if (!this.pending.isEmpty()) {
            return 15;
        }
        return 0;
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.pending.clear();
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        MiscHelper.INSTANCE.loadAllItems(nbt.getList("pending", 10), pendingList, registries);
        for (int i = 0; i < 81 && i < pendingList.size(); ++i) {
            ItemStack stack = (ItemStack)pendingList.get(i);
            if (stack.isEmpty()) continue;
            this.pending.put(i, (Object)stack);
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        for (int i = 0; i < 81; ++i) {
            pendingList.add((ItemStack)this.pending.getOrDefault(i, (Object)ItemStack.EMPTY));
        }
        ListTag pendingTag = MiscHelper.INSTANCE.saveAllItems(new ListTag(), pendingList, registries);
        nbt.put("pending", (Tag)pendingTag);
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new DistributorMenu(windowId, inventory, this);
    }
}

