/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.block.BaseBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagedAutoBlockEntities;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;

public class UnpackagerBlock
extends BaseBlock {
    protected UnpackagerBlock() {
        super(BlockBehaviour.Properties.of().strength(15.0f, 25.0f).mapColor(MapColor.METAL).sound(SoundType.METAL));
    }

    public UnpackagerBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (UnpackagerBlockEntity)((BlockEntityType)PackagedAutoBlockEntities.UNPACKAGER.get()).create(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BaseBlockEntity::tick;
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        UnpackagerBlockEntity.PackageTracker[] packageTrackerArray;
        if (state.getBlock() != newState.getBlock() && (packageTrackerArray = level.getBlockEntity(pos)) instanceof UnpackagerBlockEntity) {
            UnpackagerBlockEntity blockEntity = (UnpackagerBlockEntity)packageTrackerArray;
            for (UnpackagerBlockEntity.PackageTracker tracker : blockEntity.trackers) {
                if (tracker.isEmpty()) continue;
                if (!tracker.toSend.isEmpty()) {
                    for (ItemStack stack : tracker.toSend) {
                        if (stack.isEmpty()) continue;
                        Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
                    }
                    continue;
                }
                List<IPackagePattern> patterns = tracker.recipe.getPatterns();
                for (int i = 0; i < tracker.received.size() && i < patterns.size(); ++i) {
                    if (!tracker.received.getBoolean(i)) continue;
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)patterns.get(i).getOutput());
                }
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        level.getBlockEntity(pos, (BlockEntityType)PackagedAutoBlockEntities.UNPACKAGER.get()).ifPresent(UnpackagerBlockEntity::updatePowered);
    }
}

