/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import thelm.packagedauto.block.BaseBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagedAutoBlockEntities;
import thelm.packagedauto.block.entity.PackagingProviderBlockEntity;

public class PackagingProviderBlock
extends BaseBlock {
    protected PackagingProviderBlock() {
        super(BlockBehaviour.Properties.of().strength(15.0f, 25.0f).mapColor(MapColor.METAL).sound(SoundType.METAL));
    }

    public PackagingProviderBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (PackagingProviderBlockEntity)((BlockEntityType)PackagedAutoBlockEntities.PACKAGING_PROVIDER.get()).create(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BaseBlockEntity::tick;
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Object object;
        if (state.getBlock() != newState.getBlock() && (object = level.getBlockEntity(pos)) instanceof PackagingProviderBlockEntity) {
            PackagingProviderBlockEntity blockEntity = (PackagingProviderBlockEntity)((Object)object);
            if (blockEntity.currentPattern != null) {
                for (ItemStack stack : blockEntity.currentPattern.getInputs()) {
                    if (stack.isEmpty()) continue;
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
                }
            }
            if (!blockEntity.toSend.isEmpty()) {
                for (ItemStack stack : blockEntity.toSend) {
                    if (stack.isEmpty()) continue;
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
                }
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        level.getBlockEntity(pos, (BlockEntityType)PackagedAutoBlockEntities.PACKAGING_PROVIDER.get()).ifPresent(PackagingProviderBlockEntity::updatePowered);
    }
}

