/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import thelm.packagedauto.block.BaseBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.DistributorBlockEntity;
import thelm.packagedauto.block.entity.PackagedAutoBlockEntities;

public class DistributorBlock
extends BaseBlock {
    protected DistributorBlock() {
        super(BlockBehaviour.Properties.of().strength(15.0f, 25.0f).mapColor(MapColor.METAL).sound(SoundType.METAL));
    }

    public DistributorBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (DistributorBlockEntity)((BlockEntityType)PackagedAutoBlockEntities.DISTRIBUTOR.get()).create(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return BaseBlockEntity::tick;
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof DistributorBlockEntity) {
            DistributorBlockEntity blockEntity2 = (DistributorBlockEntity)blockEntity;
            for (Int2ObjectMap.Entry entry : blockEntity2.pending.int2ObjectEntrySet()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)((ItemStack)entry.getValue()));
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }
}

