/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.api;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.ItemCapability;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.PackagedAutoApi;

public interface IVolumeType {
    public static final Codec<IVolumeType> CODEC = ResourceLocation.CODEC.comapFlatMap(DataResult.partialGet(PackagedAutoApi.instance()::getVolumeType, () -> "Unknown volume type "), IVolumeType::getName);
    public static final StreamCodec<ByteBuf, IVolumeType> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(PackagedAutoApi.instance()::getVolumeType, IVolumeType::getName);

    public ResourceLocation getName();

    public Class<?> getTypeClass();

    default public Class<?> getTypeBaseClass() {
        return this.getTypeClass();
    }

    public MutableComponent getDisplayName();

    default public boolean supportsAE() {
        return false;
    }

    default public Optional<?> makeStackFromBase(Object volumeBase, int amount, DataComponentPatch patch) {
        return Optional.empty();
    }

    public IVolumeStackWrapper getEmptyStackInstance();

    public Optional<IVolumeStackWrapper> wrapStack(Object var1);

    public Optional<IVolumeStackWrapper> getStackContained(ItemStack var1);

    public void setStack(ItemStack var1, IVolumeStackWrapper var2);

    public Codec<? extends IVolumeStackWrapper> getStackCodec();

    public StreamCodec<RegistryFriendlyByteBuf, ? extends IVolumeStackWrapper> getStackStreamCodec();

    default public CompoundTag saveRawStack(CompoundTag nbt, IVolumeStackWrapper stack, HolderLookup.Provider registries) {
        Codec codecCast = this.getStackCodec();
        if (!(codecCast instanceof MapCodec.MapCodecCodec)) {
            codecCast = codecCast.fieldOf("stack").codec();
        }
        return nbt.merge(codecCast.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)stack).result().orElse(new CompoundTag()));
    }

    default public IVolumeStackWrapper loadRawStack(CompoundTag nbt, HolderLookup.Provider registries) {
        Codec<? extends IVolumeStackWrapper> codecCast = this.getStackCodec();
        return codecCast.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).result().orElse(this.getEmptyStackInstance());
    }

    public Object makeItemCapability(ItemStack var1);

    public ItemCapability getItemCapability();

    public boolean hasBlockCapability(Level var1, BlockPos var2, Direction var3);

    public boolean isEmpty(Level var1, BlockPos var2, Direction var3);

    public int fill(Level var1, BlockPos var2, Direction var3, IVolumeStackWrapper var4, boolean var5);

    public IVolumeStackWrapper drain(Level var1, BlockPos var2, Direction var3, IVolumeStackWrapper var4, boolean var5);

    public void render(GuiGraphics var1, int var2, int var3, IVolumeStackWrapper var4);
}

