/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.event;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.Utilitarian;
import cy.jdkdigital.utilitarian.module.NoSolicitingModule;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="utilitarian")
public class EventHandler {
    @SubscribeEvent
    static void onTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().is(Items.WIND_CHARGE)) {
            event.getToolTip().add(Component.translatable((String)"utilitarian.wind_charge.tooltip").withStyle(ChatFormatting.AQUA));
        }
    }

    @SubscribeEvent
    static void onEntitySpawn(EntityJoinLevelEvent event) {
        Player player;
        WindCharge windCharge;
        Entity entity;
        Level level;
        if (((Boolean)Config.NO_SOLICITING_ENABLED.get()).booleanValue() && !event.loadedFromDisk() && (level = event.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof LivingEntity && (entity = (LivingEntity)level).getType().is(NoSolicitingModule.ENTITY_BLACKLIST)) {
                BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
                executor.tell((Runnable)new TickTask(0, () -> EventHandler.lambda$onEntitySpawn$0(serverLevel, event, (LivingEntity)entity)));
            }
        }
        if (((Boolean)Config.WIND_CHARGE_AIR_SUPPLY_ENABLED.get()).booleanValue() && !event.getLevel().isClientSide && (entity = event.getEntity()) instanceof WindCharge && (level = (windCharge = (WindCharge)entity).getOwner()) instanceof Player && (player = (Player)level).getAirSupply() < player.getMaxAirSupply()) {
            player.setAirSupply(Math.min(player.getMaxAirSupply(), player.getAirSupply() + (Integer)Config.WIND_CHARGE_AIR_AMOUNT.get()));
        }
    }

    @SubscribeEvent
    public static void canSleep(CanPlayerSleepEvent canPlayerSleepEvent) {
        if (((Boolean)Config.BETTER_SLEEP_ENABLED.get()).booleanValue() && canPlayerSleepEvent.getVanillaProblem() != null) {
            if (canPlayerSleepEvent.getVanillaProblem().equals((Object)Player.BedSleepingProblem.TOO_FAR_AWAY)) {
                canPlayerSleepEvent.setProblem(null);
            } else if (canPlayerSleepEvent.getVanillaProblem().equals((Object)Player.BedSleepingProblem.NOT_SAFE)) {
                canPlayerSleepEvent.setProblem(null);
            }
        }
    }

    @SubscribeEvent
    public static void blockToolModified(BlockEvent.BlockToolModificationEvent event) {
        LevelAccessor levelAccessor;
        if (((Boolean)Config.HOE_PLANTING_ENABLED.get()).booleanValue() && !event.isSimulated() && event.getItemAbility().equals(ItemAbilities.HOE_TILL) && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            if (event.getPlayer() != null && level.getBlockState(event.getPos().above()).canBeReplaced()) {
                ItemStack slotItem;
                ItemStack seedStack = ItemStack.EMPTY;
                if (event.getPlayer().getOffhandItem().is(Tags.Items.SEEDS)) {
                    seedStack = event.getPlayer().getOffhandItem();
                    event.getPlayer().swing(InteractionHand.OFF_HAND);
                } else {
                    for (int i = 0; i <= 9; ++i) {
                        slotItem = event.getPlayer().getInventory().getItem(i);
                        if (slotItem.isEmpty() || !slotItem.is(Tags.Items.SEEDS)) continue;
                        seedStack = slotItem;
                        event.getPlayer().swing(InteractionHand.MAIN_HAND);
                        break;
                    }
                }
                if (!seedStack.isEmpty() && !seedStack.is(Utilitarian.BLACKLISTED_SEEDS) && (slotItem = seedStack.getItem()) instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)slotItem;
                    ItemStack usedSeedStack = seedStack;
                    BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
                    executor.tell((Runnable)new TickTask(0, () -> {
                        if (level.getBlockState(event.getPos()).getBlock() instanceof FarmBlock) {
                            BlockHitResult hitResult = new BlockHitResult(Vec3.ZERO, Direction.UP, event.getPos(), false);
                            BlockState blockState = blockItem.getBlock().getStateForPlacement(new BlockPlaceContext((Level)level, event.getPlayer(), event.getContext().getHand(), usedSeedStack, hitResult));
                            if (blockState != null) {
                                level.setBlock(event.getPos().above(), blockItem.getBlock().defaultBlockState(), 3);
                                if (!event.getPlayer().isCreative()) {
                                    usedSeedStack.shrink(1);
                                }
                            }
                        }
                    }));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSystemMessage(ClientChatReceivedEvent.System event) {
        if (((Boolean)Config.NO_STARTUP_MESSAGES_ENABLED.get()).booleanValue()) {
            ((List)Config.NO_STARTUP_MESSAGES_MESSAGE_STRINGS.get()).forEach(s -> {
                if (event.getMessage().getString().contains((CharSequence)s)) {
                    Utilitarian.LOGGER.debug("Blocked message: \"" + event.getMessage().getString() + "\"");
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (((Boolean)Config.NO_TRAMPLE_ENABLED.get()).booleanValue() && !event.getEntity().getType().is(Utilitarian.TRAMPLING_ENTITIES)) {
            event.setCanceled(true);
        }
    }

    private static /* synthetic */ void lambda$onEntitySpawn$0(ServerLevel serverLevel, EntityJoinLevelEvent event, LivingEntity entity) {
        List<BlockPos> nearbySoliciting = NoSolicitingModule.locateNearbySoliciting(serverLevel, event.getEntity().blockPosition());
        if (!nearbySoliciting.isEmpty()) {
            BlockPos pos = nearbySoliciting.getFirst();
            entity.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            if (serverLevel.getBlockState(pos).is(NoSolicitingModule.TRAPPED_SOLICITING_CARPETS)) {
                entity.kill();
            }
        } else {
            int nearbyNoSolicitingCount = NoSolicitingModule.locateNearbyNoSoliciting(serverLevel, event.getEntity().blockPosition());
            if (nearbyNoSolicitingCount > 0) {
                entity.discard();
            }
        }
    }
}

