/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.module.SnadModule;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;

public class SnadBlock
extends ColoredFallingBlock {
    public SnadBlock(ColorRGBA pDustColor, BlockBehaviour.Properties pProperties) {
        super(pDustColor, pProperties);
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.randomTick(pState, pLevel, pPos, pRandom);
        this.tick(pState, pLevel, pPos, pRandom);
    }

    protected void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        BlockState plantBlock = pLevel.getBlockState(pPos.above());
        if (plantBlock.is(SnadModule.SAND_GROWABLES)) {
            int i = 2;
            while (pLevel.getBlockState(pPos.above(i)).is(plantBlock.getBlock())) {
                ++i;
            }
            BlockState state = pLevel.getBlockState(pPos.above(i - 1));
            if (state.hasProperty((Property)BlockStateProperties.AGE_15) && i < 4 + (Integer)Config.SNAD_ADDITIONAL_HEIGHT.get() && pPos.above(i).getY() < pLevel.getMaxBuildHeight() && pLevel.getBlockState(pPos.above(i)).canBeReplaced()) {
                if ((Integer)state.getValue((Property)BlockStateProperties.AGE_15) == 15) {
                    if (CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (boolean)true)) {
                        pLevel.setBlockAndUpdate(pPos.above(i), plantBlock.getBlock().defaultBlockState());
                        pLevel.setBlock(pPos.above(i - 1), (BlockState)state.setValue((Property)BlockStateProperties.AGE_15, (Comparable)Integer.valueOf(0)), 4);
                        CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos.above(), (BlockState)plantBlock.getBlock().defaultBlockState());
                    }
                } else {
                    pLevel.setBlock(pPos.above(i - 1), (BlockState)state.setValue((Property)BlockStateProperties.AGE_15, (Comparable)Integer.valueOf(Math.min(15, (Integer)state.getValue((Property)BlockStateProperties.AGE_15) + (Integer)Config.SNAD_GROWTH_MULTIPLIER.get()))), 4);
                }
            } else {
                for (int u = 0; u < (Integer)Config.SNAD_GROWTH_MULTIPLIER.get(); ++u) {
                    state.randomTick(pLevel, pPos.above(i), pRandom);
                }
            }
        }
    }
}

