/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.network;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BulkTransferAllMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<BulkTransferAllMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"inventoryessentials", (String)"bulk_transfer_all"));
    private final int slotNumber;

    public BulkTransferAllMessage(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public static BulkTransferAllMessage decode(FriendlyByteBuf buf) {
        byte slotNumber = buf.readByte();
        return new BulkTransferAllMessage(slotNumber);
    }

    public static void encode(FriendlyByteBuf buf, BulkTransferAllMessage message) {
        buf.writeByte(message.slotNumber);
    }

    public static void handle(ServerPlayer player, BulkTransferAllMessage message) {
        block7: {
            AbstractContainerMenu menu = player.containerMenu;
            if (menu == null || message.slotNumber < 0 || message.slotNumber >= menu.slots.size()) break block7;
            Slot clickedSlot = (Slot)menu.slots.get(message.slotNumber);
            boolean isProbablyMovingToPlayerInventory = false;
            if (!(clickedSlot.container instanceof Inventory)) {
                isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
            }
            if (isProbablyMovingToPlayerInventory) {
                ArrayDeque<Slot> emptySlots = new ArrayDeque<Slot>();
                ArrayList<Slot> nonEmptySlots = new ArrayList<Slot>();
                for (Slot slot : menu.slots) {
                    if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.container instanceof Inventory)) continue;
                    if (slot.hasItem()) {
                        nonEmptySlots.add(slot);
                        continue;
                    }
                    if (Inventory.isHotbarSlot((int)slot.getContainerSlot())) continue;
                    emptySlots.add(slot);
                }
                for (Slot slot : menu.slots) {
                    if (!slot.mayPickup((Player)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                    BulkTransferAllMessage.bulkTransferPreferInventory((Player)player, menu, emptySlots, nonEmptySlots, slot);
                }
            } else {
                for (Slot slot : menu.slots) {
                    if (!slot.mayPickup((Player)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                    menu.clicked(slot.index, 0, ClickType.QUICK_MOVE, (Player)player);
                }
            }
        }
    }

    private static boolean bulkTransferPreferInventory(Player player, AbstractContainerMenu menu, Deque<Slot> emptySlots, List<Slot> nonEmptySlots, Slot slot) {
        Inventory playerInventory = player.getInventory();
        ItemStack targetStack = slot.getItem().copy();
        if (targetStack.isEmpty()) {
            return false;
        }
        menu.clicked(slot.index, 0, ClickType.PICKUP, player);
        for (Slot nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            ItemStack stack = slot.getItem();
            if (!ItemStack.isSameItemSameComponents((ItemStack)targetStack, (ItemStack)stack)) continue;
            boolean bl = hasSpaceLeft = stack.getCount() < Math.min(slot.getMaxStackSize(), slot.getMaxStackSize(stack));
            if (!hasSpaceLeft) continue;
            menu.clicked(nonEmptySlot.index, 0, ClickType.PICKUP, player);
            ItemStack mouseItem = menu.getCarried();
            if (!mouseItem.isEmpty()) continue;
            return true;
        }
        Iterator<Slot> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            ItemStack mouseItem;
            Slot emptySlot = iterator.next();
            menu.clicked(emptySlot.index, 0, ClickType.PICKUP, player);
            if (emptySlot.hasItem()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if (!(mouseItem = menu.getCarried()).isEmpty()) continue;
            return true;
        }
        ItemStack mouseItem = menu.getCarried();
        if (!mouseItem.isEmpty()) {
            menu.clicked(slot.index, 0, ClickType.PICKUP, player);
        }
        return false;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

