/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.config.Config;
import com.google.gson.JsonObject;

public final class DebugConfig
extends Config {
    public static final String NAME = "debug";
    public static final DebugSerializer SERIALIZER = new DebugSerializer();
    private final boolean dumpDuplicates;
    private final boolean dumpOverview;
    private final boolean dumpRecipes;
    private final boolean dumpTags;
    private final boolean dumpUnification;
    private final boolean logInvalidTags;

    private DebugConfig(boolean dumpDuplicates, boolean dumpOverview, boolean dumpRecipes, boolean dumpTags, boolean dumpUnification, boolean logInvalidTags) {
        super(NAME);
        this.dumpDuplicates = dumpDuplicates;
        this.dumpOverview = dumpOverview;
        this.dumpRecipes = dumpRecipes;
        this.dumpTags = dumpTags;
        this.dumpUnification = dumpUnification;
        this.logInvalidTags = logInvalidTags;
    }

    public boolean shouldDumpDuplicates() {
        return this.dumpDuplicates;
    }

    public boolean shouldDumpOverview() {
        return this.dumpOverview;
    }

    public boolean shouldDumpRecipes() {
        return this.dumpRecipes;
    }

    public boolean shouldDumpTags() {
        return this.dumpTags;
    }

    public boolean shouldDumpUnification() {
        return this.dumpUnification;
    }

    public boolean shouldLogInvalidTags() {
        return this.logInvalidTags;
    }

    public static final class DebugSerializer
    extends Config.Serializer<DebugConfig> {
        private static final String DUMP_DUPLICATES = "dump_duplicates";
        private static final String DUMP_OVERVIEW = "dump_overview";
        private static final String DUMP_RECIPES = "dump_recipes";
        private static final String DUMP_TAGS = "dump_tags";
        private static final String DUMP_UNIFICATION = "dump_unification";
        private static final String LOG_INVALID_TAGS = "log_invalid_tags";

        private DebugSerializer() {
        }

        @Override
        public DebugConfig handleDeserialization(JsonObject json) {
            return new DebugConfig(this.safeGet(() -> json.get(DUMP_DUPLICATES).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_OVERVIEW).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_RECIPES).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_TAGS).getAsBoolean(), false), this.safeGet(() -> json.get(DUMP_UNIFICATION).getAsBoolean(), false), this.safeGet(() -> json.get(LOG_INVALID_TAGS).getAsBoolean(), false));
        }

        @Override
        public JsonObject serialize(DebugConfig config) {
            JsonObject json = new JsonObject();
            json.addProperty(DUMP_DUPLICATES, Boolean.valueOf(config.dumpDuplicates));
            json.addProperty(DUMP_OVERVIEW, Boolean.valueOf(config.dumpOverview));
            json.addProperty(DUMP_RECIPES, Boolean.valueOf(config.dumpRecipes));
            json.addProperty(DUMP_TAGS, Boolean.valueOf(config.dumpTags));
            json.addProperty(DUMP_UNIFICATION, Boolean.valueOf(config.dumpUnification));
            json.addProperty(LOG_INVALID_TAGS, Boolean.valueOf(config.logInvalidTags));
            return json;
        }
    }
}

