/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.AEItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gripe._90.megacells.definition.MEGAComponents;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.misc.CompressionChain;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DecompressionPattern
implements IPatternDetails {
    private final AEItemKey definition;
    private final AEItemKey base;
    private final AEItemKey variant;
    private final int factor;

    public DecompressionPattern(AEItemKey definition) {
        this.definition = definition;
        Encoded encodedPattern = (Encoded)definition.get(MEGAComponents.ENCODED_DECOMPRESSION_PATTERN);
        if (encodedPattern == null) {
            throw new IllegalArgumentException("Given item does not encode a decompression pattern: " + String.valueOf(definition));
        }
        if (encodedPattern.containsMissingContent()) {
            throw new IllegalArgumentException("Pattern references missing content");
        }
        this.base = AEItemKey.of((ItemStack)encodedPattern.base);
        this.variant = AEItemKey.of((ItemStack)encodedPattern.variant);
        this.factor = encodedPattern.factor;
    }

    public DecompressionPattern(AEItemKey base, CompressionChain.Variant variant) {
        this.base = base;
        this.variant = variant.item();
        this.factor = variant.factor();
        ItemStack definition = new ItemStack(MEGAItems.DECOMPRESSION_PATTERN);
        definition.set(MEGAComponents.ENCODED_DECOMPRESSION_PATTERN, (Object)new Encoded(base.toStack(), variant.item().toStack(), variant.factor()));
        this.definition = AEItemKey.of((ItemStack)definition);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return new IPatternDetails.IInput[]{new Input(this.variant)};
    }

    public List<GenericStack> getOutputs() {
        return List.of(new GenericStack((AEKey)this.base, (long)this.factor));
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((DecompressionPattern)obj).definition.equals((Object)this.definition);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public record Encoded(ItemStack base, ItemStack variant, int factor) {
        public static final Codec<Encoded> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.CODEC.fieldOf("base").forGetter(Encoded::base), (App)ItemStack.CODEC.fieldOf("variant").forGetter(Encoded::variant), (App)Codec.INT.fieldOf("factor").forGetter(Encoded::factor)).apply((Applicative)builder, Encoded::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Encoded> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, Encoded::base, (StreamCodec)ItemStack.STREAM_CODEC, Encoded::variant, (StreamCodec)ByteBufCodecs.VAR_INT, Encoded::factor, Encoded::new);

        private boolean containsMissingContent() {
            return AEItems.MISSING_CONTENT.is(this.base) || AEItems.MISSING_CONTENT.is(this.variant);
        }
    }

    private record Input(AEItemKey input) implements IPatternDetails.IInput
    {
        public GenericStack[] getPossibleInputs() {
            return new GenericStack[]{new GenericStack((AEKey)this.input, 1L)};
        }

        public long getMultiplier() {
            return 1L;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.getPossibleInputs()[0]);
        }

        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

