/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.networking.GridServices;
import appeng.api.stacks.AEItemKey;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGATags;
import gripe._90.megacells.misc.CompressionChain;
import gripe._90.megacells.misc.DecompressionService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.NeoForge;

public class CompressionService {
    private static final Set<CompressionChain> compressionChains = new HashSet<CompressionChain>();
    private static final Set<Override> overrides = new HashSet<Override>();

    public static Optional<CompressionChain> getChain(AEItemKey item) {
        return compressionChains.stream().filter(chain -> chain.containsVariant(item)).findFirst();
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(event -> {
            MinecraftServer server = event.getServer();
            CompressionService.loadRecipes(server.getRecipeManager(), (RegistryAccess)server.registryAccess());
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            if (event.getPlayer() == null) {
                MinecraftServer server = event.getPlayerList().getServer();
                CompressionService.loadRecipes(server.getRecipeManager(), (RegistryAccess)server.registryAccess());
            }
        });
        GridServices.register(DecompressionService.class, DecompressionService.class);
    }

    private static void loadRecipes(RecipeManager recipeManager, RegistryAccess access) {
        compressionChains.clear();
        overrides.clear();
        ArrayList<CraftingRecipe> compressed = new ArrayList<CraftingRecipe>();
        ArrayList<CraftingRecipe> decompressed = new ArrayList<CraftingRecipe>();
        for (RecipeHolder recipe2 : recipeManager.getAllRecipesFor(RecipeType.CRAFTING)) {
            if (CompressionService.isCompressionRecipe((CraftingRecipe)recipe2.value(), access)) {
                compressed.add((CraftingRecipe)recipe2.value());
                continue;
            }
            if (!CompressionService.isDecompressionRecipe((CraftingRecipe)recipe2.value(), access)) continue;
            decompressed.add((CraftingRecipe)recipe2.value());
        }
        compressed.removeIf(recipe -> CompressionService.isIrreversible(recipe, decompressed, access));
        decompressed.removeIf(recipe -> CompressionService.isIrreversible(recipe, compressed, access));
        Comparator<CraftingRecipe> ingredientSize = Comparator.comparingInt(r -> ((Ingredient)r.getIngredients().getFirst()).getItems().length);
        compressed.sort(ingredientSize);
        decompressed.sort(ingredientSize);
        Stream.concat(compressed.stream(), decompressed.stream()).forEach(recipe -> {
            Item baseVariant = recipe.getResultItem((HolderLookup.Provider)access).getItem();
            if (CompressionService.getChain(AEItemKey.of((ItemLike)baseVariant)).isEmpty()) {
                compressionChains.add(CompressionService.generateChain(baseVariant, compressed, decompressed, access));
            }
        });
    }

    private static CompressionChain generateChain(Item baseVariant, List<CraftingRecipe> compressed, List<CraftingRecipe> decompressed, RegistryAccess access) {
        LinkedList<Item> variants = new LinkedList<Item>();
        LinkedList<Integer> multipliers = new LinkedList<Integer>();
        variants.addFirst(baseVariant);
        CompressionChain.Variant lower = CompressionService.getNextVariant(baseVariant, decompressed, false, access);
        while (lower != null) {
            Item item = lower.item().getItem();
            if (variants.contains(item)) {
                MEGACells.LOGGER.warn("Duplicate lower compression variant detected: {}. Check any recipe involving this item for problems.", (Object)lower);
                break;
            }
            variants.addFirst(item);
            multipliers.addFirst(lower.factor());
            lower = CompressionService.getNextVariant(item, decompressed, false, access);
        }
        multipliers.addFirst(1);
        CompressionChain chain = new CompressionChain();
        for (int i = 0; i < variants.size(); ++i) {
            chain.add(AEItemKey.of((ItemLike)((ItemLike)variants.get(i))), (Integer)multipliers.get(i));
        }
        CompressionChain.Variant higher = CompressionService.getNextVariant(baseVariant, compressed, true, access);
        while (higher != null) {
            if (chain.contains(higher)) {
                MEGACells.LOGGER.warn("Duplicate higher compression variant detected: {}. Check any recipe involving this item for problems.", (Object)higher);
                break;
            }
            chain.add(higher);
            higher = CompressionService.getNextVariant(higher.item().getItem(), compressed, true, access);
        }
        return chain;
    }

    private static CompressionChain.Variant getNextVariant(Item item, List<CraftingRecipe> recipes, boolean compressed, RegistryAccess access) {
        for (Override override : overrides) {
            if (compressed && override.smaller.equals(item)) {
                return new CompressionChain.Variant(override.larger, override.factor);
            }
            if (compressed || !override.larger.equals(item)) continue;
            return new CompressionChain.Variant(override.smaller, override.factor);
        }
        for (CraftingRecipe recipe : recipes) {
            for (ItemStack input : ((Ingredient)recipe.getIngredients().getFirst()).getItems()) {
                if (!input.getItem().equals(item)) continue;
                return new CompressionChain.Variant(recipe.getResultItem((HolderLookup.Provider)access).getItem(), compressed ? recipe.getIngredients().size() : recipe.getResultItem((HolderLookup.Provider)access).getCount());
            }
        }
        return null;
    }

    private static boolean isDecompressionRecipe(CraftingRecipe recipe, RegistryAccess access) {
        return recipe.getIngredients().stream().filter(i -> !i.isEmpty()).count() == 1L && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(recipe.getResultItem((HolderLookup.Provider)access).getCount());
    }

    private static boolean isCompressionRecipe(CraftingRecipe recipe, RegistryAccess access) {
        NonNullList ingredients = recipe.getIngredients();
        return recipe.getResultItem((HolderLookup.Provider)access).getCount() == 1 && ingredients.stream().noneMatch(Ingredient::isEmpty) && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(ingredients.size()) && CompressionService.sameIngredient(recipe);
    }

    private static boolean sameIngredient(CraftingRecipe recipe) {
        NonNullList ingredients = recipe.getIngredients();
        if (recipe instanceof ShapedRecipe) {
            return ingredients.stream().distinct().count() <= 1L;
        }
        ItemStack[] first = ((Ingredient)ingredients.getFirst()).getItems();
        for (Ingredient ingredient : ingredients) {
            ItemStack[] stacks = ingredient.getItems();
            if (stacks.length != first.length) {
                return false;
            }
            for (int i = 0; i < stacks.length; ++i) {
                if (ItemStack.isSameItemSameComponents((ItemStack)stacks[i], (ItemStack)first[i])) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isIrreversible(CraftingRecipe recipe, List<CraftingRecipe> candidates, RegistryAccess access) {
        if (CompressionService.overrideRecipe(recipe, access)) {
            return false;
        }
        ItemStack[] testInput = ((Ingredient)recipe.getIngredients().getFirst()).getItems();
        Item testOutput = recipe.getResultItem((HolderLookup.Provider)access).getItem();
        for (CraftingRecipe candidate : candidates) {
            ItemStack[] input = ((Ingredient)candidate.getIngredients().getFirst()).getItems();
            Item output = candidate.getResultItem((HolderLookup.Provider)access).getItem();
            boolean compressible = Arrays.stream(input).anyMatch(i -> i.is(testOutput));
            boolean decompressible = Arrays.stream(testInput).anyMatch(i -> i.is(output));
            if (!compressible || !decompressible) continue;
            return false;
        }
        return true;
    }

    private static boolean overrideRecipe(CraftingRecipe recipe, RegistryAccess access) {
        for (ItemStack input : ((Ingredient)recipe.getIngredients().getFirst()).getItems()) {
            if (!input.is(MEGATags.COMPRESSION_OVERRIDES)) continue;
            boolean compressed = !CompressionService.isDecompressionRecipe(recipe, access);
            ItemStack output = recipe.getResultItem((HolderLookup.Provider)access);
            Item smaller = (compressed ? input : output).getItem();
            Item larger = (compressed ? output : input).getItem();
            int factor = compressed ? recipe.getIngredients().size() : output.getCount();
            overrides.add(new Override(smaller, larger, factor));
            return true;
        }
        return false;
    }

    private record Override(Item smaller, Item larger, int factor) {
    }
}

