/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.stacks.AEItemKey;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class CompressionChain
extends ObjectArrayList<Variant> {
    void add(AEItemKey item, int factor) {
        this.add(new Variant(item, factor));
    }

    public boolean containsVariant(AEItemKey item) {
        return this.stream().anyMatch(v -> v.item().equals((Object)item));
    }

    public BigInteger unitFactor(AEItemKey item) {
        return this.stream().filter(v -> v.item().equals((Object)item)).findFirst().map(i -> IntStream.rangeClosed(0, this.indexOf(i)).mapToObj(arg_0 -> ((CompressionChain)this).get(arg_0)).map(v -> BigInteger.valueOf(v.factor())).reduce(BigInteger.ONE, BigInteger::multiply)).orElse(BigInteger.ONE);
    }

    public CompressionChain lastMultiplierSwapped() {
        List multipliers = this.stream().map(Variant::factor).collect(Collectors.toList());
        Collections.rotate(multipliers, -1);
        List<AEItemKey> items = this.stream().map(Variant::item).toList();
        CompressionChain chain = new CompressionChain();
        for (int i = 0; i < items.size(); ++i) {
            chain.add(items.get(i), (Integer)multipliers.get(i));
        }
        return chain;
    }

    public record Variant(AEItemKey item, int factor) {
        Variant(Item item, int factor) {
            this(AEItemKey.of((ItemLike)item), factor);
        }
    }
}

