/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.part;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.PriorityMenu;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.misc.DecompressionPattern;
import gripe._90.megacells.misc.DecompressionService;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class DecompressionModulePart
extends AEBasePart
implements ICraftingProvider,
IPriorityHost,
IGridTickable {
    @PartModels
    public static final IPartModel MODEL = new PartModel(MEGACells.makeId("part/decompression_module"));
    private final Object2LongMap<AEKey> outputs = new Object2LongOpenHashMap();
    private int priority = 0;

    public DecompressionModulePart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).addService(IGridTickable.class, (IGridNodeService)this).addService(ICraftingProvider.class, (IGridNodeService)this).setIdlePowerUsage(10.0);
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        data.putInt("priority", this.priority);
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.priority = data.getInt("priority");
    }

    public List<IPatternDetails> getAvailablePatterns() {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null ? ((DecompressionService)grid.getService(DecompressionService.class)).getPatterns() : List.of();
    }

    public int getPatternPriority() {
        return this.priority;
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!this.getMainNode().isActive() || !(patternDetails instanceof DecompressionPattern)) {
            return false;
        }
        DecompressionPattern pattern = (DecompressionPattern)patternDetails;
        GenericStack output = pattern.getPrimaryOutput();
        this.outputs.merge((Object)output.what(), output.amount(), Long::sum);
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
        return true;
    }

    public boolean isBusy() {
        return false;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 12.0, 13.0, 13.0, 16.0);
        bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 12.0);
    }

    public IPartModel getStaticModels() {
        return MODEL;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 1, this.outputs.isEmpty());
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        MEStorage storage = node.getGrid().getStorageService().getInventory();
        for (Object2LongMap.Entry output : new Object2LongOpenHashMap(this.outputs).object2LongEntrySet()) {
            long amount;
            AEKey what = (AEKey)output.getKey();
            long inserted = storage.insert(what, amount = output.getLongValue(), Actionable.MODULATE, IActionSource.ofMachine((IActionHost)this));
            if (inserted >= amount) {
                this.outputs.removeLong((Object)what);
                continue;
            }
            if (inserted <= 0L) continue;
            this.outputs.put((Object)what, amount - inserted);
        }
        return TickRateModulation.URGENT;
    }

    public boolean onUseWithoutItem(Player player, Vec3 pos) {
        if (!player.getCommandSenderWorld().isClientSide()) {
            MenuOpener.open((MenuType)PriorityMenu.TYPE, (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newPriority) {
        this.priority = newPriority;
        this.getHost().markForSave();
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.closeContainer();
        }
    }

    public ItemStack getMainMenuIcon() {
        return MEGAItems.DECOMPRESSION_MODULE.stack();
    }
}

