/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.client;

import appeng.api.client.StorageCellModels;
import appeng.block.networking.EnergyCellBlockItem;
import appeng.client.gui.implementations.InterfaceScreen;
import appeng.client.gui.implementations.PatternProviderScreen;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.client.render.crafting.CraftingMonitorRenderer;
import appeng.core.AppEng;
import appeng.hooks.BuiltInModelHooks;
import appeng.init.client.InitScreens;
import appeng.items.storage.BasicStorageCell;
import appeng.items.tools.powered.PortableCellItem;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.block.MEGACraftingUnitType;
import gripe._90.megacells.client.render.MEGACraftingUnitModelProvider;
import gripe._90.megacells.definition.MEGABlockEntities;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGAMenus;
import java.util.ArrayList;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@Mod(value="megacells", dist={Dist.CLIENT})
public class MEGACellsClient {
    public MEGACellsClient(IEventBus eventBus) {
        eventBus.addListener(MEGACellsClient::initScreens);
        eventBus.addListener(MEGACellsClient::initCraftingUnitModels);
        eventBus.addListener(MEGACellsClient::initEnergyCellProps);
        eventBus.addListener(MEGACellsClient::initStorageCellModels);
        eventBus.addListener(MEGACellsClient::initItemColours);
    }

    private static void initScreens(RegisterMenuScreensEvent event) {
        InitScreens.register((RegisterMenuScreensEvent)event, MEGAMenus.MEGA_INTERFACE, InterfaceScreen::new, (String)"/screens/megacells/mega_interface.json");
        InitScreens.register((RegisterMenuScreensEvent)event, MEGAMenus.MEGA_PATTERN_PROVIDER, PatternProviderScreen::new, (String)"/screens/megacells/mega_pattern_provider.json");
    }

    private static void initCraftingUnitModels(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            for (MEGACraftingUnitType type : MEGACraftingUnitType.values()) {
                BuiltInModelHooks.addBuiltInModel((ResourceLocation)MEGACells.makeId("block/crafting/" + type.getAffix() + "_formed"), (UnbakedModel)new CraftingCubeModel((AbstractCraftingUnitModelProvider)new MEGACraftingUnitModelProvider(type)));
            }
            BlockEntityRenderers.register(MEGABlockEntities.MEGA_CRAFTING_MONITOR.get(), CraftingMonitorRenderer::new);
        });
    }

    private static void initEnergyCellProps(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)MEGABlocks.MEGA_ENERGY_CELL.asItem(), (ResourceLocation)AppEng.makeId((String)"fill_level"), (is, level, entity, i) -> {
            EnergyCellBlockItem energyCell = (EnergyCellBlockItem)MEGABlocks.MEGA_ENERGY_CELL.asItem();
            double curPower = energyCell.getAECurrentPower(is);
            double maxPower = energyCell.getAEMaxPower(is);
            return (float)(curPower / maxPower);
        }));
    }

    private static void initStorageCellModels(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            String modelPrefix = "block/drive/cells/";
            for (MEGAItems.CellDefinition cell : MEGAItems.getTieredCells()) {
                StorageCellModels.registerModel(cell.item(), (ResourceLocation)MEGACells.makeId(modelPrefix + cell.tier().namePrefix() + "_" + cell.keyType() + "_cell"));
            }
            StorageCellModels.registerModel(MEGAItems.BULK_ITEM_CELL, (ResourceLocation)MEGACells.makeId(modelPrefix + MEGAItems.BULK_ITEM_CELL.id().getPath()));
            StorageCellModels.registerModel(MEGAItems.RADIOACTIVE_CHEMICAL_CELL, (ResourceLocation)MEGACells.makeId(modelPrefix + MEGAItems.RADIOACTIVE_CHEMICAL_CELL.id().getPath()));
        });
    }

    private static void initItemColours(RegisterColorHandlersEvent.Item event) {
        ArrayList standardCells = new ArrayList();
        ArrayList portableCells = new ArrayList();
        for (MEGAItems.CellDefinition cell : MEGAItems.getTieredCells()) {
            if (cell.portable()) {
                portableCells.add(cell.item());
                continue;
            }
            standardCells.add(cell.item());
        }
        standardCells.add(MEGAItems.BULK_ITEM_CELL);
        standardCells.add(MEGAItems.RADIOACTIVE_CHEMICAL_CELL);
        event.register((stack, tintIndex) -> FastColor.ARGB32.opaque((int)BasicStorageCell.getColor((ItemStack)stack, (int)tintIndex)), standardCells.toArray(new ItemLike[0]));
        event.register((stack, tintIndex) -> FastColor.ARGB32.opaque((int)PortableCellItem.getColor((ItemStack)stack, (int)tintIndex)), portableCells.toArray(new ItemLike[0]));
    }
}

