/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.block;

import appeng.api.networking.IManagedGridNode;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseEntityBlock;
import appeng.block.crafting.PatternProviderBlock;
import appeng.block.crafting.PushDirection;
import appeng.core.definitions.AEItems;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.filter.AEItemDefinitionFilter;
import appeng.util.inv.filter.IAEItemFilter;
import gripe._90.megacells.block.entity.MEGAPatternProviderBlockEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class MEGAPatternProviderBlock
extends AEBaseEntityBlock<MEGAPatternProviderBlockEntity> {
    private static final EnumProperty<PushDirection> PUSH_DIRECTION = PatternProviderBlock.PUSH_DIRECTION;

    public MEGAPatternProviderBlock() {
        super(AEBaseBlock.metalProps());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(PUSH_DIRECTION, (Comparable)PushDirection.ALL));
    }

    public static PatternProviderLogic createLogic(IManagedGridNode mainNode, PatternProviderLogicHost host) {
        PatternProviderLogic logic = new PatternProviderLogic(mainNode, host, 18);
        AEItemDefinitionFilter filter = new AEItemDefinitionFilter(AEItems.PROCESSING_PATTERN);
        ((AppEngInternalInventory)logic.getPatternInv()).setFilter((IAEItemFilter)filter);
        return logic;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PUSH_DIRECTION});
    }

    @ParametersAreNonnullByDefault
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        MEGAPatternProviderBlockEntity be = (MEGAPatternProviderBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            be.getLogic().updateRedstoneState();
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            return InteractionResult.PASS;
        }
        MEGAPatternProviderBlockEntity be = (MEGAPatternProviderBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            if (!level.isClientSide()) {
                be.openMenu(player, MenuLocators.forBlockEntity((BlockEntity)be));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (InteractionUtil.canWrenchRotate((ItemStack)heldItem)) {
            this.setSide(level, pos, hit.getDirection());
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void setSide(Level level, BlockPos pos, Direction facing) {
        BlockState currentState = level.getBlockState(pos);
        Direction pushSide = ((PushDirection)currentState.getValue(PUSH_DIRECTION)).getDirection();
        PushDirection newPushDirection = pushSide == facing.getOpposite() ? PushDirection.fromDirection((Direction)facing) : (pushSide == facing ? PushDirection.ALL : (pushSide == null ? PushDirection.fromDirection((Direction)facing.getOpposite()) : PushDirection.fromDirection((Direction)Platform.rotateAround((Direction)pushSide, (Direction)facing))));
        level.setBlockAndUpdate(pos, (BlockState)currentState.setValue(PUSH_DIRECTION, (Comparable)newPushDirection));
    }
}

