/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells;

import appeng.api.AECapabilities;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.hotkeys.HotkeyActions;
import appeng.init.InitVillager;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import gripe._90.megacells.definition.MEGABlockEntities;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGAComponents;
import gripe._90.megacells.definition.MEGAConfig;
import gripe._90.megacells.definition.MEGACreativeTab;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGAMenus;
import gripe._90.megacells.definition.MEGATranslations;
import gripe._90.megacells.integration.Addons;
import gripe._90.megacells.integration.appmek.RadioactiveCellItem;
import gripe._90.megacells.item.cell.BulkCellItem;
import gripe._90.megacells.misc.CompressionService;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="megacells")
public class MEGACells {
    public static final String MODID = "megacells";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)MEGATranslations.ModName.getEnglishText());

    public MEGACells(ModContainer container, IEventBus eventBus) {
        MEGABlocks.DR.register(eventBus);
        MEGAItems.DR.register(eventBus);
        MEGABlockEntities.DR.register(eventBus);
        MEGAMenus.DR.register(eventBus);
        MEGAComponents.DR.register(eventBus);
        MEGACreativeTab.DR.register(eventBus);
        eventBus.addListener(MEGACells::initUpgrades);
        eventBus.addListener(MEGACells::initStorageCells);
        eventBus.addListener(MEGACells::initCapabilities);
        eventBus.addListener(MEGACells::initVillagerTrades);
        CompressionService.init();
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MEGAConfig.SPEC);
    }

    public static ResourceLocation makeId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private static void initUpgrades(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            String storageCellGroup = GuiText.StorageCells.getTranslationKey();
            String portableCellGroup = GuiText.PortableCells.getTranslationKey();
            String interfaceGroup = GuiText.Interface.getTranslationKey();
            String wirelessTerminalGroup = GuiText.WirelessTerminals.getTranslationKey();
            for (MEGAItems.CellDefinition cell : MEGAItems.getTieredCells()) {
                if (!cell.keyType().equals("item") && !cell.keyType().equals("fluid")) continue;
                Upgrades.add((ItemLike)AEItems.INVERTER_CARD, cell.item(), (int)1, (String)storageCellGroup);
                Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, cell.item(), (int)1, (String)storageCellGroup);
                Upgrades.add((ItemLike)AEItems.VOID_CARD, cell.item(), (int)1, (String)storageCellGroup);
                if (cell.keyType().equals("item")) {
                    Upgrades.add((ItemLike)AEItems.FUZZY_CARD, cell.item(), (int)1, (String)storageCellGroup);
                }
                if (!cell.portable()) continue;
                Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, cell.item(), (int)2, (String)portableCellGroup);
            }
            Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, MEGABlocks.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, MEGAItems.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add((ItemLike)AEItems.FUZZY_CARD, MEGABlocks.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add((ItemLike)AEItems.FUZZY_CARD, MEGAItems.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.WIRELESS_TERMINAL, (int)2, (String)wirelessTerminalGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.WIRELESS_CRAFTING_TERMINAL, (int)2, (String)wirelessTerminalGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.COLOR_APPLICATOR, (int)2);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.MATTER_CANNON, (int)2);
            Upgrades.add(MEGAItems.COMPRESSION_CARD, MEGAItems.BULK_ITEM_CELL, (int)1);
            for (ItemDefinition portableCell : List.of(AEItems.PORTABLE_ITEM_CELL1K, AEItems.PORTABLE_ITEM_CELL4K, AEItems.PORTABLE_ITEM_CELL16K, AEItems.PORTABLE_ITEM_CELL64K, AEItems.PORTABLE_ITEM_CELL256K, AEItems.PORTABLE_FLUID_CELL1K, AEItems.PORTABLE_FLUID_CELL4K, AEItems.PORTABLE_FLUID_CELL16K, AEItems.PORTABLE_FLUID_CELL64K, AEItems.PORTABLE_FLUID_CELL256K)) {
                Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)portableCell, (int)2, (String)portableCellGroup);
            }
            for (Addons addon : Addons.values()) {
                if (!addon.isLoaded()) continue;
                addon.getHelper().initUpgrades();
            }
        });
    }

    private static void initStorageCells(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            StorageCells.addCellHandler((ICellHandler)BulkCellItem.HANDLER);
            for (MEGAItems.CellDefinition cell : MEGAItems.getTieredCells()) {
                Item patt0$temp = cell.item().asItem();
                if (!(patt0$temp instanceof AbstractPortableCell)) continue;
                AbstractPortableCell portable = (AbstractPortableCell)patt0$temp;
                HotkeyActions.register((ItemLike)portable, (arg_0, arg_1) -> ((AbstractPortableCell)portable).openFromInventory(arg_0, arg_1), (String)(cell.keyType().equals("item") ? "portable_item_cell" : "portable_fluid_cell"));
            }
            if (Addons.APPMEK.isLoaded()) {
                StorageCells.addCellHandler((ICellHandler)RadioactiveCellItem.HANDLER);
            }
        });
    }

    private static void initVillagerTrades(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            MEGACells.addVillagerTrade(MEGAItems.SKY_STEEL_INGOT, 8, 3, 20);
            MEGACells.addVillagerTrade(MEGAItems.ACCUMULATION_PROCESSOR_PRESS, 40, 1, 50);
        });
    }

    private static void addVillagerTrade(ItemLike item, int cost, int quantity, int xp) {
        Int2ObjectMap offers = VillagerTrades.TRADES.computeIfAbsent(InitVillager.PROFESSION, k -> new Int2ObjectOpenHashMap());
        Object[] masterEntries = (VillagerTrades.ItemListing[])offers.computeIfAbsent(5, k -> new VillagerTrades.ItemListing[0]);
        masterEntries = (VillagerTrades.ItemListing[])ArrayUtils.add((Object[])masterEntries, (i, j) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, cost), new ItemStack(item, quantity), 12, xp, 0.05f));
        offers.put(5, (Object)masterEntries);
    }

    private static void initCapabilities(RegisterCapabilitiesEvent event) {
        for (DeferredHolder type : MEGABlockEntities.DR.getEntries()) {
            event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, (BlockEntityType)type.get(), (be, context) -> (IInWorldGridNodeHost)be);
        }
        event.registerBlockEntity(AECapabilities.GENERIC_INTERNAL_INV, MEGABlockEntities.MEGA_INTERFACE.get(), (be, context) -> be.getInterfaceLogic().getStorage());
        event.registerBlockEntity(AECapabilities.ME_STORAGE, MEGABlockEntities.MEGA_INTERFACE.get(), (be, context) -> be.getInterfaceLogic().getInventory());
        event.registerBlockEntity(AECapabilities.GENERIC_INTERNAL_INV, MEGABlockEntities.MEGA_PATTERN_PROVIDER.get(), (be, context) -> be.getLogic().getReturnInv());
        for (MEGAItems.CellDefinition cell : MEGAItems.getTieredCells()) {
            if (!cell.portable()) continue;
            MEGACells.registerPoweredItemCapability(event, cell.item().asItem());
        }
    }

    private static <T extends Item> void registerPoweredItemCapability(RegisterCapabilitiesEvent event, T item) {
        if (item instanceof IAEItemPowerStorage) {
            IAEItemPowerStorage powered = (IAEItemPowerStorage)item;
            event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> new PoweredItemCapabilities(stack, powered), new ItemLike[]{item});
        }
    }
}

