/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.definition;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.core.definitions.BlockDefinition;
import gripe._90.arseng.block.entity.MESourceJarBlockEntity;
import gripe._90.arseng.block.entity.SourceConverterBlockEntity;
import gripe._90.arseng.definition.ArsEngBlocks;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ArsEngBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> DR = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"arseng");
    public static final Supplier<BlockEntityType<MESourceJarBlockEntity>> ME_SOURCE_JAR = ArsEngBlockEntities.create("me_source_jar", MESourceJarBlockEntity.class, MESourceJarBlockEntity::new, ArsEngBlocks.ME_SOURCE_JAR);
    public static final Supplier<BlockEntityType<SourceConverterBlockEntity>> SOURCE_CONVERTER = ArsEngBlockEntities.create("source_converter", SourceConverterBlockEntity.class, SourceConverterBlockEntity::new, ArsEngBlocks.SOURCE_CONVERTER);

    private static <T extends AEBaseBlockEntity> Supplier<BlockEntityType<T>> create(String id, Class<T> entityClass, BlockEntityType.BlockEntitySupplier<T> supplier, BlockDefinition<? extends AEBaseEntityBlock<T>> block) {
        return DR.register(id, () -> {
            BlockEntityType type = BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{block.block()}).build(null);
            BlockEntityTicker clientTicker = null;
            BlockEntityTicker serverTicker = null;
            if (ClientTickingBlockEntity.class.isAssignableFrom(entityClass)) {
                clientTicker = (level, pos, state, entity) -> ((ClientTickingBlockEntity)entity).clientTick();
            }
            if (ServerTickingBlockEntity.class.isAssignableFrom(entityClass)) {
                serverTicker = (level, pos, state, entity) -> ((ServerTickingBlockEntity)entity).serverTick();
            }
            ((AEBaseEntityBlock)block.block()).setBlockEntity(entityClass, type, clientTicker, serverTicker);
            AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)type, (Item)block.asItem());
            return type;
        });
    }
}

