/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.block;

import com.google.common.collect.ImmutableMap;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.Config;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.core.SymbolOrientation;
import io.github.mortuusars.chalk.data.ChalkColors;
import io.github.mortuusars.chalk.utils.ParticleUtils;
import io.github.mortuusars.chalk.utils.PositionUtils;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class ChalkMarkBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final EnumProperty<MarkSymbol> SYMBOL = EnumProperty.create((String)"symbol", MarkSymbol.class);
    public static final EnumProperty<SymbolOrientation> ORIENTATION = EnumProperty.create((String)"orientation", SymbolOrientation.class);
    public static final BooleanProperty GLOWING = BooleanProperty.create((String)"glowing");
    private final DyeColor color;
    private static final VoxelShape DOWN_AABB = Block.box((double)1.5, (double)15.5, (double)1.5, (double)14.5, (double)16.0, (double)14.5);
    private static final VoxelShape UP_AABB = Block.box((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)0.5, (double)14.5);
    private static final VoxelShape SOUTH_AABB = Block.box((double)1.5, (double)1.5, (double)0.0, (double)14.5, (double)14.5, (double)0.5);
    private static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)1.5, (double)1.5, (double)0.5, (double)14.5, (double)14.5);
    private static final VoxelShape WEST_AABB = Block.box((double)15.5, (double)1.5, (double)1.5, (double)16.0, (double)14.5, (double)14.5);
    private static final VoxelShape NORTH_AABB = Block.box((double)1.5, (double)1.5, (double)15.5, (double)14.5, (double)14.5, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public ChalkMarkBlock(DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SYMBOL, (Comparable)((Object)MarkSymbol.CENTER))).setValue(ORIENTATION, (Comparable)((Object)SymbolOrientation.NORTH))).setValue((Property)GLOWING, (Comparable)Boolean.valueOf(false)));
        this.color = dyeColor;
        this.shapesCache = ImmutableMap.copyOf(this.getStateDefinition().getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), ChalkMarkBlock::calculateShapes)));
    }

    private static VoxelShape calculateShapes(BlockState blockState) {
        return switch ((Direction)blockState.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN_AABB;
            case Direction.UP -> UP_AABB;
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
        };
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.shapesCache.get(blockState);
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)Chalk.Items.getChalk(this.color));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (player.isCreative()) {
            return new ItemStack((ItemLike)Chalk.Items.getChalk(this.color));
        }
        ItemStack item = this.getMatchingItemStack(player, Chalk.Items.getChalk(this.color));
        return item == ItemStack.EMPTY ? new ItemStack((ItemLike)Chalk.Items.getChalk(this.color)) : item;
    }

    private ItemStack getMatchingItemStack(Player player, Item item) {
        return player.getInventory().items.stream().filter(invItem -> invItem.getItem().builtInRegistryHolder().key().location() == item.builtInRegistryHolder().key().location()).findFirst().orElse(ItemStack.EMPTY);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{ORIENTATION}).add(new Property[]{GLOWING}).add(new Property[]{SYMBOL});
    }

    public DyeColor getColor() {
        return this.color;
    }

    public VoxelShape getVisualShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.UP -> UP_AABB;
            case Direction.NORTH -> NORTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            default -> DOWN_AABB;
        };
    }

    public void onPlace(BlockState blockState, Level level, BlockPos pos, BlockState state, boolean p_60570_) {
        super.onPlace(blockState, level, pos, state, p_60570_);
        if (level.isClientSide) {
            Chalk.LOGGER.info((Object)blockState);
            Chalk.LOGGER.info((Object)state);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hHitResult) {
        ItemStack usedStack = player.getItemInHand(hand);
        if (!((Boolean)state.getValue((Property)GLOWING)).booleanValue() && usedStack.is(Chalk.Tags.Items.GLOWINGS)) {
            if (level.setBlock(pos, (BlockState)state.setValue((Property)GLOWING, (Comparable)Boolean.valueOf(true)), 11)) {
                if (!player.isCreative()) {
                    usedStack.shrink(1);
                }
                level.playSound(null, pos, (SoundEvent)Chalk.SoundEvents.GLOW_APPLIED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.playSound(null, pos, (SoundEvent)Chalk.SoundEvents.GLOWING.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                ParticleUtils.spawnParticle(level, (ParticleOptions)ParticleTypes.END_ROD, PositionUtils.blockCenterOffsetToFace(pos, (Direction)state.getValue((Property)FACING), 0.3f), new Vector3f(0.0f, 0.03f, 0.0f), 2);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return this.removeMarkWithEffects(level, pos);
    }

    private boolean removeMarkWithEffects(Level level, BlockPos pos) {
        Direction facing = (Direction)level.getBlockState(pos).getValue((Property)FACING);
        if (level.removeBlock(pos, false)) {
            level.playSound(null, pos, (SoundEvent)Chalk.SoundEvents.MARK_REMOVED.get(), SoundSource.BLOCKS, 0.5f, new Random().nextFloat() * 0.2f + 0.8f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int colorValue = ChalkColors.fromDyeColor(this.color);
                float R = (colorValue & 0xFF0000) >> 16;
                float G = (colorValue & 0xFF00) >> 8;
                float B = colorValue & 0xFF;
                Vector3f centerOffset = PositionUtils.blockCenterOffsetToFace(pos, facing, 0.25f);
                serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(R / 255.0f, G / 255.0f, B / 255.0f), 2.0f), (double)centerOffset.x(), (double)centerOffset.y(), (double)centerOffset.z(), 1, 0.1, 0.1, 0.1, 0.02);
            } else {
                ParticleUtils.spawnColorDustParticles(this.color, level, pos, facing);
            }
            return true;
        }
        return false;
    }

    public boolean propagatesSkylightDown(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)GLOWING)).booleanValue() && randomSource.nextInt(90) == 0) {
            ParticleUtils.spawnParticle(level, (ParticleOptions)ParticleTypes.END_ROD, PositionUtils.blockCenterOffsetToFace(blockPos, (Direction)blockState.getValue((Property)FACING), 0.33f), new Vector3f(0.0f, 0.015f, 0.0f), 1);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)GLOWING) != false ? (Integer)Config.Common.GLOWING_MARK_LIGHT_LEVEL.get() : 0;
    }

    public void attack(BlockState blockState, Level level, BlockPos pos, Player player) {
        this.removeMarkWithEffects(level, pos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            this.removeMarkWithEffects(level, pos);
            return;
        }
        BlockPos surfacePos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
        if (surfacePos.equals((Object)fromPos) && level.getBlockState(surfacePos).getBlock() instanceof GrassBlock) {
            level.removeBlock(pos, false);
            level.playSound(null, pos, (SoundEvent)Chalk.SoundEvents.MARK_REMOVED.get(), SoundSource.BLOCKS, 0.5f, new Random().nextFloat() * 0.2f + 0.8f);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos surfacePos = pos.relative(facing.getOpposite());
        BlockState surfaceBlockState = level.getBlockState(surfacePos);
        return surfaceBlockState.isFaceSturdy((BlockGetter)level, surfacePos, facing);
    }

    public boolean canBeReplaced(BlockState blockState, BlockPlaceContext blockItemUseContext) {
        return true;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState rotated = (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate(facing));
        boolean yAxis = facing.getAxis() == Direction.Axis.Y;
        boolean canRotateSymbol = ((MarkSymbol)((Object)state.getValue(SYMBOL))).getOrientationBehavior() != MarkSymbol.OrientationBehavior.FIXED;
        return yAxis && canRotateSymbol ? (BlockState)rotated.setValue(ORIENTATION, (Comparable)((Object)((SymbolOrientation)((Object)state.getValue(ORIENTATION))).rotate(rotation))) : rotated;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

