/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ItemCollection {
    private final List<ItemStack> items = new ArrayList<ItemStack>();

    public void add(ItemStack is) {
        if (!is.isEmpty()) {
            this.items.add(is.copy());
        }
    }

    public void drop(Level world, BlockPos pos) {
        if (this.items.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (!stack.isStackable()) {
                stacks.add(stack);
                continue;
            }
            int sizeInventory = stacks.size();
            for (int i = 0; i < sizeInventory && !(stack = this.insert(stacks, stack, i)).isEmpty(); ++i) {
            }
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
        for (ItemStack stack : stacks) {
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
        }
    }

    private ItemStack insert(List<ItemStack> stacks, ItemStack stack, int slot) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = stacks.get(slot);
        if (existing.isEmpty()) {
            stacks.set(slot, stack.copy());
            return ItemStack.EMPTY;
        }
        if (!stack.isStackable() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
            return stack;
        }
        int available = stack.getMaxStackSize() - existing.getCount();
        int toAdd = Math.min(available, stack.getCount());
        existing.grow(toAdd);
        return toAdd == stack.getCount() ? ItemStack.EMPTY : stack.copyWithCount(stack.getCount() - toAdd);
    }
}

