/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbultimine.CooldownTracker;
import dev.ftb.mods.ftbultimine.FTBUltimineCommands;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.ItemCollection;
import dev.ftb.mods.ftbultimine.RightClickHandlers;
import dev.ftb.mods.ftbultimine.client.FTBUltimineClient;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.integration.FTBRanksIntegration;
import dev.ftb.mods.ftbultimine.integration.FTBUltiminePlugins;
import dev.ftb.mods.ftbultimine.net.FTBUltimineNet;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.net.SyncConfigFromServerPacket;
import dev.ftb.mods.ftbultimine.net.SyncUltimineTimePacket;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.EscapeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.LargeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.MiningTunnelShape;
import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import dev.ftb.mods.ftbultimine.shape.ShapelessShape;
import dev.ftb.mods.ftbultimine.shape.SmallSquareShape;
import dev.ftb.mods.ftbultimine.shape.SmallTunnelShape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FTBUltimine {
    public static FTBUltimine instance;
    public static final String MOD_ID = "ftbultimine";
    public static final Logger LOGGER;
    public final FTBUltimineCommon proxy;
    public static boolean ranksMod;
    private Map<UUID, FTBUltiminePlayerData> cachedDataMap;
    private boolean isBreakingBlock;
    private int tempBlockDroppedXp;
    private ItemCollection tempBlockDropsList;
    public static final TagKey<Item> DENY_TAG;
    public static final TagKey<Item> STRICT_DENY_TAG;
    public static final TagKey<Item> ALLOW_TAG;
    public static final TagKey<Block> EXCLUDED_BLOCKS;
    public static final TagKey<Block> BLOCK_WHITELIST;
    public static final TagKey<Block> TILLABLE_TAG;
    public static final TagKey<Block> FLATTENABLE_TAG;
    private static Predicate<Player> permissionOverride;

    public static void setPermissionOverride(Predicate<Player> p) {
        permissionOverride = p;
    }

    public FTBUltimine() {
        instance = this;
        FTBUltimineNet.init();
        if (Platform.isModLoaded((String)"ftbranks")) {
            ranksMod = true;
            FTBRanksIntegration.init();
        }
        this.proxy = (FTBUltimineCommon)EnvExecutor.getEnvSpecific(() -> FTBUltimineClient::new, () -> FTBUltimineCommon::new);
        FTBUltiminePlugins.init();
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new DataReloadListener());
        ShapeRegistry.register(new ShapelessShape(), true);
        ShapeRegistry.register(new SmallTunnelShape());
        ShapeRegistry.register(new SmallSquareShape());
        ShapeRegistry.register(new LargeTunnelShape());
        ShapeRegistry.register(new MiningTunnelShape());
        ShapeRegistry.register(new EscapeTunnelShape());
        PlayerEvent.PLAYER_JOIN.register(this::playerJoined);
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverStarting);
        BlockEvent.BREAK.register(this::blockBroken);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        TickEvent.PLAYER_PRE.register(this::playerTick);
        EntityEvent.ADD.register(this::entityJoinedWorld);
        CommandRegistrationEvent.EVENT.register(FTBUltimineCommands::registerCommands);
    }

    @NotNull
    public FTBUltiminePlayerData getOrCreatePlayerData(Player player) {
        return this.cachedDataMap.computeIfAbsent(player.getUUID(), FTBUltiminePlayerData::new);
    }

    private void playerJoined(ServerPlayer serverPlayer) {
        SNBTCompoundTag config = new SNBTCompoundTag();
        FTBUltimineServerConfig.CONFIG.write(config);
        NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncConfigFromServerPacket(config));
        NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncUltimineTimePacket(FTBUltimineServerConfig.getUltimineCooldown(serverPlayer), SyncUltimineTimePacket.TimeType.COOLDOWN));
    }

    private void serverStarting(MinecraftServer server) {
        ShapeRegistry.freeze();
        this.cachedDataMap = new HashMap<UUID, FTBUltiminePlayerData>();
        FTBUltimineServerConfig.load(server);
    }

    public void setKeyPressed(ServerPlayer player, boolean pressed) {
        FTBUltiminePlayerData data = this.getOrCreatePlayerData((Player)player);
        data.setPressed(pressed);
        data.clearCache();
        if (!data.isPressed()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SendShapePacket.adjustShapeOnly(data.getCurrentShapeIndex()));
        }
    }

    public void modeChanged(ServerPlayer player, boolean next) {
        FTBUltiminePlayerData data = this.getOrCreatePlayerData((Player)player);
        data.cycleShape(next);
        data.clearCache();
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SendShapePacket.adjustShapeOnly(data.getCurrentShapeIndex()));
    }

    public static boolean isValidTool(ItemStack mainHand, ItemStack offHand) {
        if (mainHand.is(STRICT_DENY_TAG) || offHand.is(STRICT_DENY_TAG) || mainHand.is(DENY_TAG)) {
            return false;
        }
        if (((Boolean)FTBUltimineServerConfig.REQUIRE_TOOL.get()).booleanValue()) {
            if (mainHand.isEmpty()) {
                return false;
            }
            return mainHand.getItem() instanceof TieredItem || mainHand.getMaxDamage() > 0 || mainHand.is(ALLOW_TAG);
        }
        return true;
    }

    public boolean canUltimine(Player player) {
        ItemStack offHand;
        if (PlayerHooks.isFake((Player)player) || player.getUUID() == null || CooldownTracker.isOnCooldown(player)) {
            return false;
        }
        if (player.getFoodData().getFoodLevel() <= 0 && !player.isCreative()) {
            return false;
        }
        if (!permissionOverride.test(player)) {
            return false;
        }
        ItemStack mainHand = player.getMainHandItem();
        return FTBUltimine.isValidTool(mainHand, offHand = player.getOffhandItem()) && FTBUltiminePlugins.canUltimine(player);
    }

    public EventResult blockBroken(Level world, BlockPos pos, BlockState state, ServerPlayer player, @Nullable IntValue xp) {
        if (this.isBreakingBlock || !this.canUltimine((Player)player)) {
            return EventResult.pass();
        }
        FTBUltiminePlayerData data = this.getOrCreatePlayerData((Player)player);
        if (!data.isPressed()) {
            return EventResult.pass();
        }
        HitResult result = FTBUltiminePlayerData.rayTrace(player);
        if (!(result instanceof BlockHitResult) || result.getType() != HitResult.Type.BLOCK) {
            return EventResult.pass();
        }
        data.clearCache();
        data.updateBlocks(player, pos, ((BlockHitResult)result).getDirection(), false, FTBUltimineServerConfig.getMaxBlocks(player));
        if (!data.hasCachedPositions()) {
            return EventResult.pass();
        }
        if ((double)player.totalExperience < (double)data.cachedPositions().size() * FTBUltimineServerConfig.getExperiencePerBlock(player)) {
            return EventResult.pass();
        }
        this.isBreakingBlock = true;
        this.tempBlockDropsList = new ItemCollection();
        this.tempBlockDroppedXp = 0;
        boolean hadItem = !player.getMainHandItem().isEmpty();
        float baseSpeed = state.getDestroySpeed((BlockGetter)world, pos);
        int blocksMined = 0;
        for (BlockPos p : data.cachedPositions()) {
            BlockState state1 = world.getBlockState(p);
            float destroySpeed = state1.getDestroySpeed((BlockGetter)world, p);
            if (!player.isCreative() && (destroySpeed < 0.0f || destroySpeed > baseSpeed || !player.hasCorrectToolForDrops(state1))) continue;
            if (!player.gameMode.destroyBlock(p) && ((Boolean)FTBUltimineServerConfig.CANCEL_ON_BLOCK_BREAK_FAIL.get()).booleanValue()) break;
            if (!player.isCreative()) {
                player.causeFoodExhaustion((float)(FTBUltimineServerConfig.getExhaustionPerBlock(player) * 0.005));
                if (FTBUltimine.isTooExhausted(player)) break;
            }
            ItemStack stack = player.getMainHandItem();
            if (hadItem && stack.isEmpty() || hadItem && (Integer)FTBUltimineServerConfig.PREVENT_TOOL_BREAK.get() > 0 && stack.isDamageableItem() && stack.getDamageValue() >= stack.getMaxDamage() - (Integer)FTBUltimineServerConfig.PREVENT_TOOL_BREAK.get()) break;
            ++blocksMined;
        }
        if (!player.isCreative()) {
            CooldownTracker.setLastUltimineTime((Player)player, System.currentTimeMillis());
            data.addPendingXPCost(player, Math.max(0, blocksMined - 1));
        }
        this.isBreakingBlock = false;
        this.tempBlockDropsList.drop(player.level(), pos);
        if (this.tempBlockDroppedXp > 0) {
            player.level().addFreshEntity((Entity)new ExperienceOrb(player.level(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, this.tempBlockDroppedXp));
        }
        data.clearCache();
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SendShapePacket.adjustShapeAndBlockPos(data.getCurrentShapeIndex(), List.of()));
        return EventResult.interruptFalse();
    }

    public EventResult blockRightClick(Player player, InteractionHand hand, BlockPos clickPos, Direction face) {
        BlockHitResult blockHitResult;
        FTBUltiminePlayerData data;
        ServerPlayer serverPlayer;
        block21: {
            block20: {
                block19: {
                    block18: {
                        if (!(player instanceof ServerPlayer)) break block18;
                        serverPlayer = (ServerPlayer)player;
                        if (!PlayerHooks.isFake((Player)player) && player.getUUID() != null) break block19;
                    }
                    return EventResult.pass();
                }
                data = this.getOrCreatePlayerData(player);
                if (!data.isPressed()) {
                    return EventResult.pass();
                }
                if (player.getFoodData().getFoodLevel() <= 0 && !player.isCreative()) {
                    return EventResult.pass();
                }
                HitResult result = FTBUltiminePlayerData.rayTrace(serverPlayer);
                if (!(result instanceof BlockHitResult)) break block20;
                blockHitResult = (BlockHitResult)result;
                if (result.getType() == HitResult.Type.BLOCK) break block21;
            }
            return EventResult.pass();
        }
        data.clearCache();
        ShapeContext shapeContext = data.updateBlocks(serverPlayer, clickPos, blockHitResult.getDirection(), false, FTBUltimineServerConfig.getMaxBlocks(serverPlayer));
        if (shapeContext == null || !data.isPressed() || !data.hasCachedPositions()) {
            return EventResult.pass();
        }
        int didWork = 0;
        if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_HARVESTING.get()).booleanValue() && shapeContext.matcher() == BlockMatcher.CROP_LIKE) {
            didWork = RightClickHandlers.cropHarvesting(serverPlayer, hand, clickPos, face, data);
        } else if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_HOE.get()).booleanValue() && serverPlayer.getItemInHand(hand).getItem() instanceof HoeItem) {
            didWork = RightClickHandlers.farmlandConversion(serverPlayer, hand, clickPos, data);
        } else if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_AXE.get()).booleanValue() && serverPlayer.getItemInHand(hand).getItem() instanceof AxeItem) {
            didWork = RightClickHandlers.axeStripping(serverPlayer, hand, clickPos, data);
        } else if (((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_SHOVEL.get()).booleanValue() && serverPlayer.getItemInHand(hand).getItem() instanceof ShovelItem) {
            didWork = RightClickHandlers.shovelFlattening(serverPlayer, hand, clickPos, data);
        }
        if (didWork > 0) {
            player.swing(hand);
            if (!player.isCreative()) {
                CooldownTracker.setLastUltimineTime(player, System.currentTimeMillis());
                data.addPendingXPCost(serverPlayer, Math.max(0, didWork - 1));
            }
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public void playerTick(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FTBUltiminePlayerData data = this.getOrCreatePlayerData(player);
            data.checkBlocks(serverPlayer, true, FTBUltimineServerConfig.getMaxBlocks(serverPlayer));
            data.takePendingXP(serverPlayer);
        }
    }

    public EventResult entityJoinedWorld(Entity entity, Level level) {
        if (entity.isAlive()) {
            if (this.isBreakingBlock && entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                if (!item.getItem().isEmpty()) {
                    this.tempBlockDropsList.add(item.getItem());
                    item.setItem(ItemStack.EMPTY);
                }
                return EventResult.interruptFalse();
            }
            if (this.isBreakingBlock && entity instanceof ExperienceOrb) {
                ExperienceOrb orb = (ExperienceOrb)entity;
                this.tempBlockDroppedXp += orb.getValue();
                entity.kill();
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static boolean isTooExhausted(ServerPlayer player) {
        FoodData data = player.getFoodData();
        return data.getExhaustionLevel() / 4.0f > data.getSaturationLevel() + (float)data.getFoodLevel();
    }

    static {
        LOGGER = LogManager.getLogger();
        ranksMod = false;
        DENY_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FTBUltimine.rl("excluded_tools"));
        STRICT_DENY_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FTBUltimine.rl("excluded_tools/strict"));
        ALLOW_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FTBUltimine.rl("included_tools"));
        EXCLUDED_BLOCKS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FTBUltimine.rl("excluded_blocks"));
        BLOCK_WHITELIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FTBUltimine.rl("block_whitelist"));
        TILLABLE_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FTBUltimine.rl("farmland_tillable"));
        FLATTENABLE_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FTBUltimine.rl("shovel_flattenable"));
        permissionOverride = player -> true;
    }

    private static class DataReloadListener
    implements ResourceManagerReloadListener {
        private DataReloadListener() {
        }

        public void onResourceManagerReload(ResourceManager resourceManager) {
            BlockMatcher.TagCache.onReload();
        }
    }
}

