/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema;

import com.mojang.brigadier.StringReader;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaStorage;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface RecipeComponentFactory {
    public RecipeComponent<?> readComponent(RegistryAccessContainer var1, RecipeSchemaStorage var2, StringReader var3) throws Exception;

    public static RecipeComponentFactory readOneComponent(Function<RecipeComponent<?>, RecipeComponent<?>> factory) {
        return (registries, storage, reader) -> {
            reader.skipWhitespace();
            reader.expect('<');
            reader.skipWhitespace();
            RecipeComponent<?> component = storage.readComponent(registries, reader);
            reader.skipWhitespace();
            reader.expect('>');
            return (RecipeComponent)factory.apply(component);
        };
    }

    public static RecipeComponentFactory readTwoComponents(BiFunction<RecipeComponent<?>, RecipeComponent<?>, RecipeComponent<?>> factory) {
        return (registries, storage, reader) -> {
            reader.skipWhitespace();
            reader.expect('<');
            reader.skipWhitespace();
            RecipeComponent<?> key = storage.readComponent(registries, reader);
            reader.skipWhitespace();
            reader.expect(',');
            reader.skipWhitespace();
            RecipeComponent<?> component = storage.readComponent(registries, reader);
            reader.skipWhitespace();
            reader.expect('>');
            return (RecipeComponent)factory.apply(key, component);
        };
    }
}

