/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.quarry;

import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.EnchantmentCache;
import com.yogpc.qp.machine.ItemConverter;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.PickIterator;
import com.yogpc.qp.machine.PowerEntity;
import com.yogpc.qp.machine.PowerMap;
import com.yogpc.qp.machine.QpBlockProperty;
import com.yogpc.qp.machine.WorkResult;
import com.yogpc.qp.machine.exp.ExpModule;
import com.yogpc.qp.machine.misc.BlockBreakEventResult;
import com.yogpc.qp.machine.misc.DigMinY;
import com.yogpc.qp.machine.misc.QuarryChunkLoader;
import com.yogpc.qp.machine.module.ConverterModule;
import com.yogpc.qp.machine.module.ModuleInventory;
import com.yogpc.qp.machine.module.QuarryModule;
import com.yogpc.qp.machine.module.QuarryModuleProvider;
import com.yogpc.qp.machine.module.RepeatTickModuleItem;
import com.yogpc.qp.machine.quarry.QuarryState;
import com.yogpc.qp.packet.ClientSync;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class QuarryEntity
extends PowerEntity
implements ClientSync {
    public static final Marker MARKER = MarkerFactory.getMarker((String)"quarry");
    @NotNull
    public Vec3 head;
    @NotNull
    public Vec3 targetHead;
    @NotNull
    QuarryState currentState;
    @Nullable
    private Area area;
    @Nullable
    private PickIterator<BlockPos> targetIterator;
    @NotNull
    private Set<BlockPos> skipped = new HashSet<BlockPos>();
    @Nullable
    BlockPos targetPos;
    @NotNull
    MachineStorage storage;
    @NotNull
    public DigMinY digMinY = new DigMinY();
    @NotNull
    final EnchantmentCache enchantmentCache = new EnchantmentCache();
    @NotNull
    Set<QuarryModule> modules = Collections.emptySet();
    @NotNull
    final ModuleInventory moduleInventory = new ModuleInventory(5, q -> true, m -> this.modules, this::setChanged);
    @NotNull
    QuarryChunkLoader chunkLoader = QuarryChunkLoader.None.INSTANCE;
    @NotNull
    ItemConverter itemConverter = QuarryEntity.defaultItemConverter();

    protected QuarryEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.setMaxEnergy((long)(QuarryEntity.powerMap().maxEnergy() * 1.0E9));
        this.targetHead = this.head = Vec3.atBottomCenterOf((Vec3i)pos);
        this.currentState = QuarryState.FINISHED;
        this.storage = MachineStorage.of();
        this.moduleInventory.addListener(container -> this.setChanged());
    }

    static PowerMap.Quarry powerMap() {
        return PlatformAccess.config().powerMap().quarry();
    }

    @Override
    public Stream<MutableComponent> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(QuarryEntity.detail(ChatFormatting.GREEN, "State", this.currentState.name()), QuarryEntity.detail(ChatFormatting.GREEN, "Area", String.valueOf(this.area)), QuarryEntity.detail(ChatFormatting.GREEN, "Head", String.valueOf(this.head)), QuarryEntity.detail(ChatFormatting.GREEN, "Storage", String.valueOf(this.storage)), QuarryEntity.detail(ChatFormatting.GREEN, "DigMinY", String.valueOf(this.digMinY.getMinY((LevelReader)this.level))), QuarryEntity.detail(ChatFormatting.GREEN, "Modules", String.valueOf(this.modules))));
    }

    static void serverTick(Level level, BlockPos pos, BlockState state, QuarryEntity quarryEntity) {
        block10: for (int i = 0; i < quarryEntity.repeatCount(); ++i) {
            if (!quarryEntity.hasEnoughEnergy()) {
                return;
            }
            switch (quarryEntity.currentState) {
                case FINISHED: {
                    return;
                }
                case WAITING: {
                    quarryEntity.waiting();
                    return;
                }
                case BREAK_INSIDE_FRAME: {
                    quarryEntity.breakInsideFrame();
                    continue block10;
                }
                case MAKE_FRAME: {
                    quarryEntity.makeFrame();
                    continue block10;
                }
                case MOVE_HEAD: {
                    quarryEntity.moveHead();
                    continue block10;
                }
                case BREAK_BLOCK: {
                    quarryEntity.breakBlock();
                    continue block10;
                }
                case REMOVE_FLUID: {
                    quarryEntity.removeFluid();
                    continue block10;
                }
                case FILLER: {
                    quarryEntity.filler();
                }
            }
        }
    }

    static void clientTick(Level level, BlockPos pos, BlockState state, QuarryEntity quarryEntity) {
        quarryEntity.head = quarryEntity.targetHead;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.toClientTag(tag, registries);
        if (this.targetIterator != null) {
            tag.put("targetPos", (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.targetIterator.getLastReturned()).getOrThrow());
        }
        tag.put("storage", (Tag)MachineStorage.CODEC.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.storage).getOrThrow());
        tag.putLongArray("skipped", this.skipped.stream().mapToLong(BlockPos::asLong).toArray());
        tag.put("moduleInventory", (Tag)this.moduleInventory.createTag(registries));
        tag.put("chunkLoader", (Tag)QuarryChunkLoader.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.chunkLoader).getOrThrow());
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fromClientTag(tag, registries);
        Vec3.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("head")).ifSuccess(v -> {
            this.head = v;
        });
        BlockPos current = BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("targetPos")).result().orElse(null);
        this.targetIterator = QuarryEntity.createTargetIterator(this.currentState, this.area, current);
        this.targetPos = current;
        this.storage = MachineStorage.CODEC.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("storage")).result().orElseGet(MachineStorage::of);
        this.skipped = LongStream.of(tag.getLongArray("skipped")).mapToObj(BlockPos::of).collect(Collectors.toCollection(HashSet::new));
        this.moduleInventory.fromTag(tag.getList("moduleInventory", 10), registries);
        this.chunkLoader = QuarryChunkLoader.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("chunkLoader")).result().orElse(QuarryChunkLoader.None.INSTANCE);
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("head", (Tag)Vec3.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.head).getOrThrow());
        tag.putString("state", this.currentState.name());
        if (this.area != null) {
            tag.put("area", (Tag)Area.CODEC.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.area).getOrThrow());
        }
        tag.put("digMinY", (Tag)DigMinY.CODEC.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.digMinY).getOrThrow());
        return tag;
    }

    @Override
    public void fromClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        Vec3.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("head")).ifSuccess(v -> {
            this.targetHead = v;
        });
        this.currentState = QuarryState.valueOf(tag.getString("state"));
        this.area = Area.CODEC.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("area")).result().orElse(null);
        this.digMinY = DigMinY.CODEC.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("digMinY")).result().orElseGet(DigMinY::new);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
    }

    public void saveToItem(ItemStack stack, HolderLookup.Provider registries) {
        stack.applyComponents(this.collectComponents());
    }

    public void setChanged() {
        super.setChanged();
        this.updateModules();
    }

    public void setRemoved() {
        super.setRemoved();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            this.chunkLoader.makeChunkUnLoaded(s);
        }
    }

    @Override
    public final void updateMaxEnergyWithEnchantment(Level level) {
        int efficiency = this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, level.registryAccess().asGetterLookup());
        this.setMaxEnergy((long)(QuarryEntity.powerMap().maxEnergy() * 1.0E9 * (double)(1 + efficiency)));
    }

    public void setArea(@Nullable Area area) {
        this.area = area;
        if (area != null) {
            this.head = new Vec3((double)area.maxX(), (double)area.minY(), (double)area.maxZ());
        }
    }

    @Nullable
    public Area getArea() {
        return this.area;
    }

    void setState(QuarryState state, BlockState blockState) {
        if (this.level != null && this.currentState != state) {
            if (!this.level.isClientSide) {
                if (!QuarryState.isWorking(this.currentState) && QuarryState.isWorking(state)) {
                    this.chunkLoader = QuarryChunkLoader.of((ServerLevel)this.level, this.getBlockPos());
                    this.chunkLoader.makeChunkLoaded((ServerLevel)this.level);
                } else if (QuarryState.isWorking(this.currentState) && !QuarryState.isWorking(state)) {
                    this.chunkLoader.makeChunkUnLoaded((ServerLevel)this.level);
                    this.chunkLoader = QuarryChunkLoader.None.INSTANCE;
                }
            }
            this.currentState = state;
            this.syncToClient();
            this.level.setBlock(this.getBlockPos(), (BlockState)blockState.setValue((Property)QpBlockProperty.WORKING, (Comparable)Boolean.valueOf(QuarryState.isWorking(state))), 3);
            if (state == QuarryState.FINISHED) {
                this.energyCounter.logUsageMap();
            }
        }
    }

    void updateModules() {
        this.modules = this.level == null ? this.moduleInventory.getModules() : Sets.union(this.moduleInventory.getModules(), QuarryModuleProvider.Block.getModulesInWorld(this.level, this.getBlockPos()));
        this.itemConverter = QuarryEntity.defaultItemConverter().concat(ConverterModule.findConversions(this.modules));
    }

    public String renderMode() {
        return switch (this.currentState) {
            case QuarryState.WAITING, QuarryState.BREAK_INSIDE_FRAME, QuarryState.MAKE_FRAME -> "frame";
            case QuarryState.MOVE_HEAD, QuarryState.BREAK_BLOCK, QuarryState.REMOVE_FLUID -> "drill";
            default -> "none";
        };
    }

    void waiting() {
        if (this.getEnergy() > this.getMaxEnergy() / 200L && this.area != null) {
            this.setState(QuarryState.BREAK_INSIDE_FRAME, this.getBlockState());
        }
    }

    void breakInsideFrame() {
        this.setState(QuarryState.MAKE_FRAME, this.getBlockState());
    }

    void makeFrame() {
        long requiredEnergy;
        BlockState state;
        if (this.level == null || this.level.isClientSide() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = QuarryEntity.createTargetIterator(this.currentState, this.getArea(), null);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            this.targetPos = this.targetIterator.next();
        }
        if ((state = this.level.getBlockState(this.targetPos)).is((Block)PlatformAccess.getAccess().registerObjects().frameBlock().get())) {
            if (this.targetIterator.hasNext()) {
                this.targetPos = this.targetIterator.next();
                this.makeFrame();
            } else {
                this.targetIterator = null;
                this.targetPos = null;
                this.setState(QuarryState.MOVE_HEAD, this.getBlockState());
            }
            return;
        }
        if (!this.getBlockPos().equals((Object)this.targetPos) && !state.isAir()) {
            WorkResult result = this.breakBlock(this.targetPos);
            if (!result.isSuccess()) {
                return;
            }
            if (result != WorkResult.SUCCESS) {
                this.skipped.add(this.targetPos.immutable());
            }
        }
        if (this.useEnergy(requiredEnergy = (long)(1.0E9 * QuarryEntity.powerMap().makeFrame()), true, false, "makeFrame") == requiredEnergy) {
            this.useEnergy(requiredEnergy, false, false, "makeFrame");
            if (!this.targetPos.equals((Object)this.getBlockPos())) {
                this.level.setBlock(this.targetPos, PlatformAccess.getAccess().registerObjects().frameBlock().get().defaultBlockState(), 3);
            }
            if (this.targetIterator.hasNext()) {
                this.targetPos = this.targetIterator.next();
            } else {
                this.targetIterator = null;
                this.targetPos = null;
                this.setState(QuarryState.MOVE_HEAD, this.getBlockState());
            }
        }
    }

    void moveHead() {
        Vec3 diff;
        double difLength;
        if (this.level == null || this.level.isClientSide() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = QuarryEntity.createTargetIterator(this.currentState, this.getArea(), null);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            this.targetPos = this.getNextValidTarget();
            this.head = new Vec3(((double)this.area.minX() + (double)this.area.maxX()) / 2.0, (double)this.area.maxY(), ((double)this.area.minZ() + (double)this.area.maxZ()) / 2.0);
            if (this.targetPos == null) {
                return;
            }
        }
        if ((difLength = (diff = new Vec3((double)this.targetPos.getX() - this.head.x, (double)this.targetPos.getY() - this.head.y, (double)this.targetPos.getZ() - this.head.z)).length()) > 1.0E-7) {
            long defaultEnergy = (long)(1.0E9 * QuarryEntity.powerMap().moveHeadBase() * this.moveHeadFactor());
            long availableEnergy = this.useEnergy(defaultEnergy, true, false, "moveHead");
            double moveDistance = Math.min(difLength, (double)availableEnergy / 1.0E9);
            this.useEnergy((long)(moveDistance * 1.0E9), false, true, "moveHead");
            this.head = this.head.add(diff.scale(moveDistance / difLength));
            this.syncToClient();
        }
        if (this.targetPos.distToLowCornerSqr(this.head.x, this.head.y, this.head.z) <= 1.0E-7) {
            this.setState(QuarryState.BREAK_BLOCK, this.getBlockState());
            this.breakBlock();
        }
    }

    double moveHeadFactor() {
        assert (this.level != null);
        int efficiency = this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, this.level.registryAccess().asGetterLookup());
        if (efficiency >= 4) {
            return efficiency - 3;
        }
        return Math.pow(4.0, (double)efficiency / 4.0 - 1.0);
    }

    void breakBlock() {
        if (this.level == null || this.level.isClientSide() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = QuarryEntity.createTargetIterator(this.currentState, this.getArea(), null);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            throw new IllegalStateException("How to break block with targetPos is null?");
        }
        FluidState fluid = this.level.getFluidState(this.targetPos);
        if (!fluid.isEmpty()) {
            if (this.shouldRemoveFluid()) {
                this.setState(QuarryState.REMOVE_FLUID, this.getBlockState());
                this.removeFluid();
                return;
            }
            this.targetPos = this.getNextValidTarget();
            if (this.targetPos == null) {
                return;
            }
            this.setState(QuarryState.MOVE_HEAD, this.getBlockState());
            return;
        }
        WorkResult result = this.breakBlock(this.targetPos);
        if (result.isSuccess()) {
            if (result != WorkResult.SUCCESS) {
                this.skipped.add(this.targetPos.immutable());
            }
            this.targetPos = this.getNextValidTarget();
            if (this.targetPos == null) {
                return;
            }
            this.setState(QuarryState.MOVE_HEAD, this.getBlockState());
        }
    }

    private boolean setNextDigTargetIterator() {
        BlockPos fluidPos;
        if (this.targetPos == null) {
            throw new IllegalStateException("Target pos is null");
        }
        assert (this.area != null);
        assert (this.level != null);
        if (this.shouldRemoveFluid() && (fluidPos = (BlockPos)BlockPos.betweenClosedStream((int)(this.area.minX() + 1), (int)this.targetPos.getY(), (int)(this.area.minZ() + 1), (int)(this.area.maxX() - 1), (int)this.targetPos.getY(), (int)(this.area.maxZ() - 1)).filter(p -> !this.skipped.contains(p)).filter(p -> !this.level.getFluidState(p).isEmpty()).findAny().map(BlockPos::immutable).orElse(null)) != null) {
            this.targetIterator = new PickIterator.Single<BlockPos>(fluidPos);
            this.setState(QuarryState.REMOVE_FLUID, this.getBlockState());
            return false;
        }
        BlockPos blockPos = BlockPos.betweenClosedStream((int)(this.area.minX() + 1), (int)this.targetPos.getY(), (int)(this.area.minZ() + 1), (int)(this.area.maxX() - 1), (int)this.targetPos.getY(), (int)(this.area.maxZ() - 1)).filter(p -> !this.skipped.contains(p)).filter(p -> this.canBreak(this.level, (BlockPos)p, this.level.getBlockState(p))).findAny().map(BlockPos::immutable).orElse(null);
        if (blockPos != null) {
            this.targetIterator = new PickIterator.Single<BlockPos>(blockPos);
            this.setState(QuarryState.MOVE_HEAD, this.getBlockState());
            return false;
        }
        int minY = this.digMinY.getMinY((LevelReader)this.level);
        if (minY < this.targetPos.getY()) {
            this.skipped.removeIf(p -> p.getY() > this.targetPos.getY());
            this.targetIterator = this.area.quarryDigPosIterator(this.targetPos.getY() - 1);
            return false;
        }
        this.setState(QuarryState.FINISHED, this.getBlockState());
        return true;
    }

    void removeFluid() {
        if (this.level == null || this.level.isClientSide() || this.area == null) {
            return;
        }
        if (this.targetIterator == null || this.targetPos == null) {
            throw new IllegalStateException("Target is null");
        }
        FluidState fluidState = this.level.getFluidState(this.targetPos);
        if (fluidState.isEmpty()) {
            this.setState(QuarryState.BREAK_BLOCK, this.getBlockState());
            return;
        }
        Set<BlockPos> poses = this.area.getChainBlocks(this.targetPos, p -> !this.level.getFluidState(p).isEmpty(), this.level.getMaxBuildHeight());
        this.useEnergy((long)(QuarryEntity.powerMap().breakBlockFluid() * (double)poses.size() * 1.0E9), false, true, "removeFluid");
        ServerPlayer player = this.getQuarryFakePlayer((ServerLevel)this.level, this.targetPos);
        for (BlockPos fluidPos : poses) {
            this.removeFluidAt(this.level, fluidPos, player, Blocks.AIR.defaultBlockState());
            for (BlockPos edge : this.area.getEdgeForPos(fluidPos)) {
                if (this.level.getFluidState(edge).isEmpty()) continue;
                this.useEnergy((long)(QuarryEntity.powerMap().breakBlockFluid() * 1.0E9), false, true, "removeFluid");
                this.removeFluidAt(this.level, edge, player, PlatformAccess.getAccess().registerObjects().frameBlock().get().getDammingState());
            }
        }
        this.setState(QuarryState.BREAK_BLOCK, this.getBlockState());
    }

    void filler() {
        this.setState(QuarryState.FINISHED, this.getBlockState());
    }

    @Nullable
    static PickIterator<BlockPos> createTargetIterator(QuarryState state, @Nullable Area area, @Nullable BlockPos lastReturned) {
        PickIterator<BlockPos> itr;
        if (area == null) {
            return null;
        }
        switch (state) {
            case MAKE_FRAME: {
                PickIterator<BlockPos> pickIterator = area.quarryFramePosIterator();
                break;
            }
            case MOVE_HEAD: 
            case BREAK_BLOCK: {
                PickIterator<BlockPos> pickIterator = area.quarryDigPosIterator(lastReturned != null ? lastReturned.getY() : area.minY() - 1);
                break;
            }
            default: {
                PickIterator<BlockPos> pickIterator = itr = null;
            }
        }
        if (itr != null && lastReturned != null) {
            itr.setLastReturned(lastReturned);
        }
        return itr;
    }

    @NotNull
    WorkResult breakBlock(BlockPos target) {
        BlockState state;
        assert (this.level != null);
        ServerLevel serverLevel = (ServerLevel)this.level;
        if (target.getX() % 3 == 0 && target.getZ() % 3 == 0) {
            serverLevel.getEntitiesOfClass(ItemEntity.class, new AABB(target).inflate(5.0), Predicate.not(i -> i.getItem().isEmpty())).forEach(i -> {
                this.itemConverter.convert(i.getItem()).forEach(this.storage::addItem);
                i.kill();
            });
            if (this.shouldCollectExp()) {
                List orbs = serverLevel.getEntitiesOfClass(ExperienceOrb.class, new AABB(target).inflate(5.0), EntitySelector.ENTITY_STILL_ALIVE);
                int amount = orbs.stream().mapToInt(ExperienceOrb::getValue).sum();
                if (amount != 0) {
                    this.getExpModule().ifPresent(e -> e.addExp(amount));
                }
                orbs.forEach(Entity::kill);
            }
        }
        if ((state = serverLevel.getBlockState(target)).isAir() || state.equals(this.stateAfterBreak((Level)serverLevel, target, state))) {
            return WorkResult.SUCCESS;
        }
        HolderGetter.Provider lookup = serverLevel.registryAccess().asGetterLookup();
        BlockEntity blockEntity = serverLevel.getBlockEntity(target);
        ServerPlayer player = this.getQuarryFakePlayer(serverLevel, target);
        ItemStack pickaxe = Items.NETHERITE_PICKAXE.getDefaultInstance();
        EnchantmentHelper.setEnchantments((ItemStack)pickaxe, (ItemEnchantments)this.enchantmentCache.getEnchantmentsForPickaxe(this.getEnchantments(), lookup));
        player.setItemInHand(InteractionHand.MAIN_HAND, pickaxe);
        float hardness = state.getDestroySpeed((BlockGetter)serverLevel, target);
        BlockBreakEventResult eventResult = this.checkBreakEvent((Level)serverLevel, player, state, target, blockEntity);
        if (eventResult.canceled()) {
            return WorkResult.FAIL_EVENT;
        }
        WorkResult moduleResult = this.breakBlockModuleOverride(serverLevel, state, target, hardness);
        if (moduleResult != WorkResult.SKIPPED) {
            return moduleResult;
        }
        if (hardness < 0.0f) {
            return WorkResult.SKIPPED;
        }
        long requiredEnergy = QuarryEntity.powerMap().getBreakEnergy(hardness, this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING, lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.FORTUNE, lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, lookup) > 0);
        if (this.useEnergy(requiredEnergy, true, this.getMaxEnergy() < requiredEnergy, "breakBlock") == requiredEnergy) {
            this.useEnergy(requiredEnergy, false, this.getMaxEnergy() < requiredEnergy, "breakBlock");
            BlockBreakEventResult afterBreakEventResult = this.afterBreak((Level)serverLevel, player, state, target, blockEntity, Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)target, (BlockEntity)blockEntity, (Entity)player, (ItemStack)pickaxe), pickaxe, this.stateAfterBreak((Level)serverLevel, target, state));
            if (!afterBreakEventResult.canceled()) {
                afterBreakEventResult.drops().stream().flatMap(this.itemConverter::convert).forEach(this.storage::addItem);
                int amount = eventResult.exp().orElse(afterBreakEventResult.exp().orElse(0));
                if (amount != 0) {
                    this.getExpModule().ifPresent(e -> e.addExp(amount));
                }
            }
            if (this.shouldRemoveFluid()) {
                assert (this.area != null);
                for (BlockPos edge : this.area.getEdgeForPos(target)) {
                    if (this.level.getFluidState(edge).isEmpty()) continue;
                    this.useEnergy((long)(QuarryEntity.powerMap().breakBlockFluid() * 1.0E9), false, true, "removeFluid");
                    this.removeFluidAt(this.level, edge, player, PlatformAccess.getAccess().registerObjects().frameBlock().get().getDammingState());
                }
            }
            return WorkResult.SUCCESS;
        }
        return WorkResult.NOT_ENOUGH_ENERGY;
    }

    protected final BlockBreakEventResult checkBreakEvent(Level level, ServerPlayer fakePlayer, BlockState state, BlockPos target, @Nullable BlockEntity blockEntity) {
        return PlatformAccess.getAccess().mining().checkBreakEvent(this, level, fakePlayer, state, target, blockEntity);
    }

    protected final BlockBreakEventResult afterBreak(Level level, ServerPlayer fakePlayer, BlockState state, BlockPos target, @Nullable BlockEntity blockEntity, List<ItemStack> drops, ItemStack pickaxe, BlockState newState) {
        return PlatformAccess.getAccess().mining().afterBreak(this, level, fakePlayer, state, target, blockEntity, drops, pickaxe, newState);
    }

    WorkResult breakBlockModuleOverride(ServerLevel level, BlockState state, BlockPos target, float hardness) {
        if (hardness < 0.0f && state.is(Blocks.BEDROCK) && this.shouldRemoveBedrock()) {
            int worldBottom = level.getMinBuildHeight();
            int targetY = target.getY();
            if (level.dimension().equals(Level.NETHER)) {
                int top;
                int n = top = PlatformAccess.config().removeBedrockOnNetherTop() ? level.getMaxBuildHeight() + 1 : 127;
                if (!(worldBottom < targetY && targetY < worldBottom + 5 || 122 < targetY && targetY < top)) {
                    return WorkResult.SKIPPED;
                }
            } else if (worldBottom >= targetY || targetY >= worldBottom + 5) {
                return WorkResult.SKIPPED;
            }
            HolderGetter.Provider lookup = level.registryAccess().asGetterLookup();
            long requiredEnergy = QuarryEntity.powerMap().getBreakEnergy(hardness, this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, lookup), 0, 0, true);
            this.useEnergy(requiredEnergy, false, true, "breakBlock");
            level.setBlock(target, this.stateAfterBreak((Level)level, target, state), 3);
            return WorkResult.SUCCESS;
        }
        return WorkResult.SKIPPED;
    }

    protected final ServerPlayer getQuarryFakePlayer(ServerLevel level, BlockPos target) {
        return PlatformAccess.getAccess().mining().getQuarryFakePlayer(this, level, target);
    }

    protected boolean shouldRemoveFluid() {
        return this.modules.contains(QuarryModule.Constant.PUMP);
    }

    protected BlockState stateAfterBreak(Level level, BlockPos pos, BlockState before) {
        return Blocks.AIR.defaultBlockState();
    }

    protected boolean shouldRemoveBedrock() {
        return this.modules.contains(QuarryModule.Constant.BEDROCK);
    }

    protected boolean shouldCollectExp() {
        return this.modules.stream().anyMatch(ExpModule.class::isInstance);
    }

    @NotNull
    protected Optional<ExpModule> getExpModule() {
        return ExpModule.getModule(this.modules);
    }

    protected int repeatCount() {
        RepeatTickModuleItem.RepeatTickModule repeatTickModule = RepeatTickModuleItem.getModule(this.modules).orElse(RepeatTickModuleItem.ZERO);
        return repeatTickModule.stackSize() + 1;
    }

    void removeFluidAt(@NotNull Level level, BlockPos pos, ServerPlayer player, BlockState newState) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof LiquidBlock) {
            FluidState f = level.getFluidState(pos);
            if (!f.isEmpty() && f.isSource()) {
                this.storage.addFluid(f.getType(), 81000L);
            }
            level.setBlock(pos, newState, 2);
        } else {
            Block f = state.getBlock();
            if (f instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)f;
                ItemStack picked = bucketPickup.pickupBlock((Player)player, (LevelAccessor)level, pos, state);
                this.storage.addBucketFluid(picked);
            } else {
                level.setBlock(pos, newState, 2);
            }
        }
    }

    @Nullable
    BlockPos getNextValidTarget() {
        assert (this.targetIterator != null);
        assert (this.level != null);
        assert (this.area != null);
        int recursiveCount = 0;
        while (recursiveCount++ < 350) {
            while (this.targetIterator.hasNext()) {
                BlockState state;
                BlockPos pos = this.targetIterator.next();
                if (!this.canBreak(this.level, pos, state = this.level.getBlockState(pos))) continue;
                return pos;
            }
            this.targetPos = this.targetIterator.getLastReturned();
            if (!this.setNextDigTargetIterator()) continue;
            return null;
        }
        QuarryPlus.LOGGER.error("Quarry at {} can't find next target. Itr: {}, Pos: {}", new Object[]{this.getBlockPos().toShortString(), this.targetIterator, this.targetPos});
        return this.targetIterator.getLastReturned();
    }

    boolean canBreak(Level level, BlockPos pos, BlockState state) {
        FluidState fluid = level.getFluidState(pos);
        if (fluid.isEmpty()) {
            return !state.isAir() && !state.equals(this.stateAfterBreak(level, pos, state));
        }
        return this.shouldRemoveFluid();
    }

    @Nullable
    public AABB getRenderAabb() {
        Area area = this.getArea();
        if (area == null) {
            return null;
        }
        int minY = this.getLevel() == null ? 0 : this.getLevel().getMinBuildHeight();
        String string = this.renderMode();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"drill"}, (Object)string, n)) {
            case 0 -> new AABB((double)area.minX(), (double)minY, (double)area.minZ(), (double)area.maxX(), (double)area.maxY(), (double)area.maxZ());
            default -> null;
        };
    }

    @VisibleForTesting
    @NotNull
    public ItemEnchantments getEnchantments() {
        return (ItemEnchantments)this.components().getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
    }

    @VisibleForTesting
    public void setEnchantments(@NotNull ItemEnchantments enchantments) {
        this.setComponents(DataComponentMap.builder().addAll(this.components()).set(DataComponents.ENCHANTMENTS, (Object)enchantments).build());
    }

    static ItemConverter defaultItemConverter() {
        return ItemConverter.defaultInstance();
    }
}

