/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.mover;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.packet.ClientSync;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class MoverEntity
extends QpEntity
implements ClientSync {
    final SimpleContainer inventory = new Inventory(2);
    List<Holder<Enchantment>> movableEnchantments = List.of();

    public MoverEntity(BlockPos pos, BlockState blockState) {
        super(PlatformAccess.getAccess().registerObjects().getBlockEntityType((QpBlock)blockState.getBlock()).orElseThrow(), pos, blockState);
        this.inventory.addListener(container -> this.setChanged());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.inventory.fromTag(tag.getList("inventory", 10), registries);
        super.loadAdditional(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.createTag(registries));
    }

    @Override
    public void fromClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        HolderLookup.RegistryLookup enchantmentRegistry = registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.movableEnchantments = tag.getList("enchantments", 8).stream().map(Tag::getAsString).map(s -> ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)s))).map(arg_0 -> ((HolderLookup.RegistryLookup)enchantmentRegistry).getOrThrow(arg_0)).toList();
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag list = this.movableEnchantments.stream().map(Holder::unwrapKey).flatMap(Optional::stream).map(ResourceKey::location).map(ResourceLocation::toString).map(StringTag::valueOf).collect(Collectors.toCollection(ListTag::new));
        tag.put("enchantments", (Tag)list);
        return tag;
    }

    public void setChanged() {
        super.setChanged();
        this.updateMovableEnchantments();
    }

    void updateMovableEnchantments() {
        if (this.level != null && !this.level.isClientSide() && this.enabled) {
            List<Holder<Enchantment>> pre = this.movableEnchantments;
            this.movableEnchantments = MoverEntity.getMovable(this.inventory.getItem(0), this.inventory.getItem(1), e -> true);
            if (!pre.equals(this.movableEnchantments)) {
                this.syncToClient();
            }
        }
    }

    @VisibleForTesting
    static List<Holder<Enchantment>> getMovable(ItemStack from, ItemStack to, Predicate<Holder<Enchantment>> predicate) {
        if (from.isEmpty() || to.isEmpty()) {
            return List.of();
        }
        ItemEnchantments given = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)to);
        return EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)from).keySet().stream().filter(e -> MoverEntity.canMoveEnchantment(predicate, given, (Holder<Enchantment>)e)).sorted(Comparator.comparing(Holder::getRegisteredName)).toList();
    }

    @VisibleForTesting
    static boolean canMoveEnchantment(@Nullable Predicate<Holder<Enchantment>> predicate, ItemEnchantments given, Holder<Enchantment> toMove) {
        return (predicate == null || predicate.test(toMove)) && given.getLevel(toMove) < ((Enchantment)toMove.value()).getMaxLevel() && given.keySet().stream().filter(Predicate.isEqual(toMove).negate()).allMatch(e -> Enchantment.areCompatible((Holder)e, (Holder)toMove));
    }

    void moveEnchant(Holder<Enchantment> enchantment) {
        MoverEntity.moveEnchantment(enchantment, this.inventory.getItem(0), this.inventory.getItem(1), this::updateMovableEnchantments);
    }

    static void moveEnchantment(@Nullable Holder<Enchantment> enchantment, ItemStack from, ItemStack to, Runnable after) {
        MoverEntity.moveEnchantment(enchantment, from, to, null, after);
    }

    @VisibleForTesting
    static void moveEnchantment(@Nullable Holder<Enchantment> enchantment, ItemStack from, ItemStack to, @Nullable Predicate<Holder<Enchantment>> predicate, Runnable after) {
        if (enchantment == null || from.isEmpty() || to.isEmpty()) {
            return;
        }
        if (MoverEntity.canMoveEnchantment(predicate, EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)to), enchantment)) {
            MoverEntity.upLevel(enchantment, to);
            MoverEntity.downLevel(enchantment, from);
            after.run();
        }
    }

    @VisibleForTesting
    static void downLevel(Holder<Enchantment> enchantment, ItemStack stack) {
        EnchantmentHelper.updateEnchantments((ItemStack)stack, mutable -> mutable.set(enchantment, mutable.getLevel(enchantment) - 1));
    }

    @VisibleForTesting
    static void upLevel(Holder<Enchantment> enchantment, ItemStack stack) {
        EnchantmentHelper.updateEnchantments((ItemStack)stack, mutable -> mutable.set(enchantment, mutable.getLevel(enchantment) + 1));
    }

    private static class Inventory
    extends SimpleContainer {
        public Inventory(int size) {
            super(size);
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (!stack.isEnchanted()) {
                        yield false;
                    }
                    Item v1 = stack.getItem();
                    Objects.requireNonNull(v1);
                    Item var3_3 = v1;
                    int var4_4 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TieredItem.class, BowItem.class}, (Object)var3_3, var4_4)) {
                        case 0: {
                            TieredItem tieredItem = (TieredItem)var3_3;
                            if (tieredItem.getTier().getUses() >= Tiers.DIAMOND.getUses()) {
                                yield true;
                            }
                            yield false;
                        }
                        case 1: {
                            BowItem ignore = (BowItem)var3_3;
                            yield true;
                        }
                    }
                    yield false;
                }
                case 1 -> {
                    if (stack.is((Item)PlatformAccess.getAccess().registerObjects().quarryBlock().get().blockItem) || stack.is((Item)PlatformAccess.getAccess().registerObjects().advQuarryBlock().get().blockItem)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

