/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.config.EnableMap;
import com.yogpc.qp.config.QuarryConfigLoader;
import com.yogpc.qp.machine.PowerMap;
import java.nio.file.Path;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.VisibleForTesting;

public interface QuarryConfig {
    public boolean debug();

    public boolean noEnergy();

    public PowerMap powerMap();

    public EnableMap enableMap();

    public double rebornEnergyConversionCoefficient();

    public boolean removeBedrockOnNetherTop();

    public boolean enableChunkLoader();

    public boolean convertDeepslateOres();

    public boolean removeCommonMaterialsByChunkDestroyer();

    public static QuarryConfig load(Path path, BooleanSupplier inDevelop) {
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).preserveInsertionOrder().sync().autosave().onLoad(() -> QuarryPlus.LOGGER.info("Config loaded from {}", (Object)path)).onAutoSave(() -> QuarryPlus.LOGGER.info("Config saved to {}", (Object)path)).build();){
            config.load();
            QuarryConfig quarryConfig = QuarryConfigLoader.load((Config)config, inDevelop);
            return quarryConfig;
        }
    }

    @VisibleForTesting
    public static QuarryConfig defaultConfig(boolean debug) {
        return QuarryConfig.fromConfig(Config.inMemory(), debug);
    }

    @VisibleForTesting
    public static QuarryConfig fromConfig(Config config, boolean debug) {
        return QuarryConfigLoader.load(config, () -> debug);
    }
}

