/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.wireless.blocks;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.client.ControllerChannelClientInfo;
import mcjty.xnet.compat.XNetTOPDriver;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.modules.wireless.WirelessRouterModule;
import mcjty.xnet.modules.wireless.data.WirelessRouterData;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WirelessChannelKey;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.multiblock.XNetWirelessChannels;
import mcjty.xnet.setup.Config;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public final class TileEntityWirelessRouter
extends TickingTileEntity {
    public static final int TIER_INVALID = -1;
    public static final int TIER_1 = 0;
    public static final int TIER_2 = 1;
    public static final int TIER_INF = 2;
    private boolean error = false;
    private int counter = 10;
    private int globalChannelVersion = -1;
    private final GenericEnergyStorage energyHandler = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)Config.wirelessRouterMaxRF.get()).intValue(), (long)((Integer)Config.wirelessRouterRfPerTick.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<TileEntityWirelessRouter, GenericEnergyStorage> ENERGY_CAP = te -> te.energyHandler;
    @Cap(type=CapType.CONTAINER)
    private static final Function<TileEntityWirelessRouter, MenuProvider> screenHandler = be -> new DefaultContainerProvider(I18nConstants.BLOCK_WIRELESS_ROUTER.i18n(new Object[0])).containerSupplier(DefaultContainerProvider.empty(WirelessRouterModule.CONTAINER_WIRELESS_ROUTER, (GenericTileEntity)be)).data(WirelessRouterModule.WIRELESS_ROUTER_DATA, WirelessRouterData.STREAM_CODEC).setupSync((GenericTileEntity)be);

    public TileEntityWirelessRouter(BlockPos pos, BlockState state) {
        super((BlockEntityType)WirelessRouterModule.WIRELESS_ROUTER.be().get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)XNetTOPDriver.DRIVER).tileEntitySupplier(TileEntityWirelessRouter::new).manualEntry(ManualHelper.create((String)"rftoolsbase:simple/wireless/wireless_router")).info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.createBlockStateDefinition(builder);
                builder.add(new Property[]{TileEntityController.ERROR});
            }
        };
    }

    public boolean isPublicAccess() {
        WirelessRouterData data = (WirelessRouterData)this.getData(WirelessRouterModule.WIRELESS_ROUTER_DATA);
        return data.publicAccess();
    }

    public void setPublicAccess(boolean publicAccess) {
        WirelessRouterData data = (WirelessRouterData)this.getData(WirelessRouterModule.WIRELESS_ROUTER_DATA);
        data = data.withPublicAccess(publicAccess);
        this.setData(WirelessRouterModule.WIRELESS_ROUTER_DATA, data);
    }

    public void tickServer() {
        NetworkId networkId;
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 10;
        int version = XNetWirelessChannels.get(this.level).getGlobalChannelVersion();
        if (this.globalChannelVersion != version) {
            this.globalChannelVersion = version;
            NetworkId networkId2 = this.findRoutingNetwork();
            if (networkId2 != null) {
                WorldBlob worldBlob = XNetBlobData.get(this.level).getWorldBlob(this.level);
                worldBlob.markNetworkDirty(networkId2);
            }
        }
        boolean err = false;
        int range = this.getAntennaRange();
        if (range < 0) {
            err = true;
        }
        if (!err && (networkId = this.findRoutingNetwork()) != null) {
            LogicTools.consumers(this.level, networkId).forEach(consumerPos -> LogicTools.forEachRouter(this.level, consumerPos, r -> this.publishChannels((TileEntityRouter)((Object)((Object)r)), networkId)));
        }
        this.setError(err);
    }

    private int getAntennaTier() {
        if (this.level.getBlockState(this.worldPosition.above()).getBlock() != WirelessRouterModule.ANTENNA_BASE.get()) {
            return -1;
        }
        Block aboveAntenna = this.level.getBlockState(this.worldPosition.above(2)).getBlock();
        if (aboveAntenna == WirelessRouterModule.ANTENNA_DISH.get()) {
            return 2;
        }
        if (aboveAntenna != WirelessRouterModule.ANTENNA.get()) {
            return -1;
        }
        if (this.level.getBlockState(this.worldPosition.above(3)).getBlock() == WirelessRouterModule.ANTENNA.get()) {
            return 1;
        }
        return 0;
    }

    private int getAntennaRange() {
        int tier = this.getAntennaTier();
        return switch (tier) {
            case -1 -> -1;
            case 0 -> (Integer)Config.antennaTier1Range.get();
            case 1 -> (Integer)Config.antennaTier2Range.get();
            case 2 -> Integer.MAX_VALUE;
            default -> -1;
        };
    }

    private boolean inRange(TileEntityWirelessRouter otherRouter) {
        int thisRange = this.getAntennaRange();
        int otherRange = otherRouter.getAntennaRange();
        if (thisRange >= Integer.MAX_VALUE && otherRange >= Integer.MAX_VALUE) {
            return true;
        }
        if (thisRange <= 0 || otherRange <= 0) {
            return false;
        }
        if (!this.level.dimension().equals(otherRouter.level.dimension())) {
            return false;
        }
        double maxSqdist = Math.min(thisRange, otherRange);
        maxSqdist *= maxSqdist;
        double sqdist = this.worldPosition.distSqr((Vec3i)otherRouter.worldPosition);
        return sqdist <= maxSqdist;
    }

    private boolean inRange(XNetWirelessChannels.WirelessRouterInfo wirelessRouter) {
        ServerLevel otherWorld = LevelTools.getLevel((Level)this.level, (ResourceKey)wirelessRouter.getCoordinate().dimension());
        if (otherWorld == null) {
            return false;
        }
        for (BlockPos consumerPos : LogicTools.consumers((Level)otherWorld, wirelessRouter.getNetworkId())) {
            if (!LevelTools.isLoaded((Level)otherWorld, (BlockPos)consumerPos) || !LogicTools.findWirelessRouter((Level)otherWorld, consumerPos, this::inRange)) continue;
            return true;
        }
        return false;
    }

    public void findRemoteChannelInfo(List<ControllerChannelClientInfo> list) {
        NetworkId network = this.findRoutingNetwork();
        if (network == null) {
            return;
        }
        XNetWirelessChannels wirelessData = XNetWirelessChannels.get(this.level);
        wirelessData.forEachChannel(this.getOwnerUUID(), channel -> channel.getRouters().values().forEach(routerInfo -> {
            if (this.isDifferentRouter(network, (XNetWirelessChannels.WirelessRouterInfo)routerInfo) && this.inRange((XNetWirelessChannels.WirelessRouterInfo)routerInfo)) {
                ServerLevel otherWorld = LevelTools.getLevel((Level)this.level, (ResourceKey)routerInfo.getCoordinate().dimension());
                for (BlockPos consumerPos : LogicTools.consumers((Level)otherWorld, routerInfo.getNetworkId())) {
                    if (!otherWorld.hasChunkAt(consumerPos)) continue;
                    LogicTools.forEachRouter((Level)otherWorld, consumerPos, router -> router.findLocalChannelInfo(list, true, true));
                }
            }
        }));
    }

    private boolean isDifferentRouter(NetworkId thisNetwork, XNetWirelessChannels.WirelessRouterInfo routerInfo) {
        return !routerInfo.getCoordinate().dimension().equals(this.level.dimension()) || !thisNetwork.equals((Object)routerInfo.getNetworkId());
    }

    private void publishChannels(TileEntityRouter router, NetworkId networkId) {
        int tier = this.getAntennaTier();
        WirelessRouterData data = (WirelessRouterData)this.getData(WirelessRouterModule.WIRELESS_ROUTER_DATA);
        UUID ownerUUID = data.publicAccess() ? null : this.getOwnerUUID();
        XNetWirelessChannels wirelessData = XNetWirelessChannels.get(this.level);
        router.forEachPublishedChannel((name, channelType) -> {
            long energyStored = this.energyHandler.getEnergy();
            if ((long)((Integer)Config.wirelessRouterRfPerChannel[tier].get()).intValue() <= energyStored) {
                this.energyHandler.consumeEnergy((long)((Integer)Config.wirelessRouterRfPerChannel[tier].get()).intValue());
                wirelessData.transmitChannel((String)name, (IChannelType)channelType, ownerUUID, (ResourceKey<Level>)this.level.dimension(), this.worldPosition, networkId);
            }
        });
    }

    public void addWirelessConnectors(Map<SidedConsumer, IConnectorSettings> connectors, String channelName, IChannelType type, @Nullable UUID owner) {
        WirelessChannelKey key = new WirelessChannelKey(channelName, type, owner);
        XNetWirelessChannels.WirelessChannelInfo info = XNetWirelessChannels.get(this.level).findChannel(key);
        if (info != null) {
            info.getRouters().keySet().forEach(routerPos -> {
                NetworkId routingNetwork;
                TileEntityWirelessRouter otherRouter;
                BlockEntity otherTE;
                ServerLevel otherWorld;
                if ((!routerPos.dimension().equals(this.level.dimension()) || !routerPos.pos().equals((Object)this.worldPosition)) && LevelTools.isLoaded((Level)(otherWorld = LevelTools.getLevel((Level)this.level, (ResourceKey)routerPos.dimension())), (BlockPos)routerPos.pos()) && (otherTE = otherWorld.getBlockEntity(routerPos.pos())) instanceof TileEntityWirelessRouter && this.inRange(otherRouter = (TileEntityWirelessRouter)otherTE) && !otherRouter.inError() && (routingNetwork = otherRouter.findRoutingNetwork()) != null) {
                    LogicTools.consumers(this.level, routingNetwork).forEach(consumerPos -> LogicTools.forEachRouter((Level)otherWorld, consumerPos, router -> router.addConnectorsFromConnectedNetworks(connectors, channelName, type)));
                }
            });
        }
    }

    private void setError(boolean err) {
        if (this.error != err) {
            this.error = err;
            BlockState state = this.level.getBlockState(this.worldPosition);
            if (this.error) {
                if (!((Boolean)state.getValue((Property)TileEntityController.ERROR)).booleanValue()) {
                    this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(true)), 3);
                }
            } else if (((Boolean)state.getValue((Property)TileEntityController.ERROR)).booleanValue()) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.markDirtyQuick();
        }
    }

    public boolean inError() {
        return this.error;
    }

    @Nullable
    public NetworkId findRoutingNetwork() {
        WorldBlob worldBlob = XNetBlobData.get(this.level).getWorldBlob(this.level);
        return LogicTools.findRoutingConnector(this.level, this.getBlockPos(), worldBlob::getNetworkAt);
    }

    public void saveAdditional(@Nonnull CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.saveAdditional(tagCompound, provider);
        tagCompound.putBoolean("error", this.error);
    }

    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider provider) {
        super.loadAdditional(tagCompound, provider);
        this.error = tagCompound.getBoolean("error");
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        WirelessRouterData data = (WirelessRouterData)input.get(WirelessRouterModule.ITEM_WIRELESS_ROUTER_DATA);
        if (data != null) {
            this.setData(WirelessRouterModule.WIRELESS_ROUTER_DATA, data);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(WirelessRouterModule.ITEM_WIRELESS_ROUTER_DATA, (Object)((WirelessRouterData)this.getData(WirelessRouterModule.WIRELESS_ROUTER_DATA)));
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        if (state.getBlock() == newstate.getBlock()) {
            return;
        }
        if (!this.level.isClientSide) {
            XNetBlobData blobData = XNetBlobData.get(this.level);
            WorldBlob worldBlob = blobData.getWorldBlob(this.level);
            worldBlob.removeCableSegment(pos);
            blobData.save();
        }
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.isClientSide) {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, new ColorId(CableColor.ROUTING.ordinal() + 1), networkId);
            blobData.save();
        }
    }

    public BlockState getActualState(BlockState state) {
        return (BlockState)state.setValue((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(this.inError()));
    }
}

