/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.blocks;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.xnet.channels.IConnectable;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.XNet;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.cables.blocks.NetCableBlock;
import mcjty.xnet.modules.cables.data.CableItemData;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.blocks.FacadeBlockItem;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.modules.various.blocks.RedstoneProxyBlock;
import mcjty.xnet.modules.wireless.blocks.TileEntityWirelessRouter;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.setup.Config;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;

public class ConnectorBlock
extends GenericCableBlock
implements ITooltipSettings,
EntityBlock {
    public static final ManualEntry MANUAL = ManualHelper.create((String)"rftoolsbase:simple/connector");
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(stack -> this.isAdvancedConnector()), TooltipBuilder.parameter((String)"info", stack -> Integer.toString(this.isAdvancedConnector() ? (Integer)Config.maxRfAdvancedConnector.get() : (Integer)Config.maxRfConnector.get()))}));

    public ConnectorBlock(GenericCableBlock.CableBlockType type) {
        super(type);
    }

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ConnectorTileEntity(pPos, pState);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity te;
        if (!world.isClientSide && (te = world.getBlockEntity(pos)) instanceof GenericTileEntity) {
            final GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            player.openMenu(new MenuProvider(){

                @Nonnull
                public Component getDisplayName() {
                    return ComponentFactory.literal((String)I18nConstants.BLOCK_CONNECTOR.i18n(new Object[0]));
                }

                @Nonnull
                public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
                    return new GenericContainer(CableModule.CONTAINER_CONNECTOR, id, (Supplier)ContainerFactory.EMPTY, genericTileEntity, player);
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void playerDestroy(@Nonnull Level worldIn, @Nonnull Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity te, @Nonnull ItemStack stack) {
        ConnectorTileEntity connectorTileEntity;
        if (te instanceof ConnectorTileEntity && (connectorTileEntity = (ConnectorTileEntity)te).getMimicBlock() != null) {
            ItemStack item = new ItemStack((ItemLike)FacadeModule.FACADE.get());
            FacadeBlockItem.setMimicBlock(item, connectorTileEntity.getMimicBlock());
            connectorTileEntity.setMimicBlock(null);
            ConnectorBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)item);
            return;
        }
        super.playerDestroy(worldIn, player, pos, state, te, stack);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof ConnectorTileEntity) {
            ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)te;
            if (connectorTileEntity.getMimicBlock() == null) {
                this.playerWillDestroy(world, pos, state, player);
                return world.setBlock(pos, Blocks.AIR.defaultBlockState(), world.isClientSide ? 11 : 3);
            }
            this.playerWillDestroy(world, pos, state, player);
            if (player.getAbilities().instabuild) {
                connectorTileEntity.setMimicBlock(null);
            }
        } else {
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        return true;
    }

    public void neighborChanged(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        this.checkRedstone(world, pos);
        super.neighborChanged(state, world, pos, blockIn, fromPos, isMoving);
    }

    public void onNeighborChange(BlockState state, LevelReader blockAccess, BlockPos pos, BlockPos neighbor) {
        BlockEntity te;
        if (!blockAccess.isClientSide() && (te = blockAccess.getBlockEntity(pos)) instanceof ConnectorTileEntity) {
            ConnectorTileEntity connector = (ConnectorTileEntity)te;
            connector.possiblyMarkNetworkDirty(neighbor);
        }
        super.onNeighborChange(state, blockAccess, pos, neighbor);
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    private void checkRedstone(Level world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof ConnectorTileEntity) {
            ConnectorTileEntity connector = (ConnectorTileEntity)te;
            int powered = world.getBestNeighborSignal(pos);
            connector.setPowerInput(powered);
        }
    }

    public boolean isSignalSource(@Nonnull BlockState state) {
        return true;
    }

    public int getSignal(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    public int getDirectSignal(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    protected int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity te = world.getBlockEntity(pos);
        if (state.getBlock() instanceof ConnectorBlock && te instanceof ConnectorTileEntity) {
            ConnectorTileEntity connector = (ConnectorTileEntity)te;
            return connector.getPowerOut(side.getOpposite());
        }
        return 0;
    }

    @Override
    protected ConnectorType getConnectorType(@Nonnull CableColor color, BlockGetter world, BlockPos connectorPos, Direction facing) {
        BlockPos pos = connectorPos.relative(facing);
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if ((block instanceof NetCableBlock || block instanceof ConnectorBlock) && state.getValue((Property)COLOR) == color) {
            return ConnectorType.CABLE;
        }
        if (ConnectorBlock.isConnectable(world, connectorPos, facing) && color != CableColor.ROUTING) {
            return ConnectorType.BLOCK;
        }
        if (ConnectorBlock.isConnectableRouting(world, pos) && color == CableColor.ROUTING) {
            return ConnectorType.BLOCK;
        }
        return ConnectorType.NONE;
    }

    public static boolean isConnectableRouting(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te == null) {
            return false;
        }
        return te instanceof TileEntityRouter || te instanceof TileEntityWirelessRouter;
    }

    public static boolean isConnectable(BlockGetter world, BlockPos connectorPos, Direction facing) {
        BlockPos pos = connectorPos.relative(facing);
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (state.isAir()) {
            return false;
        }
        BlockEntity tileEntity = world.getBlockEntity(connectorPos);
        if (!(tileEntity instanceof ConnectorTileEntity)) {
            return false;
        }
        ConnectorTileEntity connectorTE = (ConnectorTileEntity)tileEntity;
        if (!connectorTE.isEnabled(facing)) {
            return false;
        }
        BlockEntity te = world.getBlockEntity(pos);
        if (block instanceof IConnectable) {
            IConnectable connectable = (IConnectable)block;
            IConnectable.ConnectResult result = connectable.canConnect(world, connectorPos, pos, te, facing);
            if (result == IConnectable.ConnectResult.NO) {
                return false;
            }
            if (result == IConnectable.ConnectResult.YES) {
                return true;
            }
        }
        for (IConnectable connectable : XNet.xNetApi.getConnectables()) {
            IConnectable.ConnectResult result = connectable.canConnect(world, connectorPos, pos, te, facing);
            if (result == IConnectable.ConnectResult.NO) {
                return false;
            }
            if (result != IConnectable.ConnectResult.YES) continue;
            return true;
        }
        if (block instanceof ConnectorBlock) {
            return false;
        }
        if (block instanceof RedstoneProxyBlock || block == Blocks.REDSTONE_LAMP || block == Blocks.PISTON || block == Blocks.STICKY_PISTON) {
            return true;
        }
        if (block.canConnectRedstone(state, world, pos, null) || state.isSignalSource()) {
            return true;
        }
        if (te == null) {
            return false;
        }
        if (EnergyTools.isEnergyTE((BlockEntity)te, null)) {
            return true;
        }
        Level level = te.getLevel();
        if (level.getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), null) != null) {
            return true;
        }
        if (level.getCapability(Capabilities.FluidHandler.BLOCK, te.getBlockPos(), null) != null) {
            return true;
        }
        if (te instanceof TileEntityController) {
            return true;
        }
        return te instanceof TileEntityRouter;
    }

    @Override
    @Nonnull
    public List<ItemStack> getDrops(@Nonnull BlockState state, @Nonnull LootParams.Builder builder) {
        List<ItemStack> drops = super.getDrops(state, builder);
        ServerLevel world = builder.getLevel();
        for (ItemStack drop : drops) {
            WorldBlob worldBlob = XNetBlobData.get((Level)world).getWorldBlob((Level)world);
            Vec3 pos = (Vec3)builder.getOptionalParameter(LootContextParams.ORIGIN);
            ConsumerId consumer = worldBlob.getConsumerAt(new BlockPos((int)pos.x, (int)pos.y, (int)pos.z));
            if (consumer == null) continue;
            drop.set(CableModule.ITEM_CABLE_ITEM_DATA, (Object)new CableItemData(consumer));
        }
        return drops;
    }

    public void appendHoverText(@Nonnull ItemStack stack, Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Block)this), stack, tooltip, flagIn);
    }

    @Override
    public void createCableSegment(Level world, BlockPos pos, ItemStack stack) {
        ConsumerId consumer;
        if (!stack.isEmpty() && stack.get(CableModule.ITEM_CABLE_ITEM_DATA) != null) {
            consumer = ((CableItemData)stack.get(CableModule.ITEM_CABLE_ITEM_DATA)).id();
        } else {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            consumer = worldBlob.newConsumer();
        }
        this.createCableSegment(world, pos, consumer);
    }

    public void createCableSegment(Level world, BlockPos pos, ConsumerId consumer) {
        XNetBlobData blobData = XNetBlobData.get(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        CableColor color = (CableColor)((Object)world.getBlockState(pos).getValue((Property)COLOR));
        worldBlob.createNetworkConsumer(pos, new ColorId(color.ordinal() + 1), consumer);
        blobData.save();
    }

    public static boolean isAdvancedConnector(@Nonnull Level world, @Nonnull BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        if (block instanceof GenericCableBlock) {
            return ((GenericCableBlock)block).isAdvancedConnector();
        }
        return false;
    }

    @Override
    public boolean isAdvancedConnector() {
        return false;
    }
}

