/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.client;

import javax.annotation.Nonnull;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.SidedPos;
import mcjty.xnet.XNet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ConnectorClientInfo {
    @Nonnull
    private final SidedPos pos;
    @Nonnull
    private final ConsumerId consumerId;
    @Nonnull
    private final IChannelType channelType;
    @Nonnull
    private final IConnectorSettings connectorSettings;
    public static final StreamCodec<RegistryFriendlyByteBuf, ConnectorClientInfo> STREAM_CODEC = StreamCodec.of((buf, info) -> {
        buf.writeUtf(info.channelType.getID());
        StreamCodec streamCodec = info.channelType.getConnectorStreamCodec();
        streamCodec.encode(buf, (Object)info.connectorSettings);
        SidedPos.STREAM_CODEC.encode(buf, (Object)info.pos);
        buf.writeInt(info.consumerId.id());
    }, buf -> {
        String id = buf.readUtf(Short.MAX_VALUE);
        IChannelType type = XNet.xNetApi.findType(id);
        IConnectorSettings settings = (IConnectorSettings)type.getConnectorStreamCodec().decode(buf);
        SidedPos pos = (SidedPos)SidedPos.STREAM_CODEC.decode(buf);
        ConsumerId consumerId = new ConsumerId(buf.readInt());
        return new ConnectorClientInfo(pos, consumerId, type, settings);
    });

    public ConnectorClientInfo(@Nonnull SidedPos pos, @Nonnull ConsumerId consumerId, @Nonnull IChannelType channelType, @Nonnull IConnectorSettings connectorSettings) {
        this.pos = pos;
        this.consumerId = consumerId;
        this.channelType = channelType;
        this.connectorSettings = connectorSettings;
    }

    public ConnectorClientInfo(@Nonnull RegistryFriendlyByteBuf buf) {
        this.pos = new SidedPos(buf.readBlockPos(), OrientationTools.DIRECTION_VALUES[buf.readByte()]);
        this.consumerId = new ConsumerId(buf.readInt());
        IChannelType t = XNet.xNetApi.findType(buf.readUtf(Short.MAX_VALUE));
        if (t == null) {
            throw new RuntimeException("Cannot happen!");
        }
        this.channelType = t;
        StreamCodec codec = this.channelType.getConnectorStreamCodec();
        this.connectorSettings = (IConnectorSettings)codec.decode((Object)buf);
    }

    public void writeToBuf(@Nonnull RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos.pos());
        buf.writeByte(this.pos.side().ordinal());
        buf.writeInt(this.consumerId.id());
        buf.writeUtf(this.channelType.getID());
        StreamCodec codec = this.channelType.getConnectorStreamCodec();
        codec.encode((Object)buf, (Object)this.connectorSettings);
    }

    @Nonnull
    public SidedPos getPos() {
        return this.pos;
    }

    @Nonnull
    public ConsumerId getConsumerId() {
        return this.consumerId;
    }

    @Nonnull
    public IConnectorSettings getConnectorSettings() {
        return this.connectorSettings;
    }
}

