/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.client;

import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.keys.SidedPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class ConnectedBlockClientInfo {
    @Nonnull
    private final SidedPos pos;
    @Nonnull
    private final ItemStack connectedBlock;
    @Nonnull
    private final String name;
    @Nonnull
    private final String blockName;

    public ConnectedBlockClientInfo(@Nonnull SidedPos pos, @Nonnull ItemStack connectedBlock, @Nonnull String name) {
        this.pos = pos;
        this.connectedBlock = connectedBlock;
        this.name = name;
        this.blockName = ConnectedBlockClientInfo.getStackUnlocalizedName(connectedBlock);
    }

    public ConnectedBlockClientInfo(@Nonnull RegistryFriendlyByteBuf buf) {
        this.pos = new SidedPos(buf.readBlockPos(), OrientationTools.DIRECTION_VALUES[buf.readByte()]);
        this.connectedBlock = NetworkTools.readItemStack((RegistryFriendlyByteBuf)buf);
        this.name = NetworkTools.readStringUTF8((FriendlyByteBuf)buf);
        this.blockName = NetworkTools.readStringUTF8((FriendlyByteBuf)buf);
    }

    public void writeToBuf(@Nonnull RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos.pos());
        buf.writeByte(this.pos.side().ordinal());
        NetworkTools.writeItemStack((RegistryFriendlyByteBuf)buf, (ItemStack)this.connectedBlock);
        NetworkTools.writeStringUTF8((FriendlyByteBuf)buf, (String)this.name);
        NetworkTools.writeStringUTF8((FriendlyByteBuf)buf, (String)this.blockName);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getBlockUnlocName() {
        return this.blockName;
    }

    @Nonnull
    public SidedPos getPos() {
        return this.pos;
    }

    @Nonnull
    public ItemStack getConnectedBlock() {
        return this.connectedBlock;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectedBlockClientInfo that = (ConnectedBlockClientInfo)o;
        return this.pos.equals((Object)that.pos);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    private static String getStackUnlocalizedName(ItemStack stack) {
        return stack.getItem().getDescriptionId(stack);
    }

    public static class Serializer
    implements ISerializer<ConnectedBlockClientInfo> {
        public Function<RegistryFriendlyByteBuf, ConnectedBlockClientInfo> getDeserializer() {
            return buf -> {
                if (buf.readBoolean()) {
                    return new ConnectedBlockClientInfo((RegistryFriendlyByteBuf)buf);
                }
                return null;
            };
        }

        public BiConsumer<RegistryFriendlyByteBuf, ConnectedBlockClientInfo> getSerializer() {
            return (buf, info) -> {
                if (info == null) {
                    buf.writeBoolean(false);
                } else {
                    buf.writeBoolean(true);
                    info.writeToBuf((RegistryFriendlyByteBuf)buf);
                }
            };
        }
    }
}

