/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.xnet.apiimpl.logic.enums.LogicFilter;
import mcjty.xnet.utils.CastTools;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class RSOutput {
    private boolean isAdvanced;
    private LogicFilter logicFilter = LogicFilter.DIRECT;
    private Color inputChannel1 = Color.OFF;
    private Color inputChannel2 = Color.OFF;
    private int redstoneOut = 0;
    private boolean impulse = false;
    private int impulseDuration = 1;
    private int countingHolder = 0;
    private int ticksHolder = 5;
    private boolean flipFlapState = false;
    private boolean lastInputTrue = false;
    private int impulseRemaining = 0;
    private int countingCurrent = 0;
    private int ticksCurrent = 5;
    public static final Codec<RSOutput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("advanced", (Object)false).forGetter(RSOutput::isAdvanced), (App)LogicFilter.CODEC.fieldOf("filter").forGetter(RSOutput::getLogicFilter), (App)Color.CODEC.fieldOf("channel1").forGetter(RSOutput::getInputChannel1), (App)Color.CODEC.fieldOf("channel2").forGetter(RSOutput::getInputChannel2), (App)Codec.INT.fieldOf("redstoneOut").forGetter(RSOutput::getRedstoneOut), (App)Codec.INT.fieldOf("countingHolder").forGetter(RSOutput::getCountingHolder), (App)Codec.INT.fieldOf("ticksHolder").forGetter(RSOutput::getTicksHolder), (App)Codec.BOOL.fieldOf("impulse").forGetter(RSOutput::isImpulse), (App)Codec.INT.fieldOf("impulseDuration").forGetter(RSOutput::getImpulseDuration)).apply((Applicative)instance, RSOutput::new));
    public static final StreamCodec<FriendlyByteBuf, RSOutput> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, RSOutput::isAdvanced, LogicFilter.STREAM_CODEC, RSOutput::getLogicFilter, (StreamCodec)Color.STREAM_CODEC, RSOutput::getInputChannel1, (StreamCodec)Color.STREAM_CODEC, RSOutput::getInputChannel2, (StreamCodec)ByteBufCodecs.INT, RSOutput::getRedstoneOut, (StreamCodec)ByteBufCodecs.INT, RSOutput::getCountingHolder, (StreamCodec)ByteBufCodecs.INT, RSOutput::getTicksHolder, (StreamCodec)ByteBufCodecs.BOOL, RSOutput::isImpulse, (StreamCodec)ByteBufCodecs.INT, RSOutput::getImpulseDuration, RSOutput::new);

    public RSOutput(boolean isAdvanced, LogicFilter logicFilter, Color inputChannel1, Color inputChannel2, int redstoneOut, int countingHolder, int ticksHolder, boolean impulse, int impulseDuration) {
        this.isAdvanced = isAdvanced;
        this.logicFilter = logicFilter;
        this.inputChannel1 = inputChannel1;
        this.inputChannel2 = inputChannel2;
        this.redstoneOut = redstoneOut;
        this.countingHolder = countingHolder;
        this.ticksHolder = ticksHolder;
        this.impulse = impulse;
        this.impulseDuration = impulseDuration;
    }

    public RSOutput(boolean isAdvanced) {
        this.isAdvanced = isAdvanced;
    }

    public LogicFilter getLogicFilter() {
        return this.logicFilter;
    }

    public Color getInputChannel1() {
        return this.inputChannel1;
    }

    public Color getInputChannel2() {
        return this.inputChannel2;
    }

    public int getRedstoneOut() {
        return this.redstoneOut;
    }

    public int getCountingHolder() {
        return this.countingHolder;
    }

    public int getTicksHolder() {
        return this.ticksHolder;
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    public boolean isFlipFlapState() {
        return this.flipFlapState;
    }

    public boolean isLastInputTrue() {
        return this.lastInputTrue;
    }

    public int getCountingCurrent() {
        return this.countingCurrent;
    }

    public int getTicksCurrent() {
        return this.ticksCurrent;
    }

    protected void setAdvanced(boolean advanced) {
        this.isAdvanced = advanced;
    }

    public void setFlipFlapState(boolean flipFlapState) {
        this.flipFlapState = flipFlapState;
    }

    public void setLastInputTrue(boolean lastInputTrue) {
        this.lastInputTrue = lastInputTrue;
    }

    public void setCountingCurrent(int countingCurrent) {
        this.countingCurrent = countingCurrent;
    }

    public void setTicksCurrent(int ticksCurrent) {
        this.ticksCurrent = ticksCurrent;
    }

    public void setCountingHolder(int countingHolder) {
        this.countingHolder = countingHolder;
        this.countingCurrent = countingHolder;
    }

    public void setTicksHolder(int ticksHolder) {
        this.ticksHolder = ticksHolder;
        this.ticksCurrent = ticksHolder;
    }

    public void setLogicFilter(LogicFilter logicFilter) {
        this.logicFilter = logicFilter;
    }

    public void setInputChannel1(Color inputChannel1) {
        this.inputChannel1 = inputChannel1;
    }

    public void setInputChannel2(Color inputChannel2) {
        this.inputChannel2 = inputChannel2;
    }

    public void setRedstoneOut(int redstoneOut) {
        this.redstoneOut = redstoneOut;
    }

    public boolean isImpulse() {
        return this.impulse;
    }

    public void setImpulse(boolean impulse) {
        this.impulse = impulse;
    }

    public int getImpulseDuration() {
        return this.impulseDuration;
    }

    public void setImpulseDuration(int impulseDuration) {
        this.impulseDuration = impulseDuration;
    }

    public int getImpulseRemaining() {
        return this.impulseRemaining;
    }

    public boolean decreaseImpulseRemaining() {
        if (this.impulseRemaining > 0) {
            --this.impulseRemaining;
            return true;
        }
        return false;
    }

    public void setAndDecreaseImpulseRemaining() {
        this.impulseRemaining = this.impulseDuration;
        --this.impulseRemaining;
        this.lastInputTrue = true;
    }

    public void setImpulseRemaining(int impulseRemaining) {
        this.impulseRemaining = impulseRemaining;
    }

    public void createGui(IEditorGui gui) {
        if (gui.isAdvanced()) {
            gui.translatableChoices("RSFilter", (ITranslatableEnum)this.logicFilter, (ITranslatableEnum[])LogicFilter.values());
            this.logicFilter.createGui(this, gui);
        } else {
            gui.label(I18nConstants.LOGIC_RS_LABEL.i18n(new Object[0]));
            gui.colors("RSChannel1", I18nConstants.LOGIC_INPUT_CHANNEL_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.inputChannel1.getColor()), Color.COLORS);
            gui.integer("rsout", I18nConstants.LOGIC_RS_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.redstoneOut), 30, 15, 0).nl();
        }
    }

    public void update(Map<String, Object> data) {
        this.logicFilter = CastTools.safeLogicFilter(data.get("RSFilter"));
        this.inputChannel1 = CastTools.safeColor(data.get("RSChannel1"));
        this.inputChannel2 = CastTools.safeColor(data.get("RSChannel2"));
        this.countingHolder = CastTools.safeIntOrValue(data.get("RSCounter"), this.countingHolder);
        this.ticksHolder = CastTools.safeIntOrValue(data.get("RSTimer"), this.ticksHolder);
        this.redstoneOut = CastTools.safeIntOrValue(data.get("rsout"), this.redstoneOut);
        this.impulse = CastTools.safeBoolean(data.get("impulse"));
        this.impulseDuration = CastTools.safeIntOrValue(data.get("impulseDuration"), 1);
        this.impulseRemaining = CastTools.safeInt(data.get("impulseRemaining"));
    }

    public boolean isEnabled(String tag) {
        return switch (tag) {
            case "RSFilter", "rsout", "RSChannel1", "RSChannel2", "RSCounter", "RSTimer", "impulse" -> true;
            case "impulseDuration" -> this.impulse;
            default -> false;
        };
    }

    public void readFromNBT(CompoundTag tag) {
        this.impulseRemaining = tag.getInt("impulseRemaining");
        this.flipFlapState = tag.getBoolean("RSFlipFlapState");
        this.lastInputTrue = tag.getBoolean("RSLastInputTrue");
        this.countingCurrent = tag.getInt("RSCountingCurrent");
        this.ticksCurrent = tag.getInt("RSTicksCurrent");
    }

    public void writeToNBT(CompoundTag tag) {
        tag.putInt("impulseRemaining", this.impulseRemaining);
        tag.putBoolean("RSFlipFlapState", this.flipFlapState);
        tag.putBoolean("RSLastInputTrue", this.lastInputTrue);
        tag.putInt("RSCountingCurrent", this.countingCurrent);
        tag.putInt("RSTicksCurrent", this.ticksCurrent);
    }
}

