/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public interface WaveEntity
extends CodecProvider<WaveEntity> {
    public static final CodecMap<WaveEntity> CODEC = new CodecMap("Wave Entity");

    public static void initSerializers() {
        WaveEntity.register("standard", StandardWaveEntity.CODEC);
        CODEC.setDefaultCodec(StandardWaveEntity.CODEC);
    }

    private static void register(String id, Codec<? extends WaveEntity> codec) {
        CODEC.register(Gateways.loc(id), codec);
    }

    public LivingEntity createEntity(Level var1);

    public MutableComponent getDescription();

    public boolean shouldFinalizeSpawn();

    public int getCount();

    public static class StandardWaveEntity
    implements WaveEntity {
        public static Codec<StandardWaveEntity> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(t -> t.type), (App)Codec.STRING.optionalFieldOf("desc").forGetter(t -> Optional.of(t.desc)), (App)NBTAdapter.EITHER_CODEC.optionalFieldOf("nbt").forGetter(t -> Optional.of(t.tag)), (App)WaveModifier.CODEC.listOf().optionalFieldOf("modifiers", Collections.emptyList()).forGetter(t -> t.modifiers), (App)Codec.BOOL.optionalFieldOf("finalize_spawn", (Object)true).forGetter(t -> t.finalizeSpawn), (App)Codec.intRange((int)1, (int)256).optionalFieldOf("count", (Object)1).forGetter(t -> t.count)).apply((Applicative)inst, StandardWaveEntity::new));
        protected final EntityType<?> type;
        protected final String desc;
        protected final CompoundTag tag;
        protected final List<WaveModifier> modifiers;
        protected final boolean finalizeSpawn;
        protected final int count;

        public StandardWaveEntity(EntityType<?> type, Optional<String> desc, Optional<CompoundTag> tag, List<WaveModifier> modifiers, boolean finalizeSpawn, int count) {
            this.type = type;
            this.desc = desc.orElse(type.getDescriptionId());
            this.tag = tag.orElse(new CompoundTag());
            this.tag.putString("id", EntityType.getKey(type).toString());
            this.modifiers = modifiers;
            this.finalizeSpawn = finalizeSpawn;
            this.count = count;
        }

        @Override
        public LivingEntity createEntity(Level level) {
            Entity ent = EntityType.loadEntityRecursive((CompoundTag)this.tag, (Level)level, Function.identity());
            if (ent instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)ent;
                this.modifiers.forEach(m -> m.apply(living));
                return living;
            }
            return null;
        }

        @Override
        public MutableComponent getDescription() {
            return Component.translatable((String)"tooltip.gateways.with_count", (Object[])new Object[]{this.getCount(), Component.translatable((String)this.desc)});
        }

        @Override
        public boolean shouldFinalizeSpawn() {
            return this.finalizeSpawn;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public Codec<? extends WaveEntity> getCodec() {
            return CODEC;
        }
    }
}

