/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface Failure
extends CodecProvider<Failure> {
    public static final CodecMap<Failure> CODEC = new CodecMap("Gateway Failure");

    public void onFailure(ServerLevel var1, GatewayEntity var2, Player var3, GatewayEntity.FailureReason var4);

    public void appendHoverText(Item.TooltipContext var1, Consumer<MutableComponent> var2);

    public static void initSerializers() {
        Failure.register("explosion", ExplosionFailure.CODEC);
        Failure.register("mob_effect", MobEffectFailure.CODEC);
        Failure.register("summon", SummonFailure.CODEC);
        Failure.register("chanced", ChancedFailure.CODEC);
        Failure.register("command", CommandFailure.CODEC);
    }

    private static void register(String id, Codec<? extends Failure> codec) {
        CODEC.register(Gateways.loc(id), codec);
    }

    public record ExplosionFailure(float strength, boolean fire, boolean blockDamage) implements Failure
    {
        public static Codec<ExplosionFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("strength").forGetter(ExplosionFailure::strength), (App)Codec.BOOL.fieldOf("fire").forGetter(ExplosionFailure::fire), (App)Codec.BOOL.fieldOf("block_damage").forGetter(ExplosionFailure::blockDamage)).apply((Applicative)inst, ExplosionFailure::new));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            level.explode((Entity)gate, gate.getX(), gate.getY(), gate.getZ(), this.strength, this.fire, this.blockDamage ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE);
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)"failure.gateways.explosion", (Object[])new Object[]{Float.valueOf(this.strength), this.fire, this.blockDamage}));
        }
    }

    public record MobEffectFailure(Holder<MobEffect> effect, int duration, int amplifier) implements Failure
    {
        public static Codec<MobEffectFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("effect").forGetter(MobEffectFailure::effect), (App)Codec.INT.fieldOf("duration").forGetter(MobEffectFailure::duration), (App)Codec.INT.optionalFieldOf("amplifier", (Object)0).forGetter(MobEffectFailure::amplifier)).apply((Applicative)inst, MobEffectFailure::new));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            level.getNearbyPlayers(TargetingConditions.forNonCombat(), null, gate.getBoundingBox().inflate(gate.getGateway().rules().leashRange())).forEach(p -> p.addEffect(new MobEffectInstance(this.effect, this.duration, this.amplifier)));
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)"failure.gateways.mob_effect", (Object[])new Object[]{MobEffectFailure.toComponent(new MobEffectInstance(this.effect, this.duration, this.amplifier), ctx.tickRate())}));
        }

        private static Component toComponent(MobEffectInstance mobeffectinstance, float tps) {
            MutableComponent mutablecomponent = Component.translatable((String)mobeffectinstance.getDescriptionId());
            Holder mobeffect = mobeffectinstance.getEffect();
            if (mobeffectinstance.getAmplifier() > 0) {
                mutablecomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.translatable((String)("potion.potency." + mobeffectinstance.getAmplifier()))});
            }
            if (mobeffectinstance.getDuration() > 20) {
                mutablecomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.formatDuration((MobEffectInstance)mobeffectinstance, (float)1.0f, (float)tps)});
            }
            return mutablecomponent.withStyle(((MobEffect)mobeffect.value()).getCategory().getTooltipFormatting());
        }
    }

    public record SummonFailure(WaveEntity entity) implements Failure
    {
        public static Codec<SummonFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)WaveEntity.CODEC.fieldOf("entity").forGetter(SummonFailure::entity)).apply((Applicative)inst, SummonFailure::new));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            for (int i = 0; i < this.entity.getCount(); ++i) {
                LivingEntity ent = this.entity.createEntity((Level)level);
                if (ent == null) continue;
                Vec3 pos = gate.getGateway().spawnAlgo().spawn(level, gate.position(), gate, (Entity)ent);
                ent.setPos(pos != null ? pos : gate.position());
                level.addFreshEntity((Entity)ent);
            }
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)"failure.gateways.summon", (Object[])new Object[]{this.entity.getDescription()}));
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }
    }

    public record ChancedFailure(Failure failure, float chance) implements Failure
    {
        public static Codec<ChancedFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.fieldOf("failure").forGetter(ChancedFailure::failure), (App)Codec.FLOAT.fieldOf("chance").forGetter(ChancedFailure::chance)).apply((Applicative)inst, ChancedFailure::new));
        static DecimalFormat fmt = new DecimalFormat("##.##%");

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            if (level.random.nextFloat() < this.chance) {
                this.failure.onFailure(level, gate, summoner, reason);
            }
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            this.failure.appendHoverText(ctx, c -> list.accept(Component.translatable((String)"failure.gateways.chance", (Object[])new Object[]{fmt.format(this.chance * 100.0f), c})));
        }
    }

    public record CommandFailure(String command, String desc) implements Failure
    {
        public static Codec<CommandFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("command").forGetter(CommandFailure::command), (App)Codec.STRING.fieldOf("desc").forGetter(CommandFailure::desc)).apply((Applicative)inst, CommandFailure::new));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            String realCmd = this.command.replace("<summoner>", summoner.getGameProfile().getName());
            level.getServer().getCommands().performPrefixedCommand(gate.createCommandSourceStack(), realCmd);
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Item.TooltipContext ctx, Consumer<MutableComponent> list) {
            list.accept(Component.translatable((String)this.desc));
        }
    }
}

