/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apothic_attributes.api.AttributeHelper;
import dev.shadowsoffire.gateways.client.GatewaysClient;
import dev.shadowsoffire.gateways.entity.EndlessGatewayEntity;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Failure;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.gateways.gate.WaveModifier;
import dev.shadowsoffire.gateways.gate.endless.EndlessGateway;
import dev.shadowsoffire.gateways.gate.endless.EndlessModifier;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;

public class EndlessGateClient {
    public static void appendPearlTooltip(EndlessGateway gate, Item.TooltipContext ctx, List<Component> tooltips, TooltipFlag flag) {
        List<MutableComponent> list;
        List<Failure> failures;
        Wave wave = gate.baseWave();
        MutableComponent comp = Component.translatable((String)"tooltip.gateways.endless.base_wave").withStyle(ChatFormatting.GRAY);
        tooltips.add((Component)comp);
        comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.entities").withStyle(Style.EMPTY.withColor(8900331)));
        tooltips.add((Component)comp);
        for (WaveEntity waveEntity : wave.entities()) {
            comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.dot", (Object[])new Object[]{waveEntity.getDescription()}).withStyle(Style.EMPTY.withColor(8900331)));
            tooltips.add((Component)comp);
        }
        if (!wave.modifiers().isEmpty()) {
            comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.modifiers").withStyle(ChatFormatting.RED));
            tooltips.add((Component)comp);
            for (WaveModifier waveModifier : wave.modifiers()) {
                waveModifier.appendHoverText(ctx, c -> tooltips.add((Component)AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.dot", (Object[])new Object[]{c.withStyle(ChatFormatting.RED)}).withStyle(ChatFormatting.RED))));
            }
        }
        comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.rewards").withStyle(ChatFormatting.GOLD));
        tooltips.add((Component)comp);
        for (Reward reward : wave.rewards()) {
            reward.appendHoverText(ctx, c -> tooltips.add((Component)AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.dot", (Object[])new Object[]{c}).withStyle(ChatFormatting.GOLD))));
        }
        int modifIdx = Math.floorMod(GatewaysClient.scrollIdx, gate.modifiers().size());
        EndlessModifier endlessModifier = gate.modifiers().get(modifIdx);
        if (Screen.hasShiftDown()) {
            Iterator<Object> value;
            comp = Component.translatable((String)"tooltip.gateways.endless.modifier", (Object[])new Object[]{modifIdx + 1, gate.modifiers().size()}).withStyle(ChatFormatting.LIGHT_PURPLE);
            comp.append(CommonComponents.SPACE);
            comp.append((Component)Component.translatable((String)"tooltip.gateways.scroll").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withUnderlined(Boolean.valueOf(false))));
            tooltips.add((Component)comp);
            comp = AttributeHelper.list().append((Component)endlessModifier.appMode().getDescription().withStyle(ChatFormatting.LIGHT_PURPLE));
            tooltips.add((Component)comp);
            if (endlessModifier.waveTime() != 0) {
                value = endlessModifier.waveTime() > 0 ? "+" + endlessModifier.waveTime() : String.valueOf(endlessModifier.waveTime());
                comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.endless.wave_time", (Object[])new Object[]{value}).withStyle(ChatFormatting.LIGHT_PURPLE));
                tooltips.add((Component)comp);
            }
            if (endlessModifier.setupTime() != 0) {
                value = endlessModifier.setupTime() > 0 ? "+" + endlessModifier.setupTime() : String.valueOf(endlessModifier.setupTime());
                comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.endless.setup_time", (Object[])new Object[]{value}).withStyle(ChatFormatting.LIGHT_PURPLE));
                tooltips.add((Component)comp);
            }
            if (!endlessModifier.entities().isEmpty()) {
                comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.entities").withStyle(Style.EMPTY.withColor(8900331)));
                tooltips.add((Component)comp);
                for (WaveEntity waveEntity : endlessModifier.entities()) {
                    comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.dot", (Object[])new Object[]{waveEntity.getDescription()}).withStyle(Style.EMPTY.withColor(8900331)));
                    tooltips.add((Component)comp);
                }
            }
            if (!endlessModifier.modifiers().isEmpty()) {
                comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.modifiers").withStyle(ChatFormatting.RED));
                tooltips.add((Component)comp);
                for (WaveModifier waveModifier : endlessModifier.modifiers()) {
                    waveModifier.appendHoverText(ctx, c -> tooltips.add((Component)AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.dot", (Object[])new Object[]{c.withStyle(ChatFormatting.RED)}).withStyle(ChatFormatting.RED))));
                }
            }
            if (!endlessModifier.rewards().isEmpty()) {
                comp = AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.rewards").withStyle(ChatFormatting.GOLD));
                tooltips.add((Component)comp);
                for (Reward reward : endlessModifier.rewards()) {
                    reward.appendHoverText(ctx, c -> tooltips.add((Component)AttributeHelper.list().append((Component)Component.translatable((String)"tooltip.gateways.dot", (Object[])new Object[]{c}).withStyle(ChatFormatting.GOLD))));
                }
            }
        } else {
            comp = Component.translatable((String)("tooltip.gateways.endless.num_modif" + (gate.modifiers().size() == 1 ? "" : "s")), (Object[])new Object[]{gate.modifiers().size()}).withStyle(ChatFormatting.LIGHT_PURPLE);
            comp.append(CommonComponents.SPACE);
            comp.append((Component)Component.translatable((String)"tooltip.gateways.shift").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY)));
            tooltips.add((Component)comp);
        }
        if (!(failures = gate.failures()).isEmpty()) {
            if (Screen.hasControlDown()) {
                comp = Component.translatable((String)"tooltip.gateways.failures").withStyle(Style.EMPTY.withColor(ChatFormatting.RED));
                tooltips.add((Component)comp);
                for (Failure f : failures) {
                    f.appendHoverText(ctx, c -> tooltips.add((Component)AttributeHelper.list().append((Component)c.withStyle(Style.EMPTY.withColor(ChatFormatting.RED)))));
                }
            } else {
                comp = Component.translatable((String)("tooltip.gateways.num_failure" + (failures.size() == 1 ? "" : "s")), (Object[])new Object[]{failures.size()}).withStyle(Style.EMPTY.withColor(ChatFormatting.RED));
                comp.append(CommonComponents.SPACE);
                comp.append((Component)Component.translatable((String)"tooltip.gateways.ctrl").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY)));
                tooltips.add((Component)comp);
            }
        }
        if (!(list = gate.rules().buildDeviations()).isEmpty()) {
            if (Screen.hasAltDown()) {
                comp = Component.translatable((String)"tooltip.gateways.rules", (Object[])new Object[]{list.size()}).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN));
                tooltips.add((Component)comp);
                list.forEach(c -> tooltips.add((Component)AttributeHelper.list().append((Component)c.withStyle(ChatFormatting.DARK_GREEN))));
            } else {
                comp = Component.translatable((String)("tooltip.gateways.num_rule" + (list.size() == 1 ? "" : "s")), (Object[])new Object[]{list.size()}).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN));
                comp.append(CommonComponents.SPACE);
                comp.append((Component)Component.translatable((String)"tooltip.gateways.alt").withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY)));
                tooltips.add((Component)comp);
            }
        }
    }

    public static void renderBossBar(GatewayEntity gateEntity, Object guiGfx, int x, int y, boolean isInWorld) {
        EndlessGatewayEntity gate = (EndlessGatewayEntity)gateEntity;
        GuiGraphics gfx = (GuiGraphics)guiGfx;
        PoseStack pose = gfx.pose();
        int color = gate.getGateway().color().getValue();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
        int wave = gate.getWave() + 1;
        int enemies = gate.getActiveEnemies();
        int maxEnemies = gate.getMaxEnemies();
        int modifiers = gate.getModifiersApplied();
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineHeight = 9;
        int yBar1 = y + 6 + lineHeight;
        int yBar2 = yBar1 + 10 + lineHeight;
        int textY = y - lineHeight;
        pose.pushPose();
        pose.translate(0.0, 0.0, 0.01);
        gfx.blitSprite(GatewaysClient.WHITE_BACKGROUND, x, yBar1, 182, 5);
        gfx.blitSprite(GatewaysClient.WHITE_BACKGROUND, x, yBar2, 182, 5);
        pose.popPose();
        int barWidth = 183;
        float maxTime = gate.getMaxWaveTime();
        if (gate.isWaveActive()) {
            barWidth = (int)(183.0f * (float)enemies / (float)maxEnemies);
            if (barWidth > 0) {
                gfx.blitSprite(GatewaysClient.WHITE_PROGRESS, 182, 5, 0, 0, x, yBar1, barWidth, 5);
            }
            if ((barWidth = (int)((maxTime - (float)gate.getTicksActive()) / maxTime * 183.0f)) > 0) {
                gfx.blitSprite(GatewaysClient.WHITE_PROGRESS, 182, 5, 0, 0, x, yBar2, barWidth, 5);
            }
        } else {
            maxTime = gate.getSetupTime();
            barWidth = (int)((float)gate.getTicksActive() / maxTime * 183.0f);
            if (barWidth > 0) {
                gfx.blitSprite(GatewaysClient.WHITE_PROGRESS, 182, 5, 0, 0, x, yBar1, barWidth, 5);
                gfx.blitSprite(GatewaysClient.WHITE_PROGRESS, 182, 5, 0, 0, x, yBar2, barWidth, 5);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Font font = Minecraft.getInstance().font;
        MutableComponent component = Component.literal((String)gate.getCustomName().getString()).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE});
        int strWidth = font.width((FormattedText)component);
        int textX = x + 91 - strWidth / 2;
        if (isInWorld) {
            GatewaysClient.drawReversedDropShadow(gfx, font, (Component)component, textX, textY);
        } else {
            gfx.drawString(font, (Component)component, textX, textY, 0xFFFFFF, true);
        }
        int time = (int)maxTime - gate.getTicksActive();
        float tps = gateEntity.level().tickRateManager().tickrate();
        String str = I18n.get((String)"boss.gateways.endless.top", (Object[])new Object[]{wave, Character.valueOf('\u221e'), StringUtil.formatTickDuration((int)time, (float)tps)});
        String str2 = I18n.get((String)"boss.gateways.endless.bot", (Object[])new Object[]{enemies, maxEnemies, modifiers});
        if (!gate.isWaveActive()) {
            str = I18n.get((String)"boss.gateways.starting", (Object[])new Object[]{wave, StringUtil.formatTickDuration((int)time, (float)tps)});
            str2 = I18n.get((String)"boss.gateways.endless.incoming", (Object[])new Object[]{maxEnemies});
        }
        component = Component.literal((String)str).withStyle(ChatFormatting.GREEN);
        strWidth = font.width((FormattedText)component);
        textX = x + 91 - strWidth / 2;
        textY = yBar1 - lineHeight;
        if (isInWorld) {
            GatewaysClient.drawReversedDropShadow(gfx, font, (Component)component, textX, textY);
        } else {
            gfx.drawString(font, (Component)component, textX, textY, 0xFFFFFF, true);
        }
        component = Component.literal((String)str2).withStyle(ChatFormatting.GREEN);
        strWidth = font.width((FormattedText)component);
        textX = x + 91 - strWidth / 2;
        textY = yBar2 - lineHeight;
        if (isInWorld) {
            GatewaysClient.drawReversedDropShadow(gfx, font, (Component)component, textX, textY);
        } else {
            gfx.drawString(font, (Component)component, textX, textY, 0xFFFFFF, true);
        }
    }
}

