/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class BonusModifierCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_OP = (ctx, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(AttributeModifier.Operation.values()).map(Enum::name), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_SLOT = (ctx, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(EquipmentSlotGroup.values()).map(Enum::name).map(s -> s.toLowerCase(Locale.ROOT)), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_ATTRIB = (ctx, builder) -> SharedSuggestionProvider.suggest(BuiltInRegistries.ATTRIBUTE.keySet().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"add_bonus_modifier").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"attribute", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_ATTRIB).then(Commands.argument((String)"op", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_OP).then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.argument((String)"slot", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_SLOT).executes(c -> {
            ServerPlayer p = ((CommandSourceStack)c.getSource()).getPlayerOrException();
            Holder attrib = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder((ResourceLocation)c.getArgument("attribute", ResourceLocation.class)).orElseThrow();
            AttributeModifier.Operation op = AttributeModifier.Operation.valueOf((String)((String)c.getArgument("op", String.class)).toUpperCase(Locale.ROOT));
            EquipmentSlotGroup slot = EquipmentSlotGroup.valueOf((String)((String)c.getArgument("slot", String.class)).toUpperCase(Locale.ROOT));
            float value = ((Float)c.getArgument("value", Float.class)).floatValue();
            ItemStack stack = p.getMainHandItem();
            ItemAttributeModifiers bonus = (ItemAttributeModifiers)stack.getOrDefault(ALObjects.Components.BONUS_ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
            AttributeModifier modif = new AttributeModifier(ApothicAttributes.loc("command_generated_" + p.level().random.nextInt()), (double)value, op);
            stack.set(ALObjects.Components.BONUS_ATTRIBUTE_MODIFIERS, (Object)bonus.withModifierAdded(attrib, modif, slot));
            return 0;
        }))))));
    }
}

