/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.mekanism_unleashed.mixin;

import dev.wp.mekanism_unleashed.Utils;
import mekanism.api.math.MathUtils;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.MekanismUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={MekanismUtils.class}, remap=false)
public class MixinMekanismUtils {
    @Overwrite
    public static int getTicks(IUpgradeTile tile, int def) {
        if (tile.supportsUpgrades()) {
            double d = (double)def * Utils.time(tile);
            return d >= 1.0 ? MathUtils.clampToInt((double)d) : MathUtils.clampToInt((double)(1.0 / d)) * -1;
        }
        return def;
    }

    @Overwrite
    public static long getEnergyPerTick(IUpgradeTile tile, long def) {
        if (tile.supportsUpgrades()) {
            return MathUtils.clampToLong((double)((double)def * Utils.electricity(tile)));
        }
        return def;
    }

    @Overwrite
    public static long getMaxEnergy(IUpgradeTile tile, long def) {
        if (tile.supportsUpgrades()) {
            return MathUtils.clampToLong((double)((double)def * Utils.capacity(tile)));
        }
        return def;
    }
}

