/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ArmorStandData {
    public boolean invisible = false;
    public boolean noBasePlate = false;
    public boolean noGravity = false;
    public boolean showArms = false;
    public boolean small = false;
    public boolean nameVisible = true;
    public boolean locked = true;
    public float rotation = 0.0f;
    public final float[] pose = new float[21];

    public boolean getBooleanValue(int index) {
        return switch (index) {
            case 0 -> this.invisible;
            case 1 -> this.noBasePlate;
            case 2 -> this.noGravity;
            case 3 -> this.showArms;
            case 4 -> this.small;
            case 5 -> this.nameVisible;
            case 6 -> this.locked;
            default -> false;
        };
    }

    public void readFromNBT(CompoundTag compound) {
        this.invisible = compound.getBoolean("Invisible");
        this.noBasePlate = compound.getBoolean("NoBasePlate");
        this.noGravity = compound.getBoolean("NoGravity");
        this.showArms = compound.getBoolean("ShowArms");
        this.small = compound.getBoolean("Small");
        this.nameVisible = compound.getBoolean("CustomNameVisible");
        this.locked = compound.getBoolean("Invulnerable");
        if (compound.contains("Rotation")) {
            this.rotation = compound.getList("Rotation", 5).getFloat(0);
        }
        if (compound.contains("Pose")) {
            CompoundTag poseTag = compound.getCompound("Pose");
            String[] keys = new String[]{"Head", "Body", "LeftLeg", "RightLeg", "LeftArm", "RightArm"};
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (poseTag == null || !poseTag.contains(key)) continue;
                ListTag tagList = poseTag.getList(key, 5);
                for (int j = 0; j <= 2; ++j) {
                    int k = i * 3 + j;
                    this.pose[k] = tagList.getFloat(j);
                }
            }
        }
    }

    public CompoundTag writeToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Invisible", this.invisible);
        compound.putBoolean("NoBasePlate", this.noBasePlate);
        compound.putBoolean("NoGravity", this.noGravity);
        compound.putBoolean("ShowArms", this.showArms);
        compound.putBoolean("Small", this.small);
        compound.putBoolean("CustomNameVisible", this.nameVisible);
        compound.putBoolean("Invulnerable", this.locked);
        compound.putInt("DisabledSlots", this.locked ? 0x3F3F3F : 0);
        ListTag rotationTag = new ListTag();
        rotationTag.add((Object)FloatTag.valueOf((float)this.rotation));
        compound.put("Rotation", (Tag)rotationTag);
        CompoundTag poseTag = new CompoundTag();
        ListTag poseHeadTag = new ListTag();
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.pose[0]));
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.pose[1]));
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.pose[2]));
        poseTag.put("Head", (Tag)poseHeadTag);
        ListTag poseBodyTag = new ListTag();
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.pose[3]));
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.pose[4]));
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.pose[5]));
        poseTag.put("Body", (Tag)poseBodyTag);
        ListTag poseLeftLegTag = new ListTag();
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.pose[6]));
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.pose[7]));
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.pose[8]));
        poseTag.put("LeftLeg", (Tag)poseLeftLegTag);
        ListTag poseRightLegTag = new ListTag();
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.pose[9]));
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.pose[10]));
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.pose[11]));
        poseTag.put("RightLeg", (Tag)poseRightLegTag);
        ListTag poseLeftArmTag = new ListTag();
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.pose[12]));
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.pose[13]));
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.pose[14]));
        poseTag.put("LeftArm", (Tag)poseLeftArmTag);
        ListTag poseRightArmTag = new ListTag();
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.pose[15]));
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.pose[16]));
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.pose[17]));
        poseTag.put("RightArm", (Tag)poseRightArmTag);
        compound.put("Pose", (Tag)poseTag);
        return compound;
    }
}

