/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.packets.handler;

import com.mrbysco.armorposer.client.gui.ArmorStandScreen;
import com.mrbysco.armorposer.packets.ArmorStandScreenPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleScreenData(ArmorStandScreenPayload screenMessage, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            Entity entity = null;
            if (mc.level != null) {
                entity = mc.level.getEntity(screenMessage.entityID());
            }
            if (entity instanceof ArmorStand) {
                ArmorStand armorStandEntity = (ArmorStand)entity;
                ArmorStandScreen.openScreen(armorStandEntity);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"armorposer.networking.screen.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

