/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.handlers;

import com.mrbysco.armorposer.config.PoserConfig;
import com.mrbysco.armorposer.packets.ArmorStandScreenPayload;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="armorposer", bus=EventBusSubscriber.Bus.GAME)
public class EventHandler {
    private static boolean cancelRightClick = false;

    @SubscribeEvent
    public static void onPlayerEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (entity instanceof ArmorStand) {
            ItemStack stack;
            ArmorStand armorstand = (ArmorStand)entity;
            Player player = event.getEntity();
            Level level = event.getLevel();
            if (((Boolean)PoserConfig.COMMON.enableConfigGui.get()).booleanValue() && player.isShiftKeyDown()) {
                if (event.getHand() == InteractionHand.MAIN_HAND && !level.isClientSide) {
                    ((ServerPlayer)player).connection.send((CustomPacketPayload)new ArmorStandScreenPayload(armorstand.getId()));
                }
                event.setCanceled(true);
                return;
            }
            if (((Boolean)PoserConfig.COMMON.enableNameTags.get()).booleanValue() && !player.isShiftKeyDown() && !(stack = player.getItemInHand(InteractionHand.MAIN_HAND)).isEmpty() && stack.getItem() == Items.NAME_TAG && stack.has(DataComponents.CUSTOM_NAME)) {
                cancelRightClick = true;
                if (event.getHand() == InteractionHand.MAIN_HAND && !level.isClientSide) {
                    armorstand.setCustomName(stack.getHoverName());
                    armorstand.setCustomNameVisible(true);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (cancelRightClick) {
            cancelRightClick = false;
            event.setCanceled(true);
        }
    }
}

