/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.data;

import com.mrbysco.armorposer.Reference;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;

public record SyncData(UUID entityUUID, CompoundTag tag) {
    public void encode(FriendlyByteBuf buf) {
        buf.writeUUID(this.entityUUID);
        buf.writeNbt((Tag)this.tag);
    }

    public static SyncData decode(FriendlyByteBuf packetBuffer) {
        return new SyncData(packetBuffer.readUUID(), packetBuffer.readNbt());
    }

    public void handleData(ArmorStand armorStand, Player player) {
        CompoundTag entityTag = armorStand.saveWithoutId(new CompoundTag());
        CompoundTag entityTagCopy = entityTag.copy();
        if (!this.tag.isEmpty()) {
            AttributeInstance attributeInstance;
            double scale;
            entityTagCopy.merge(this.tag);
            armorStand.load(entityTagCopy);
            armorStand.setUUID(this.entityUUID);
            ListTag tagList = this.tag.getList("Move", 6);
            double xOffset = tagList.getDouble(0);
            double yOffset = tagList.getDouble(1);
            double zOffset = tagList.getDouble(2);
            if (xOffset != 0.0 || yOffset != 0.0 || zOffset != 0.0) {
                armorStand.setPosRaw(armorStand.getX() + xOffset, armorStand.getY() + yOffset, armorStand.getZ() + zOffset);
            }
            if (Reference.canResize(player) && (scale = this.tag.getDouble("Scale")) > 0.0 && (attributeInstance = armorStand.getAttributes().getInstance(Attributes.SCALE)) != null) {
                attributeInstance.setBaseValue(scale);
            }
        }
    }
}

