/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import com.mrbysco.armorposer.client.gui.ArmorGlowScreen;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ArmorGlowWidget
extends ObjectSelectionList<ListEntry> {
    private static final Vector3f ARMOR_STAND_TRANSLATION = new Vector3f();
    private static final Quaternionf ARMOR_STAND_ANGLE = new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI);
    private final ArmorGlowScreen parent;
    private final int listWidth;
    private final Component title;

    public ArmorGlowWidget(ArmorGlowScreen parent, Component title, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getScreenMinecraft();
        Objects.requireNonNull(parent.getScreenFont());
        super(minecraft, listWidth, bottom - top, top, 9 * 2 + 16);
        this.parent = parent;
        this.title = title;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.listWidth - 6;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refreshList() {
        this.clearEntries();
        this.parent.buildPositionList(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), location -> new ListEntry((ArmorStand)location, this.parent));
    }

    protected void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        int xPos = this.getX() + (this.width - width) / 2;
        int xPos2 = this.getX() + (this.width + width) / 2;
        guiGraphics.fillGradient(xPos, top - 2, xPos2, top + height + 2, -1945083888, -1676648432);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fillGradient(this.getX(), 0, this.getX() + this.listWidth, this.parent.height, -1945104368, -1676668912);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.parent.getScreenFont(), this.title, this.getX() + this.listWidth / 2, 2, 0xFFFFFF);
    }

    public class ListEntry
    extends ObjectSelectionList.Entry<ListEntry> {
        private final ArmorGlowScreen parent;
        private final ArmorStand armorStand;

        ListEntry(ArmorStand armorStand, ArmorGlowScreen parent) {
            this.armorStand = armorStand;
            this.parent = parent;
        }

        public void render(GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Font font = this.parent.getScreenFont();
            AbstractWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)font, (Component)this.getPositionComponent(), (int)(left + 36), (int)(top + 10), (int)(left + ArmorGlowWidget.this.width - 18), (int)(top + 20), (int)0xFFFFFF);
            this.renderPose(guiGraphics, left + 16, top + 28, 15);
        }

        public ArmorStand getArmorStand() {
            return this.armorStand;
        }

        public void renderPose(GuiGraphics guiGraphics, int xPos, int yPos, int size) {
            if (this.armorStand != null) {
                InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)xPos, (float)yPos, (float)size, (Vector3f)ARMOR_STAND_TRANSLATION, (Quaternionf)ARMOR_STAND_ANGLE, (Quaternionf)null, (LivingEntity)this.armorStand);
            }
        }

        public void renderBack(GuiGraphics guiGraphics, int mouseX, int mouseY, int $$3, int $$4, int $$5, int $$6, int $$7, boolean $$8, float $$9) {
            super.renderBack(guiGraphics, mouseX, mouseY, $$3, $$4, $$5, $$6, $$7, $$8, $$9);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.parent.setSelected(this);
            ArmorGlowWidget.this.setSelected((AbstractSelectionList.Entry)this);
            return false;
        }

        public Component getPositionComponent() {
            return Component.literal((String)this.getArmorStand().blockPosition().toShortString());
        }

        public Component getNarration() {
            return this.getPositionComponent();
        }
    }
}

