/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.raytrace.BridgingStateTracker;
import me.cg360.mod.bridging.raytrace.PathTraversalHandler;
import me.cg360.mod.bridging.util.GameSupport;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class Render {
    public static void blocksInViewPath(PoseStack poseStack, VertexConsumer vertexConsumer, Camera camera) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        List<BlockPos> path = PathTraversalHandler.getViewBlockPath((Entity)player, camera);
        if (path.isEmpty()) {
            return;
        }
        for (BlockPos pos : path) {
            Render.cubeTrace(poseStack, vertexConsumer, camera, pos);
        }
    }

    public static void cubeHighlight(PoseStack poseStack, VertexConsumer vertices, Camera camera, BlockPos pos) {
        Render.cubeOutline(poseStack, vertices, camera, pos, 637573631);
    }

    public static void cubeTrace(PoseStack poseStack, VertexConsumer vertices, Camera camera, BlockPos pos) {
        Render.cubeOutline(poseStack, vertices, camera, pos, 0x16333333);
    }

    public static void cubeTermination(PoseStack poseStack, VertexConsumer vertices, Camera camera, BlockPos pos) {
        Render.cubeOutline(poseStack, vertices, camera, pos, 0x7FFF0000);
    }

    public static void cubeOutline(PoseStack poseStack, VertexConsumer consumer, Camera camera, BlockPos pos, int argbColor) {
        PoseStack.Pose pose = poseStack.last();
        Vec3 camPos = camera.getPosition();
        double x = (double)pos.getX() - camPos.x();
        double y = (double)pos.getY() - camPos.y();
        double z = (double)pos.getZ() - camPos.z();
        Shapes.block().forAllEdges((startX, startY, startZ, endX, endY, endZ) -> {
            float dx = (float)(endX - startX);
            float dy = (float)(endY - startY);
            float dz = (float)(endZ - startZ);
            float length = Mth.sqrt((float)(dx * dx + dy * dy + dz * dz));
            consumer.addVertex(pose.pose(), (float)(startX + x), (float)(startY + y), (float)(startZ + z)).setColor(argbColor).setNormal(pose, dx /= length, dy /= length, dz /= length);
            consumer.addVertex(pose.pose(), (float)(endX + x), (float)(endY + y), (float)(endZ + z)).setColor(argbColor).setNormal(pose, dx, dy, dz);
        });
    }

    public static void currentNonBridgingOutline(PoseStack poseStack, Camera camera, VertexConsumer vertices) {
        HitResult hit = Minecraft.getInstance().hitResult;
        if (hit == null || hit.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hit;
        BlockPos hitBlock = blockHitResult.getBlockPos();
        Direction hitSide = blockHitResult.getDirection();
        BlockPos placeTarget = hitBlock.relative(hitSide);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!GameSupport.isHoldingPlaceable((Player)player)) {
            return;
        }
        AABB placeDeadzone = new AABB(placeTarget);
        if (player.getBoundingBox().intersects(placeDeadzone)) {
            return;
        }
        int outlineColour = BridgingMod.getConfig().getOutlineColour().getRGB();
        Render.cubeOutline(poseStack, vertices, camera, placeTarget, outlineColour);
    }

    public static void currentBridgingOutline(PoseStack poseStack, Camera camera, VertexConsumer vertices) {
        Tuple<BlockPos, Direction> lastTarget = BridgingStateTracker.getLastTickTarget();
        if (lastTarget == null) {
            return;
        }
        int outlineColour = BridgingMod.getConfig().getOutlineColour().getRGB();
        Render.cubeOutline(poseStack, vertices, camera, (BlockPos)lastTarget.getA(), outlineColour);
    }
}

