/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.mixin;

import me.cg360.mod.bridging.BridgingKeyMappings;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.raytrace.BridgingStateTracker;
import me.cg360.mod.bridging.util.InfoStrings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Unique
    private double bridgingmod$lastKnownYFrac = 0.0;
    @Shadow
    @Nullable
    public MultiPlayerGameMode gameMode;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Nullable
    public HitResult hitResult;
    @Shadow
    private int rightClickDelay;
    @Shadow
    @Nullable
    public ClientLevel level;

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void onTick(CallbackInfo ci) {
        if (this.player != null && this.player.onGround()) {
            this.bridgingmod$lastKnownYFrac = Mth.frac((double)this.player.getY());
        }
        if (BridgingKeyMappings.TOGGLE_BRIDGING.consumeClick()) {
            BridgingMod.getConfig().toggleBridgingEnabled();
            Component stateMsg = BridgingMod.getConfig().isBridgingEnabled() ? InfoStrings.ON : InfoStrings.OFF;
            MutableComponent text = InfoStrings.TOGGLE_BRIDGING.copy().append(stateMsg);
            Minecraft.getInstance().gui.setOverlayMessage((Component)text, false);
        }
        BridgingStateTracker.tick(this.player);
    }

    @Inject(at={@At(value="HEAD")}, method={"startUseItem()V"}, cancellable=true)
    public void onItemUse(CallbackInfo info) {
        boolean passesCrouchTest;
        if (!BridgingMod.getConfig().isBridgingEnabled()) {
            return;
        }
        if (this.player == null) {
            return;
        }
        if (this.gameMode == null) {
            return;
        }
        if (this.player.isHandsBusy() || this.gameMode.isDestroying()) {
            return;
        }
        if (this.hitResult != null && this.hitResult.getType() != HitResult.Type.MISS) {
            return;
        }
        boolean bl = passesCrouchTest = !BridgingMod.getConfig().shouldOnlyBridgeWhenCrouched() || this.player.isCrouching();
        if (!passesCrouchTest) {
            return;
        }
        Tuple<BlockPos, Direction> pair = BridgingStateTracker.getLastTickTarget();
        if (pair == null) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            boolean stackSizeChanged;
            Direction dir;
            ItemStack itemStack = this.player.getItemInHand(hand);
            BlockPos pos = (BlockPos)pair.getA();
            if (!this.player.mayUseItemAt(pos, dir = ((Direction)pair.getB()).getOpposite(), itemStack)) continue;
            BlockHitResult blockHitResult = this.bridgingmod$getFinalPlaceAssistTarget(itemStack, dir, pos);
            int originalStackSize = itemStack.getCount();
            InteractionResult blockPlaceResult = this.gameMode.useItemOn(this.player, hand, blockHitResult);
            if (!blockPlaceResult.consumesAction()) continue;
            this.rightClickDelay = Math.max(0, BridgingMod.getConfig().getDelayPostBridging());
            info.cancel();
            if (!blockPlaceResult.shouldSwing()) {
                return;
            }
            this.player.swing(hand);
            boolean bl2 = stackSizeChanged = itemStack.getCount() != originalStackSize || this.gameMode.hasInfiniteItems();
            if (stackSizeChanged && !itemStack.isEmpty()) {
                Minecraft.getInstance().gameRenderer.itemInHandRenderer.itemUsed(hand);
            }
            return;
        }
    }

    @Unique
    @NotNull
    private BlockHitResult bridgingmod$getFinalPlaceAssistTarget(ItemStack heldItem, Direction dir, BlockPos pos) {
        if (BridgingMod.getConfig().isSlabAssistEnabled()) {
            BlockHitResult override;
            switch (dir.getAxis()) {
                default: {
                    throw new MatchException(null, null);
                }
                case X: 
                case Z: {
                    BlockHitResult blockHitResult = this.bridgingmod$handleHorizontalSlabAssist(dir, pos);
                    break;
                }
                case Y: {
                    BlockHitResult blockHitResult = override = this.bridgingmod$handleVerticalSlabAssist(heldItem, dir, pos);
                }
            }
            if (override != null) {
                return override;
            }
        }
        Vec3 placerOrigin = Vec3.atCenterOf((Vec3i)pos);
        return new BlockHitResult(placerOrigin, dir, pos, true);
    }

    @Unique
    private BlockHitResult bridgingmod$handleHorizontalSlabAssist(Direction dir, BlockPos pos) {
        boolean shouldTargetLowerHalf = this.bridgingmod$lastKnownYFrac > 0.1775 && this.bridgingmod$lastKnownYFrac < 0.51;
        Vec3 placerOrigin = shouldTargetLowerHalf ? Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, 0.1, 0.0) : Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, 0.9, 0.0);
        Direction placeDir = shouldTargetLowerHalf ? Direction.UP : Direction.DOWN;
        return new BlockHitResult(placerOrigin, placeDir, pos, false);
    }

    @Unique
    private BlockHitResult bridgingmod$handleVerticalSlabAssist(ItemStack heldItem, Direction dir, BlockPos pos) {
        if (this.level == null) {
            return null;
        }
        Item item = heldItem.getItem();
        if (!(item instanceof BlockItem)) {
            return null;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!(blockItem.getBlock() instanceof SlabBlock)) {
            return null;
        }
        BlockPos buildingOffPos = pos.offset(dir.getNormal().multiply(-1));
        BlockState localState = this.level.getBlockState(buildingOffPos);
        if (!(localState.getBlock() instanceof SlabBlock)) {
            return null;
        }
        SlabType slabType = (SlabType)localState.getValue((Property)SlabBlock.TYPE);
        if (slabType == SlabType.DOUBLE) {
            return null;
        }
        if (slabType == SlabType.TOP && dir != Direction.DOWN) {
            return null;
        }
        if (slabType == SlabType.BOTTOM && dir != Direction.UP) {
            return null;
        }
        Vec3 placerOrigin = Vec3.atCenterOf((Vec3i)pos);
        return new BlockHitResult(placerOrigin, dir, buildingOffPos, false);
    }
}

