/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.datagen;

import com.direwolf20.justdirethings.setup.Registration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class JustDireItemModels
extends ItemModelProvider {
    public JustDireItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "justdirethings", existingFileHelper);
    }

    protected void registerModels() {
        this.withExistingParent(Registration.GooSoil_Tier1.getId().getPath(), this.modLoc("block/goosoil_tier1"));
        this.withExistingParent(Registration.GooSoil_Tier2.getId().getPath(), this.modLoc("block/goosoil_tier2"));
        this.withExistingParent(Registration.GooSoil_Tier3.getId().getPath(), this.modLoc("block/goosoil_tier3"));
        this.withExistingParent(Registration.GooSoil_Tier4.getId().getPath(), this.modLoc("block/goosoil_tier4"));
        this.withExistingParent(Registration.GooBlock_Tier1_ITEM.getId().getPath(), this.modLoc("block/gooblock_tier1_dead"));
        this.withExistingParent(Registration.GooBlock_Tier2_ITEM.getId().getPath(), this.modLoc("block/gooblock_tier2_dead"));
        this.withExistingParent(Registration.GooBlock_Tier3_ITEM.getId().getPath(), this.modLoc("block/gooblock_tier3_dead"));
        this.withExistingParent(Registration.GooBlock_Tier4_ITEM.getId().getPath(), this.modLoc("block/gooblock_tier4_dead"));
        this.withExistingParent(Registration.FerricoreBlock_ITEM.getId().getPath(), this.modLoc("block/ferricore_block"));
        this.withExistingParent(Registration.RawFerricoreOre_ITEM.getId().getPath(), this.modLoc("block/raw_ferricore_ore"));
        this.withExistingParent(Registration.BlazeGoldBlock_ITEM.getId().getPath(), this.modLoc("block/blazegold_block"));
        this.withExistingParent(Registration.RawBlazegoldOre_ITEM.getId().getPath(), this.modLoc("block/raw_blazegold_ore"));
        this.withExistingParent(Registration.CelestigemBlock_ITEM.getId().getPath(), this.modLoc("block/celestigem_block"));
        this.withExistingParent(Registration.RawCelestigemOre_ITEM.getId().getPath(), this.modLoc("block/raw_celestigem_ore"));
        this.withExistingParent(Registration.EclipseAlloyBlock_ITEM.getId().getPath(), this.modLoc("block/eclipsealloy_block"));
        this.withExistingParent(Registration.RawEclipseAlloyOre_ITEM.getId().getPath(), this.modLoc("block/raw_eclipsealloy_ore"));
        this.withExistingParent(Registration.ItemCollector_ITEM.getId().getPath(), this.modLoc("block/itemcollector"));
        this.withExistingParent(Registration.BlockBreakerT1_ITEM.getId().getPath(), this.modLoc("block/blockbreakert1"));
        this.withExistingParent(Registration.BlockPlacerT1_ITEM.getId().getPath(), this.modLoc("block/blockplacert1"));
        this.withExistingParent(Registration.BlockBreakerT2_ITEM.getId().getPath(), this.modLoc("block/blockbreakert2"));
        this.withExistingParent(Registration.BlockPlacerT2_ITEM.getId().getPath(), this.modLoc("block/blockplacert2"));
        this.withExistingParent(Registration.ClickerT1_ITEM.getId().getPath(), this.modLoc("block/clickert1"));
        this.withExistingParent(Registration.ClickerT2_ITEM.getId().getPath(), this.modLoc("block/clickert2"));
        this.withExistingParent(Registration.SensorT1_ITEM.getId().getPath(), this.modLoc("block/sensort1"));
        this.withExistingParent(Registration.SensorT2_ITEM.getId().getPath(), this.modLoc("block/sensort2"));
        this.withExistingParent(Registration.DropperT1_ITEM.getId().getPath(), this.modLoc("block/droppert1"));
        this.withExistingParent(Registration.DropperT2_ITEM.getId().getPath(), this.modLoc("block/droppert2"));
        this.withExistingParent(Registration.GeneratorT1_ITEM.getId().getPath(), this.modLoc("block/generatort1"));
        this.withExistingParent(Registration.GeneratorFluidT1_ITEM.getId().getPath(), this.modLoc("block/generatorfluidt1"));
        this.withExistingParent(Registration.EnergyTransmitter_ITEM.getId().getPath(), this.modLoc("block/energytransmitter"));
        this.withExistingParent(Registration.CharcoalBlock_ITEM.getId().getPath(), this.modLoc("block/charcoal"));
        this.withExistingParent(Registration.RawCoal_T1_ITEM.getId().getPath(), this.modLoc("block/raw_coal_t1_ore"));
        this.withExistingParent(Registration.RawCoal_T2_ITEM.getId().getPath(), this.modLoc("block/raw_coal_t2_ore"));
        this.withExistingParent(Registration.RawCoal_T3_ITEM.getId().getPath(), this.modLoc("block/raw_coal_t3_ore"));
        this.withExistingParent(Registration.RawCoal_T4_ITEM.getId().getPath(), this.modLoc("block/raw_coal_t4_ore"));
        this.withExistingParent(Registration.CoalBlock_T1_ITEM.getId().getPath(), this.modLoc("block/coalblock_t1"));
        this.withExistingParent(Registration.CoalBlock_T2_ITEM.getId().getPath(), this.modLoc("block/coalblock_t2"));
        this.withExistingParent(Registration.CoalBlock_T3_ITEM.getId().getPath(), this.modLoc("block/coalblock_t3"));
        this.withExistingParent(Registration.CoalBlock_T4_ITEM.getId().getPath(), this.modLoc("block/coalblock_t4"));
        this.withExistingParent(Registration.BlockSwapperT1_ITEM.getId().getPath(), this.modLoc("block/blockswappert1"));
        this.withExistingParent(Registration.BlockSwapperT2_ITEM.getId().getPath(), this.modLoc("block/blockswappert2"));
        this.withExistingParent(Registration.PlayerAccessor.getId().getPath(), this.modLoc("block/playeraccessor"));
        this.withExistingParent(Registration.FluidPlacerT1_ITEM.getId().getPath(), this.modLoc("block/fluidplacert1"));
        this.withExistingParent(Registration.FluidPlacerT2_ITEM.getId().getPath(), this.modLoc("block/fluidplacert2"));
        this.withExistingParent(Registration.FluidCollectorT1_ITEM.getId().getPath(), this.modLoc("block/fluidcollectort1"));
        this.withExistingParent(Registration.FluidCollectorT2_ITEM.getId().getPath(), this.modLoc("block/fluidcollectort2"));
        this.withExistingParent(Registration.TimeCrystalBlock.getId().getPath(), this.modLoc("block/time_crystal_block"));
        this.withExistingParent(Registration.TimeCrystalBuddingBlock.getId().getPath(), this.modLoc("block/time_crystal_budding_block_state_0"));
        this.withExistingParent(Registration.TimeCrystalCluster.getId().getPath(), this.modLoc("block/time_crystal_cluster"));
        this.withExistingParent(Registration.ParadoxMachine.getId().getPath(), this.modLoc("block/paradoxmachine"));
        this.withExistingParent(Registration.InventoryHolder.getId().getPath(), this.modLoc("block/inventory_holder"));
        this.withExistingParent(Registration.ExperienceHolder_ITEM.getId().getPath(), this.modLoc("block/experienceholder"));
        this.singleTexture(Registration.Fuel_Canister.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/fuel_canister"));
        this.singleTexture(Registration.RawFerricore.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/raw_ferricore"));
        this.singleTexture(Registration.FerricoreIngot.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/ferricore_ingot"));
        this.singleTexture(Registration.RawBlazegold.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/raw_blazegold"));
        this.singleTexture(Registration.BlazegoldIngot.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/blazegold_ingot"));
        this.singleTexture(Registration.Celestigem.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/celestigem"));
        this.singleTexture(Registration.RawBlazegold.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/raw_blazegold"));
        this.singleTexture(Registration.BlazegoldIngot.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/blazegold_ingot"));
        this.singleTexture(Registration.RawEclipseAlloy.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/raw_eclipsealloy"));
        this.singleTexture(Registration.EclipseAlloyIngot.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/eclipsealloy_ingot"));
        this.singleTexture(Registration.Coal_T1.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/coal_t1"));
        this.singleTexture(Registration.Coal_T2.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/coal_t2"));
        this.singleTexture(Registration.Coal_T3.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/coal_t3"));
        this.singleTexture(Registration.Coal_T4.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/coal_t4"));
        this.singleTexture(Registration.PolymorphicCatalyst.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/polymorphic_catalyst"));
        this.singleTexture(Registration.PortalFluidCatalyst.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/portal_fluid_catalyst"));
        this.singleTexture(Registration.TimeCrystal.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/time_crystal_shard"));
        this.singleTexture(Registration.FerricoreWrench.getId().getPath(), this.mcLoc("item/handheld"), "layer0", this.modLoc("item/ferricore_wrench"));
        this.singleTexture(Registration.TotemOfDeathRecall.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/totem_of_death_recall"));
        this.singleTexture(Registration.BlazejetWand.getId().getPath(), this.mcLoc("item/handheld"), "layer0", this.modLoc("item/blazejet_wand"));
        this.singleTexture(Registration.VoidshiftWand.getId().getPath(), this.mcLoc("item/handheld"), "layer0", this.modLoc("item/voidshift_wand"));
        this.singleTexture(Registration.EclipsegateWand.getId().getPath(), this.mcLoc("item/handheld"), "layer0", this.modLoc("item/eclipsegate_wand"));
        ((ItemModelBuilder)this.getBuilder(Registration.CreatureCatcher.getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
        this.singleTexture(Registration.MachineSettingsCopier.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/machine_settings_copier"));
        this.singleTexture(Registration.TEMPLATE_FERRICORE.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/template_ferricore"));
        this.singleTexture(Registration.TEMPLATE_BLAZEGOLD.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/template_blazegold"));
        this.singleTexture(Registration.TEMPLATE_CELESTIGEM.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/template_celestigem"));
        this.singleTexture(Registration.TEMPLATE_ECLIPSEALLOY.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/template_eclipsealloy"));
        this.singleTexture(Registration.TimeWand.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/time_wand"));
        this.registerBowModels();
        this.registerTools();
        this.registerArmors();
        this.buckets();
        this.registerUpgrades();
        this.registerEnabledTextureItem(Registration.Pocket_Generator.getId().getPath());
    }

    public void buckets() {
        for (DeferredHolder bucket : Registration.BUCKET_ITEMS.getEntries()) {
            ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.withExistingParent(bucket.getId().getPath(), ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"item/bucket"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(((BucketItem)bucket.get()).content);
        }
    }

    public void registerTools() {
        for (DeferredHolder tool : Registration.TOOLS.getEntries()) {
            this.registerEnabledTextureItem(tool.getId().getPath());
        }
    }

    public void registerUpgrades() {
        for (DeferredHolder upgrade : Registration.UPGRADES.getEntries()) {
            String name = upgrade.getId().getPath().substring(upgrade.getId().getPath().indexOf("_") + 1);
            this.singleTexture(upgrade.getId().getPath(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/abilityupgrades/" + name));
        }
    }

    public void registerArmors() {
        for (DeferredHolder armor : Registration.ARMORS.getEntries()) {
            this.armorWithTrim((ArmorItem)((Item)armor.get()).asItem(), this.modLoc("item/" + armor.getId().getPath()));
        }
    }

    protected ItemModelBuilder generated(ItemLike itemLike, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem()).getPath(), "item/generated")).texture("layer0", texture);
    }

    protected ItemModelBuilder armorWithTrim(ArmorItem armorItem, ResourceLocation texture) {
        ItemModelBuilder builder = this.generated((ItemLike)armorItem, texture);
        for (ItemModelGenerators.TrimModelData trimModelData : ItemModelGenerators.GENERATED_TRIM_MODELS) {
            String trimId = trimModelData.name(armorItem.getMaterial());
            ItemModelBuilder override = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(builder.getLocation().withSuffix("_" + trimId + "_trim").getPath(), "item/generated")).texture("layer0", texture)).texture("layer1", ResourceLocation.withDefaultNamespace((String)("trims/items/" + armorItem.getType().getName() + "_trim_" + trimId)));
            builder.override().predicate(ItemModelGenerators.TRIM_TYPE_PREDICATE_ID, trimModelData.itemModelIndex()).model((ModelFile)override);
        }
        return builder;
    }

    public void registerEnabledTextureItem(String path) {
        ResourceLocation enabledModelPath = this.modLoc("item/" + path + "_active");
        ResourceLocation defaultModelPath = this.modLoc("item/" + path);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/handheld")))).texture("layer0", defaultModelPath)).override().predicate(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"enabled"), 1.0f).model((ModelFile)this.singleTexture(path + "_active", this.mcLoc("item/handheld"), "layer0", enabledModelPath)).end();
    }

    private ItemModelBuilder forBows(ItemModelBuilder builder) {
        return (ItemModelBuilder)builder.transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(-80.0f, 260.0f, -40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f, 0.9f, 0.9f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(-80.0f, -280.0f, 40.0f).translation(-1.0f, -2.0f, 2.5f).scale(0.9f, 0.9f, 0.9f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f, 0.68f, 0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f, 0.68f, 0.68f).end().end();
    }

    private void registerBowModels() {
        for (DeferredHolder bow : Registration.BOWS.getEntries()) {
            String bowName = bow.getId().getPath();
            this.forBows((ItemModelBuilder)this.singleTexture(bowName, this.mcLoc("item/generated"), "layer0", this.modLoc("item/bows/" + bowName)));
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(bowName + "_pulling_0")).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("item/bows/" + bowName + "_pulling_0"));
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(bowName + "_pulling_1")).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("item/bows/" + bowName + "_pulling_1"));
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(bowName + "_pulling_2")).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("item/bows/" + bowName + "_pulling_2"));
            ((ItemModelBuilder)this.getBuilder(bowName)).override().predicate(this.modLoc("pulling"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + bowName + "_pulling_0"))).end().override().predicate(this.modLoc("pulling"), 1.0f).predicate(this.modLoc("pull"), 0.45f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + bowName + "_pulling_1"))).end().override().predicate(this.modLoc("pulling"), 1.0f).predicate(this.modLoc("pull"), 0.9f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + bowName + "_pulling_2"))).end();
        }
    }
}

