/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.client.particles.itemparticle.ItemFlowParticleData;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.datagen.JustDireItemTags;
import com.direwolf20.justdirethings.setup.Registration;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class Helpers {
    public static final Predicate<BlockState> oreCondition = s -> s.is(Tags.Blocks.ORES) || s.is(Tags.Blocks.CLUSTERS);
    public static final Predicate<BlockState> fallingBlockCondition = s -> s.getBlock() instanceof FallingBlock;
    public static final Predicate<BlockState> logCondition = s -> s.is(BlockTags.LOGS);

    public static void breakBlocksNew(Level level, BlockPos pos, LivingEntity pPlayer, ItemStack pStack, boolean damageTool, boolean instaBreak) {
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pPlayer;
            if (level instanceof ServerLevel) {
                BlockState state;
                ServerLevel serverLevel = (ServerLevel)level;
                GameType type = player.getAbilities().instabuild ? GameType.CREATIVE : GameType.SURVIVAL;
                BlockEvent.BreakEvent exp = CommonHooks.fireBlockBreak((Level)serverLevel, (GameType)type, (ServerPlayer)player, (BlockPos)pos, (BlockState)(state = level.getBlockState(pos)));
                if (exp.isCanceled()) {
                    return;
                }
                BlockEntity blockEntity = level.getBlockEntity(pos);
                Block block = state.getBlock();
                if (block instanceof GameMasterBlock && !player.canUseGameMasterBlocks()) {
                    level.sendBlockUpdated(pos, state, state, 3);
                    return;
                }
                if (player.blockActionRestricted(level, pos, type)) {
                    return;
                }
                float destroySpeed = state.getDestroySpeed((BlockGetter)level, pos);
                BlockState removedBlockState = state.getBlock().playerWillDestroy(level, pos, state, (Player)player);
                if (player.getAbilities().instabuild) {
                    Helpers.removeBlock(serverLevel, player, pos, removedBlockState, false);
                    return;
                }
                ItemStack toolCopy = pStack.copy();
                boolean canHarvest = removedBlockState.canHarvestBlock((BlockGetter)level, pos, (Player)player);
                boolean removed = Helpers.removeBlock(serverLevel, player, pos, removedBlockState, canHarvest);
                if (canHarvest && removed) {
                    block.playerDestroy(level, (Player)player, pos, removedBlockState, blockEntity, pStack);
                }
                if (damageTool && destroySpeed != 0.0f) {
                    Helpers.damageTool(pStack, pPlayer);
                    if (instaBreak) {
                        Helpers.damageTool(pStack, pPlayer, ToggleableTool.getInstantRFCost(destroySpeed, level, pStack));
                    }
                }
            }
        }
    }

    public static boolean removeBlock(ServerLevel level, ServerPlayer player, BlockPos pos, BlockState state, boolean canHarvest) {
        boolean removed = state.onDestroyedByPlayer((Level)level, pos, (Player)player, canHarvest, level.getFluidState(pos));
        if (removed) {
            state.getBlock().destroy((LevelAccessor)level, pos, state);
        }
        return removed;
    }

    public static void damageTool(ItemStack stack, LivingEntity player) {
        Item item = stack.getItem();
        if (item instanceof PoweredTool) {
            PoweredTool poweredTool = (PoweredTool)item;
            stack.hurtAndBreak(poweredTool.getBlockBreakFECost(), player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        } else {
            ItemStack cloneStack = stack.copy();
            stack.hurtAndBreak(1, player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
            if (stack.isEmpty() && !cloneStack.isEmpty() && player instanceof Player) {
                Player player1 = (Player)player;
                EventHooks.onPlayerDestroyItem((Player)player1, (ItemStack)cloneStack, (InteractionHand)InteractionHand.MAIN_HAND);
            }
        }
    }

    public static void damageTool(ItemStack stack, LivingEntity player, int amount) {
        Item item = stack.getItem();
        if (item instanceof PoweredItem) {
            PoweredItem poweredTool = (PoweredItem)item;
            stack.hurtAndBreak(amount, player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        } else {
            ItemStack cloneStack = stack.copy();
            stack.hurtAndBreak(amount, player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
            if (stack.isEmpty() && !cloneStack.isEmpty() && player instanceof Player) {
                Player player1 = (Player)player;
                EventHooks.onPlayerDestroyItem((Player)player1, (ItemStack)cloneStack, (InteractionHand)InteractionHand.MAIN_HAND);
            }
        }
    }

    public static void damageTool(ItemStack stack, LivingEntity player, Ability ability) {
        if (stack.getItem() instanceof PoweredItem) {
            stack.hurtAndBreak(ability.getFeCost(), player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        } else {
            ItemStack cloneStack = stack.copy();
            stack.hurtAndBreak(ability.getDurabilityCost(), player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
            if (stack.isEmpty() && !cloneStack.isEmpty() && player instanceof Player) {
                Player player1 = (Player)player;
                EventHooks.onPlayerDestroyItem((Player)player1, (ItemStack)cloneStack, (InteractionHand)InteractionHand.MAIN_HAND);
            }
        }
    }

    public static void damageTool(ItemStack stack, LivingEntity player, Ability ability, int multiplier) {
        if (stack.getItem() instanceof PoweredItem) {
            stack.hurtAndBreak(ability.getFeCost() * multiplier, player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        } else {
            ItemStack cloneStack = stack.copy();
            stack.hurtAndBreak(ability.getDurabilityCost() * multiplier, player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
            if (stack.isEmpty() && !cloneStack.isEmpty() && player instanceof Player) {
                Player player1 = (Player)player;
                EventHooks.onPlayerDestroyItem((Player)player1, (ItemStack)cloneStack, (InteractionHand)InteractionHand.MAIN_HAND);
            }
        }
    }

    public static int testUseTool(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof PoweredTool) {
            PoweredTool poweredTool = (PoweredTool)item;
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return -1;
            }
            return energyStorage.getEnergyStored() - poweredTool.getBlockBreakFECost();
        }
        return stack.getMaxDamage() - stack.getDamageValue() - 1;
    }

    public static int testUseTool(ItemStack stack, int cost) {
        if (stack.getItem() instanceof PoweredItem) {
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return -1;
            }
            return energyStorage.getEnergyStored() - cost;
        }
        return stack.getMaxDamage() - stack.getDamageValue() - cost;
    }

    public static int testUseTool(ItemStack stack, Ability ability) {
        if (stack.getItem() instanceof PoweredItem) {
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return -1;
            }
            return energyStorage.getEnergyStored() - ability.getFeCost();
        }
        return stack.getMaxDamage() - stack.getDamageValue() - ability.getDurabilityCost();
    }

    public static int testUseTool(ItemStack stack, Ability ability, int multiplier) {
        if (stack.getItem() instanceof PoweredItem) {
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return -1;
            }
            return energyStorage.getEnergyStored() - ability.getFeCost() * multiplier;
        }
        return stack.getMaxDamage() - stack.getDamageValue() - ability.getDurabilityCost() * multiplier;
    }

    public static void combineDrops(List<ItemStack> drops, List<ItemStack> newDrops) {
        for (ItemStack newDrop : newDrops) {
            Optional<ItemStack> match = drops.stream().filter(drop -> ItemStack.isSameItemSameComponents((ItemStack)drop, (ItemStack)newDrop)).findFirst();
            if (match.isPresent()) {
                ItemStack existingDrop = match.get();
                int transferableAmount = Math.min(newDrop.getCount(), existingDrop.getMaxStackSize() - existingDrop.getCount());
                if (transferableAmount > 0) {
                    existingDrop.grow(transferableAmount);
                    newDrop.shrink(transferableAmount);
                }
                if (newDrop.isEmpty()) continue;
                drops.add(newDrop);
                continue;
            }
            drops.add(newDrop);
        }
    }

    public static ItemStack getSmeltedItem(Level level, ItemStack itemStack) {
        RegistryAccess registryAccess = level.registryAccess();
        RecipeManager recipeManager = level.getRecipeManager();
        ItemStack returnStack = ItemStack.EMPTY;
        Optional smeltingRecipe = recipeManager.getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(itemStack), level);
        if (smeltingRecipe.isPresent() && !itemStack.is(JustDireItemTags.AUTO_SMELT_DENY)) {
            returnStack = ((SmeltingRecipe)((RecipeHolder)smeltingRecipe.get()).value()).getResultItem((HolderLookup.Provider)registryAccess);
        }
        if (returnStack.isEmpty()) {
            return itemStack;
        }
        return returnStack;
    }

    public static List<ItemStack> smeltDrops(ServerLevel level, List<ItemStack> drops, ItemStack tool, LivingEntity entityLiving, boolean[] didISmelt) {
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        RegistryAccess registryAccess = level.registryAccess();
        RecipeManager recipeManager = level.getRecipeManager();
        didISmelt[0] = false;
        for (ItemStack drop : drops) {
            Optional smeltingRecipe = recipeManager.getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(drop), (Level)level);
            if (smeltingRecipe.isPresent() && !drop.is(JustDireItemTags.AUTO_SMELT_DENY)) {
                ItemStack smeltedResult = ((SmeltingRecipe)((RecipeHolder)smeltingRecipe.get()).value()).getResultItem((HolderLookup.Provider)registryAccess);
                if (!smeltedResult.isEmpty() && Helpers.testUseTool(tool, Ability.SMELTER, drop.getCount()) >= 0) {
                    ItemStack resultStack = smeltedResult.copy();
                    resultStack.setCount(drop.getCount());
                    if (!tool.isEmpty()) {
                        Helpers.damageTool(tool, entityLiving, Ability.SMELTER, drop.getCount());
                    }
                    returnList.add(resultStack);
                    didISmelt[0] = true;
                    continue;
                }
                returnList.add(drop);
                continue;
            }
            returnList.add(drop);
        }
        return returnList;
    }

    public static void smokeDrop(ServerLevel level, ItemEntity drop, ItemStack tool, LivingEntity entityLiving, boolean[] didISmoke) {
        ItemStack smokedResults;
        RegistryAccess registryAccess = level.registryAccess();
        RecipeManager recipeManager = level.getRecipeManager();
        didISmoke[0] = false;
        Optional smokingRecipe = recipeManager.getRecipeFor(RecipeType.SMOKING, (RecipeInput)new SingleRecipeInput(drop.getItem()), (Level)level);
        if (smokingRecipe.isPresent() && !drop.getItem().is(JustDireItemTags.AUTO_SMOKE_DENY) && !(smokedResults = ((SmokingRecipe)((RecipeHolder)smokingRecipe.get()).value()).getResultItem((HolderLookup.Provider)registryAccess)).isEmpty() && Helpers.testUseTool(tool, Ability.SMOKER, drop.getItem().getCount()) >= 0) {
            didISmoke[0] = true;
            smokedResults.setCount(drop.getItem().getCount());
            drop.setItem(smokedResults.copy());
            if (!tool.isEmpty()) {
                Helpers.damageTool(tool, entityLiving, Ability.SMOKER, drop.getItem().getCount());
            }
        }
    }

    public static void dropDrops(List<ItemStack> drops, ServerLevel level, BlockPos dropAtPos) {
        for (ItemStack drop : drops) {
            ItemEntity itemEntity = new ItemEntity((Level)level, (double)((float)dropAtPos.getX() + 0.5f), (double)((float)dropAtPos.getY() + 0.5f), (double)((float)dropAtPos.getZ() + 0.5f), drop);
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    public static ItemStack teleportDrop(ItemStack itemStack, IItemHandler handler) {
        ItemStack leftover = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)itemStack, (boolean)false);
        return leftover;
    }

    public static ItemStack teleportDrop(ItemStack itemStack, IItemHandler handler, ItemStack tool, Player player) {
        if (Helpers.testUseTool(tool, Ability.DROPTELEPORT) < 0) {
            return itemStack;
        }
        ItemStack leftover = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)itemStack, (boolean)false);
        if (leftover.isEmpty()) {
            Helpers.damageTool(tool, (LivingEntity)player, Ability.DROPTELEPORT);
        }
        return leftover;
    }

    public static void teleportDrops(List<ItemStack> drops, IItemHandler handler) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack drop : drops) {
            ItemStack leftover = Helpers.teleportDrop(drop, handler);
            if (leftover.isEmpty()) continue;
            leftovers.add(leftover);
        }
        drops.clear();
        drops.addAll(leftovers);
    }

    public static void teleportDrops(List<ItemStack> drops, IItemHandler handler, ItemStack tool, Player player) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack drop : drops) {
            ItemStack leftover = Helpers.teleportDrop(drop, handler, tool, player);
            if (leftover.isEmpty()) continue;
            leftovers.add(leftover);
        }
        drops.clear();
        drops.addAll(leftovers);
    }

    public static Set<BlockPos> findLikeBlocks(Level pLevel, BlockState pState, BlockPos pPos, int maxBreak, int range) {
        return Helpers.findBlocks(pLevel, pState, pPos, maxBreak, range);
    }

    private static Set<BlockPos> findBlocks(Level pLevel, BlockState pState, BlockPos pPos, int maxBreak, int radius) {
        HashSet<BlockPos> foundBlocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> blocksToCheck = new LinkedList<BlockPos>();
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
        foundBlocks.add(pPos);
        blocksToCheck.add(pPos);
        while (!blocksToCheck.isEmpty()) {
            BlockPos posToCheck = (BlockPos)blocksToCheck.poll();
            if (!checkedBlocks.add(posToCheck)) continue;
            Set matchingBlocks = BlockPos.betweenClosedStream((BlockPos)posToCheck.offset(-radius, -radius, -radius), (BlockPos)posToCheck.offset(radius, radius, radius)).filter(blockPos -> pLevel.getBlockState(blockPos).is(pState.getBlock())).map(BlockPos::immutable).collect(Collectors.toSet());
            for (BlockPos toAdd : matchingBlocks) {
                if (foundBlocks.size() < maxBreak) {
                    foundBlocks.add(toAdd);
                    if (checkedBlocks.contains(toAdd)) continue;
                    blocksToCheck.add(toAdd);
                    continue;
                }
                return foundBlocks;
            }
        }
        return foundBlocks;
    }

    public static Set<BlockPos> findBlocksSkyfall(Level pLevel, BlockPos pPos, int maxBreak, Direction direction, int range) {
        BlockPos posToCheck;
        BlockState blockState;
        HashSet<BlockPos> foundBlocks = new HashSet<BlockPos>();
        foundBlocks.add(pPos);
        for (int i = 1; i < range && fallingBlockCondition.test(blockState = pLevel.getBlockState(posToCheck = pPos.relative(direction, i))); ++i) {
            foundBlocks.add(posToCheck);
            if (foundBlocks.size() >= maxBreak) break;
        }
        return foundBlocks;
    }

    public static Set<BlockPos> findTaggedBlocks(Level pLevel, List<TagKey<Block>> tags, BlockPos pPos, int maxBreak, int radius) {
        HashSet<BlockPos> foundBlocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> blocksToCheck = new LinkedList<BlockPos>();
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
        blocksToCheck.add(pPos);
        while (!blocksToCheck.isEmpty()) {
            BlockPos posToCheck = (BlockPos)blocksToCheck.poll();
            if (!checkedBlocks.add(posToCheck)) continue;
            Set matchingBlocks = BlockPos.betweenClosedStream((BlockPos)posToCheck.offset(-radius, -radius, -radius), (BlockPos)posToCheck.offset(radius, radius, radius)).filter(blockPos -> tags.stream().anyMatch(arg_0 -> ((BlockState)pLevel.getBlockState(blockPos)).is(arg_0))).map(BlockPos::immutable).collect(Collectors.toSet());
            for (BlockPos toAdd : matchingBlocks) {
                if (foundBlocks.size() < maxBreak) {
                    foundBlocks.add(toAdd);
                    if (checkedBlocks.contains(toAdd)) continue;
                    blocksToCheck.add(toAdd);
                    continue;
                }
                return foundBlocks;
            }
        }
        return foundBlocks;
    }

    public static Set<BlockPos> findLikeBlocks(Level pLevel, BlockState pState, BlockPos pPos, int maxBreak, int radius, List<TagKey<Block>> extraTags) {
        HashSet<BlockPos> foundBlocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> blocksToCheck = new LinkedList<BlockPos>();
        LinkedList secondaryBlocksToCheck = new LinkedList();
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
        foundBlocks.add(pPos);
        blocksToCheck.add(pPos);
        while (!blocksToCheck.isEmpty() || !secondaryBlocksToCheck.isEmpty()) {
            BlockPos posToCheck;
            boolean isPrimaryPhase = !blocksToCheck.isEmpty();
            BlockPos blockPos2 = posToCheck = isPrimaryPhase ? (BlockPos)blocksToCheck.poll() : (BlockPos)secondaryBlocksToCheck.poll();
            if (!checkedBlocks.add(posToCheck)) continue;
            BlockPos.betweenClosedStream((BlockPos)posToCheck.offset(-radius, -radius, -radius), (BlockPos)posToCheck.offset(radius, radius, radius)).forEach(blockPos -> {
                if (foundBlocks.size() >= maxBreak) {
                    return;
                }
                BlockState foundState = pLevel.getBlockState(blockPos);
                boolean isPrimaryBlock = foundState.is(pState.getBlock());
                boolean isSecondaryBlock = extraTags.stream().anyMatch(arg_0 -> ((BlockState)foundState).is(arg_0));
                if (isPrimaryBlock || isSecondaryBlock) {
                    foundBlocks.add(blockPos.immutable());
                    if (!checkedBlocks.contains(blockPos.immutable())) {
                        if (isPrimaryBlock) {
                            blocksToCheck.add(blockPos.immutable());
                        } else {
                            secondaryBlocksToCheck.add(blockPos.immutable());
                        }
                    }
                }
            });
        }
        return foundBlocks;
    }

    public static boolean doLavaRepair(ItemStack stack, ItemEntity entity) {
        if (Helpers.isInLava(entity)) {
            stack.set(JustDireDataComponents.FLOATINGTICKS, (Object)0);
            stack.set(JustDireDataComponents.LAVAREPAIR_LAVAPOS, (Object)entity.blockPosition());
            entity.setPickUpDelay(85);
            entity.setOnGround(true);
        }
        if (!Helpers.validateLava(stack, entity)) {
            stack.remove(JustDireDataComponents.FLOATINGTICKS);
            stack.remove(JustDireDataComponents.LAVAREPAIR_LAVAPOS);
            entity.setOnGround(false);
        }
        if (stack.has(JustDireDataComponents.FLOATINGTICKS)) {
            if (entity.position().y - (double)Helpers.getLavaPos(stack).getY() < 3.0) {
                entity.setDeltaMovement(new Vec3(0.0, 0.05, 0.0));
            } else {
                entity.setDeltaMovement(new Vec3(0.0, 0.005, 0.0));
            }
            entity.move(MoverType.SELF, entity.getDeltaMovement());
            stack.update(JustDireDataComponents.FLOATINGTICKS, (Object)0, v -> v + 1);
            entity.setOnGround(true);
            if ((Integer)stack.getOrDefault(JustDireDataComponents.FLOATINGTICKS, (Object)0) >= 80) {
                Helpers.turnLavaIntoObsidian(stack, entity);
                Helpers.repairItem(stack);
                stack.remove(JustDireDataComponents.FLOATINGTICKS);
                stack.remove(JustDireDataComponents.LAVAREPAIR_LAVAPOS);
                entity.setOnGround(false);
            }
            if (!entity.level().isClientSide && (Integer)stack.getOrDefault(JustDireDataComponents.FLOATINGTICKS, (Object)0) < 40) {
                Helpers.doParticles(stack, entity);
            }
        }
        return false;
    }

    private static BlockPos getLavaPos(ItemStack stack) {
        return (BlockPos)stack.getOrDefault(JustDireDataComponents.LAVAREPAIR_LAVAPOS, (Object)BlockPos.ZERO);
    }

    private static void doParticles(ItemStack itemStack, ItemEntity entity) {
        Random random = new Random();
        BlockPos pos = Helpers.getLavaPos(itemStack);
        ItemFlowParticleData data = new ItemFlowParticleData(new ItemStack((ItemLike)Registration.GooBlock_Tier2.get()), entity.getX(), entity.getY() + 0.75, entity.getZ(), 3);
        for (int i = 0; i < 5; ++i) {
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() + 0.95;
            double d2 = (double)pos.getZ() + random.nextDouble();
            ((ServerLevel)entity.level()).sendParticles((ParticleOptions)data, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static boolean isInLava(ItemEntity entity) {
        BlockState blockState = entity.level().getBlockState(entity.blockPosition());
        return blockState.is(Blocks.LAVA) && (Integer)blockState.getValue((Property)BlockStateProperties.LEVEL) == 0;
    }

    private static void repairItem(ItemStack stack) {
        stack.setDamageValue(0);
    }

    private static boolean validateLava(ItemStack stack, ItemEntity entity) {
        BlockState blockState = entity.level().getBlockState(Helpers.getLavaPos(stack));
        return blockState.is(Blocks.LAVA) && (Integer)blockState.getValue((Property)BlockStateProperties.LEVEL) == 0;
    }

    private static void turnLavaIntoObsidian(ItemStack stack, ItemEntity entity) {
        BlockPos lavaPos = Helpers.getLavaPos(stack);
        entity.level().setBlock(lavaPos, Blocks.OBSIDIAN.defaultBlockState(), 3);
        entity.level().playSound(null, lavaPos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static Multimap<Attribute, AttributeModifier> addAttributeToModifiers(Multimap<Attribute, AttributeModifier> originalModifiers, Attribute attributeToAdd, AttributeModifier attributeModifier) {
        ArrayListMultimap modifiers = ArrayListMultimap.create(originalModifiers);
        modifiers.put((Object)attributeToAdd, (Object)attributeModifier);
        return modifiers;
    }
}

