/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public interface FluidContainingItem {
    default public int getMaxMB() {
        return 8000;
    }

    public static int getAvailableFluid(ItemStack stack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return -1;
        }
        return fluidHandler.getFluidInTank(0).getAmount();
    }

    default public boolean isFluidBarVisible(ItemStack stack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return false;
        }
        return fluidHandler.getFluidInTank(0).getAmount() < fluidHandler.getTankCapacity(0);
    }

    default public int getFluidBarWidth(ItemStack stack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return 13;
        }
        return Math.min(13 * fluidHandler.getFluidInTank(0).getAmount() / fluidHandler.getTankCapacity(0), 13);
    }

    default public int getFluidBarColor(ItemStack stack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return -1;
        }
        float hue = 0.55f;
        float saturation = 1.0f;
        return Mth.hsvToRgb((float)hue, (float)saturation, (float)1.0f);
    }

    public static boolean hasEnoughFluid(ItemStack itemStack, int amt) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return false;
        }
        return fluidHandler.getFluidInTank(0).getAmount() >= amt;
    }

    public static void consumeFluid(ItemStack itemStack, int amt) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler == null) {
            return;
        }
        fluidHandler.drain(amt, IFluidHandler.FluidAction.EXECUTE);
    }
}

