/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.events;

import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredTool;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.player.PlayerDestroyItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class PlayerEvents {
    public static final AttributeModifier stepHeight = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"justdirestepassist"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifier creativeFlight = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"justdireflight"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifier phase = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"justdirephase"), 1.0, AttributeModifier.Operation.ADD_VALUE);

    @SubscribeEvent
    public static void PlayerDestroyItem(PlayerDestroyItemEvent event) {
        ItemStack itemStack = event.getOriginal();
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            EnumSet<Ability> abilities = toggleableTool.getAbilities();
            for (Ability ability : abilities) {
                if (!ToggleableTool.hasUpgrade(itemStack, ability) || !ability.requiresUpgrade()) continue;
                ItemStack upgradeStack = new ItemStack(ability.getUpgradeItem());
                event.getEntity().drop(upgradeStack, true);
            }
        }
    }

    @SubscribeEvent
    public static void ItemAttributes(ItemAttributeModifierEvent event) {
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (toggleableTool.canUseAbility(itemStack, Ability.STEPHEIGHT)) {
                event.addModifier(Attributes.STEP_HEIGHT, stepHeight, EquipmentSlotGroup.FEET);
            }
            if (toggleableTool.canUseAbilityAndDurability(itemStack, Ability.FLIGHT)) {
                event.addModifier(NeoForgeMod.CREATIVE_FLIGHT, creativeFlight, EquipmentSlotGroup.CHEST);
            }
            if (toggleableTool.canUseAbility(itemStack, Ability.PHASE)) {
                event.addModifier(Registration.PHASE, phase, EquipmentSlotGroup.LEGS);
            }
        }
        if ((item = itemStack.getItem()) instanceof PoweredTool) {
            PoweredTool poweredTool = (PoweredTool)item;
            if (PoweredItem.getAvailableEnergy(itemStack) < poweredTool.getBlockBreakFECost()) {
                event.clearModifiers();
            }
        }
    }

    @SubscribeEvent
    public static void BreakSpeed(PlayerEvent.BreakSpeed event) {
        ToggleableTool toggleableTool;
        ItemStack chestPlate;
        Item item;
        Player player = event.getEntity();
        float targetSpeed = event.getOriginalSpeed();
        if (player.getAbilities().flying && (item = (chestPlate = player.getItemBySlot(EquipmentSlot.CHEST)).getItem()) instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(chestPlate, Ability.FLIGHT)) {
            targetSpeed *= 5.0f;
        }
        ItemStack stack = player.getMainHandItem();
        int rfCost = 0;
        Item item2 = stack.getItem();
        if (item2 instanceof ToggleableTool) {
            ToggleableTool toggleableTool2 = (ToggleableTool)item2;
            if (stack.isCorrectToolForDrops(event.getState())) {
                Item item3 = stack.getItem();
                if (item3 instanceof PoweredTool) {
                    PoweredTool poweredTool = (PoweredTool)item3;
                    if (PoweredItem.getAvailableEnergy(stack) < poweredTool.getBlockBreakFECost()) {
                        event.setNewSpeed(0.1f);
                        return;
                    }
                }
                Level level = player.level();
                BlockPos originalPos = (BlockPos)event.getPosition().get();
                BlockState originalState = level.getBlockState((BlockPos)event.getPosition().get());
                float originalDestroySpeed = originalState.getDestroySpeed((BlockGetter)level, originalPos);
                float cumulativeDestroy = 0.0f;
                if (originalDestroySpeed <= 0.0f) {
                    return;
                }
                Set<BlockPos> breakBlockPositions = toggleableTool2.getBreakBlockPositions(stack, level, originalPos, (LivingEntity)player, originalState);
                if (!breakBlockPositions.isEmpty()) {
                    int radius = toggleableTool2.canUseAbility(stack, Ability.HAMMER) ? ToggleableTool.getToolValue(stack, Ability.HAMMER.getName()) : 1;
                    for (BlockPos pos : breakBlockPositions) {
                        BlockState blockState = level.getBlockState(pos);
                        float destroySpeedTarget = blockState.getDestroySpeed((BlockGetter)level, pos);
                        cumulativeDestroy += destroySpeedTarget;
                    }
                    rfCost = ToggleableTool.getInstantRFCost(cumulativeDestroy, level, stack);
                    float modifier = (float)breakBlockPositions.size() / (float)radius < 1.0f ? 1.0f : (float)breakBlockPositions.size() / (float)radius;
                    cumulativeDestroy = cumulativeDestroy / (float)breakBlockPositions.size() * modifier;
                    float relative = originalDestroySpeed / cumulativeDestroy;
                    targetSpeed *= relative;
                }
                if (toggleableTool2.canUseAbility(stack, Ability.INSTABREAK) && stack.getItem() instanceof PoweredItem && PoweredItem.getAvailableEnergy(stack) >= rfCost) {
                    targetSpeed = 10000.0f;
                }
            }
        }
        if (targetSpeed != event.getOriginalSpeed()) {
            event.setNewSpeed(targetSpeed);
        }
    }
}

