/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.events;

import com.direwolf20.justdirethings.common.blocks.soil.GooSoilTier1;
import com.direwolf20.justdirethings.common.blocks.soil.GooSoilTier2;
import com.direwolf20.justdirethings.common.blocks.soil.GooSoilTier3;
import com.direwolf20.justdirethings.common.blocks.soil.GooSoilTier4;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityMethods;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableItem;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.common.items.tools.BlazegoldHoe;
import com.direwolf20.justdirethings.common.items.tools.CelestigemHoe;
import com.direwolf20.justdirethings.common.items.tools.EclipseAlloyHoe;
import com.direwolf20.justdirethings.common.items.tools.FerricoreHoe;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class BlockEvents {
    public static boolean alreadyBreaking = false;
    public static BlockPos spawnDropsAtPos = BlockPos.ZERO;

    @SubscribeEvent
    public static void BlockToolModificationEvent(BlockEvent.BlockToolModificationEvent event) {
        Item item;
        ItemStack heldItem = event.getHeldItemStack();
        if (event.getItemAbility().equals(ItemAbilities.HOE_TILL) && (item = heldItem.getItem()) instanceof ToggleableItem) {
            BlockState modifiedState;
            ToggleableItem toggleableItem = (ToggleableItem)item;
            if (heldItem.getItem() instanceof FerricoreHoe && toggleableItem.getEnabled(heldItem)) {
                modifiedState = event.getState().getBlock().getToolModifiedState(event.getState(), event.getContext(), event.getItemAbility(), true);
                if (modifiedState != null && modifiedState.is(Blocks.FARMLAND)) {
                    event.setFinalState(((GooSoilTier1)((Object)Registration.GooSoil_Tier1.get())).defaultBlockState());
                }
            } else if (heldItem.getItem() instanceof BlazegoldHoe && toggleableItem.getEnabled(heldItem)) {
                modifiedState = event.getState().getBlock().getToolModifiedState(event.getState(), event.getContext(), event.getItemAbility(), true);
                if (modifiedState != null && modifiedState.is(Blocks.FARMLAND)) {
                    event.setFinalState(((GooSoilTier2)((Object)Registration.GooSoil_Tier2.get())).defaultBlockState());
                }
            } else if (heldItem.getItem() instanceof CelestigemHoe && toggleableItem.getEnabled(heldItem)) {
                modifiedState = event.getState().getBlock().getToolModifiedState(event.getState(), event.getContext(), event.getItemAbility(), true);
                if (modifiedState != null && modifiedState.is(Blocks.FARMLAND)) {
                    event.setFinalState(((GooSoilTier3)((Object)Registration.GooSoil_Tier3.get())).defaultBlockState());
                }
            } else if (heldItem.getItem() instanceof EclipseAlloyHoe && toggleableItem.getEnabled(heldItem) && (modifiedState = event.getState().getBlock().getToolModifiedState(event.getState(), event.getContext(), event.getItemAbility(), true)) != null && modifiedState.is(Blocks.FARMLAND)) {
                event.setFinalState(((GooSoilTier4)((Object)Registration.GooSoil_Tier4.get())).defaultBlockState());
            }
        }
    }

    @SubscribeEvent
    public static void BlockBreakEvent(BlockEvent.BreakEvent event) {
        Item item;
        ItemStack itemStack = event.getPlayer().getMainHandItem();
        if (!alreadyBreaking && (item = itemStack.getItem()) instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (itemStack.isCorrectToolForDrops(event.getState())) {
                alreadyBreaking = true;
                toggleableTool.mineBlocksAbility(itemStack, event.getPlayer().level(), event.getPos(), (LivingEntity)event.getPlayer());
                alreadyBreaking = false;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void BlockDrops(BlockDropsEvent event) {
        Item item;
        ItemStack itemStack = event.getTool();
        Entity breaker = event.getBreaker();
        if (alreadyBreaking && (item = itemStack.getItem()) instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (breaker instanceof Player) {
                Player player = (Player)breaker;
                ServerLevel serverLevel = event.getLevel();
                BlockPos breakPos = event.getPos();
                ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
                for (ItemEntity drop : event.getDrops()) {
                    newDrops.add(drop.getItem());
                }
                BlockPos spawnAt = spawnDropsAtPos == null || spawnDropsAtPos.equals((Object)BlockPos.ZERO) ? player.blockPosition() : spawnDropsAtPos;
                AbilityMethods.handleDrops(itemStack, serverLevel, spawnAt, (LivingEntity)player, breakPos, newDrops, event.getState(), event.getDroppedExperience());
                event.getState().spawnAfterBreak(event.getLevel(), event.getPos(), itemStack, false);
                event.setCanceled(true);
            }
        }
    }
}

