/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.entities;

import com.direwolf20.justdirethings.setup.Registration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.entity.PartEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PortalEntity
extends Entity {
    private PortalEntity linkedPortal;
    private UUID portalGunUUID;
    private UUID linkedPortalUUID;
    private boolean isAdvanced;
    private static final int TELEPORT_COOLDOWN = 10;
    public static int ANIMATION_COOLDOWN = 5;
    public final Map<UUID, Integer> entityCooldowns = new HashMap<UUID, Integer>();
    public final Map<UUID, Integer> entityVelocityCooldowns = new HashMap<UUID, Integer>();
    public final Map<UUID, Vec3> entityLastPosition = new HashMap<UUID, Vec3>();
    public final Map<UUID, Vec3> entityLastLastPosition = new HashMap<UUID, Vec3>();
    public int expirationTime = -99;
    public int deathCounter = 0;
    @Nullable
    private UUID ownerUUID;
    private static final EntityDataAccessor<Byte> DIRECTION = SynchedEntityData.defineId(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> ALIGNMENT = SynchedEntityData.defineId(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ISPRIMARY = SynchedEntityData.defineId(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ISDYING = SynchedEntityData.defineId(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public PortalEntity(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    public PortalEntity(Level world, Direction direction, Direction.Axis axis, UUID portalGunUUID, boolean isPrimary, boolean isAdvanced, UUID owner) {
        this((EntityType)Registration.PortalEntity.get(), world);
        this.entityData.set(DIRECTION, (Object)((byte)direction.ordinal()));
        this.portalGunUUID = portalGunUUID;
        this.entityData.set(ALIGNMENT, (Object)((byte)axis.ordinal()));
        this.entityData.set(ISPRIMARY, (Object)isPrimary);
        this.isAdvanced = isAdvanced;
        if (isAdvanced) {
            this.expirationTime = 100;
        }
        this.setOwner(owner);
    }

    public void setOwner(UUID owner) {
        if (owner != null) {
            this.ownerUUID = owner;
        }
    }

    public UUID getOwner() {
        return this.ownerUUID;
    }

    public UUID getPortalGunUUID() {
        return this.portalGunUUID;
    }

    public void playerTouch(Player pPlayer) {
        pPlayer.resetFallDistance();
    }

    public void tick() {
        super.tick();
        this.refreshDimensions();
        if (!this.level().isClientSide) {
            this.tickCooldowns();
            if (this.getLinkedPortal() != null) {
                this.teleportCollidingEntities();
                this.captureVelocity();
            }
        }
        this.tickDying();
    }

    public void tickCooldowns() {
        this.entityVelocityCooldowns.entrySet().removeIf(entry -> {
            if ((Integer)entry.getValue() <= 0) {
                this.entityLastPosition.remove(entry.getKey());
                this.entityLastLastPosition.remove(entry.getKey());
                return true;
            }
            entry.setValue((Integer)entry.getValue() - 1);
            return false;
        });
        this.entityCooldowns.entrySet().removeIf(entry -> {
            if ((Integer)entry.getValue() <= 0) {
                return true;
            }
            entry.setValue((Integer)entry.getValue() - 1);
            return false;
        });
        if (this.isAdvanced && this.expirationTime > 0) {
            --this.expirationTime;
            if (this.expirationTime == 0) {
                if (this.getLinkedPortal() != null) {
                    this.getLinkedPortal().setDying();
                }
                this.setDying();
            }
        }
    }

    public void tickDying() {
        if (this.isDying()) {
            ++this.deathCounter;
            if (this.deathCounter > ANIMATION_COOLDOWN) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void captureVelocity() {
        AABB boundingBox = this.getVelocityBoundingBox();
        List entities = this.level().getEntities((Entity)this, boundingBox);
        for (Entity entity : entities) {
            UUID entityUUID = entity.getUUID();
            if (entity == this || !this.isValidEntity(entity)) continue;
            Vec3 currentPos = entity.position();
            if (this.entityLastPosition.containsKey(entityUUID)) {
                this.entityLastLastPosition.put(entityUUID, this.entityLastPosition.get(entityUUID));
            }
            this.entityLastPosition.put(entityUUID, currentPos);
            this.entityVelocityCooldowns.put(entityUUID, 10);
        }
    }

    public AABB getVelocityBoundingBox() {
        return this.getBoundingBox().expandTowards((double)this.getDirection().getStepX() * 2.5, (double)this.getDirection().getStepY() * 2.5, (double)this.getDirection().getStepZ() * 2.5);
    }

    public void teleportCollidingEntities() {
        AABB boundingBox = this.getBoundingBox();
        List entities = this.level().getEntities((Entity)this, boundingBox);
        for (Entity entity : entities) {
            if (entity == this || !this.isValidEntity(entity) || this.level().isClientSide) continue;
            this.teleport(entity);
        }
    }

    public Direction getDirection() {
        return Direction.values()[(Byte)this.entityData.get(DIRECTION)];
    }

    public Direction.Axis getAlignment() {
        return Direction.Axis.values()[(Byte)this.entityData.get(ALIGNMENT)];
    }

    public boolean getIsPrimary() {
        return (Boolean)this.entityData.get(ISPRIMARY);
    }

    public int getDeathCounter() {
        return this.deathCounter;
    }

    public boolean isDying() {
        return (Boolean)this.entityData.get(ISDYING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DIRECTION, (Object)0);
        builder.define(ALIGNMENT, (Object)((byte)Direction.Axis.Z.ordinal()));
        builder.define(ISPRIMARY, (Object)false);
        builder.define(ISDYING, (Object)false);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(DIRECTION, (Object)compound.getByte("direction"));
        this.entityData.set(ALIGNMENT, (Object)compound.getByte("alignment"));
        this.entityData.set(ISPRIMARY, (Object)compound.getBoolean("isPrimary"));
        this.entityData.set(ISDYING, (Object)compound.getBoolean("isDying"));
        this.deathCounter = compound.getInt("deathCounter");
        if (compound.hasUUID("portalGunUUID")) {
            this.portalGunUUID = compound.getUUID("portalGunUUID");
        }
        if (compound.hasUUID("linkedPortalUUID")) {
            this.linkedPortalUUID = compound.getUUID("linkedPortalUUID");
        }
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putByte("direction", ((Byte)this.entityData.get(DIRECTION)).byteValue());
        compound.putByte("alignment", ((Byte)this.entityData.get(ALIGNMENT)).byteValue());
        compound.putBoolean("isPrimary", this.getIsPrimary());
        compound.putBoolean("isDying", this.isDying());
        compound.putInt("deathCounter", this.deathCounter);
        if (this.getPortalGunUUID() != null) {
            compound.putUUID("portalGunUUID", this.getPortalGunUUID());
        }
        if (this.linkedPortalUUID != null) {
            compound.putUUID("linkedPortalUUID", this.linkedPortalUUID);
        }
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (!this.level().isClientSide) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            ChunkPos chunkPos = new ChunkPos(this.blockPosition());
            Registration.TICKET_CONTROLLER.forceChunk(serverLevel, (Entity)this, chunkPos.x, chunkPos.z, true, false);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), Registration.PORTAL_GUN_OPEN.get(), SoundSource.NEUTRAL, 0.75f, 0.4f);
        }
    }

    public void setDying() {
        this.entityData.set(ISDYING, (Object)true);
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), Registration.PORTAL_GUN_CLOSE.get(), SoundSource.NEUTRAL, 0.5f, 0.2f);
    }

    public void remove(Entity.RemovalReason pReason) {
        super.remove(pReason);
        if (!this.level().isClientSide) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            ChunkPos chunkPos = new ChunkPos(this.blockPosition());
            Registration.TICKET_CONTROLLER.forceChunk(serverLevel, (Entity)this, chunkPos.x, chunkPos.z, false, false);
        }
    }

    public void refreshDimensions() {
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected AABB makeBoundingBox() {
        float width = 1.0f;
        float height = 2.0f;
        float depth = 0.2f;
        float setWidth = width;
        float setHeight = height;
        float setDepth = depth;
        Direction direction = this.getDirection();
        Direction.Axis alignment = this.getAlignment();
        if (direction == Direction.UP || direction == Direction.DOWN) {
            setHeight = depth;
            if (alignment == Direction.Axis.X) {
                setWidth = height;
                setDepth = width;
                return this.makeBoundingBox(this.getX() + 1.0, this.getY(), this.getZ(), setWidth, setHeight, setDepth);
            }
            setWidth = width;
            setDepth = height;
            return this.makeBoundingBox(this.getX(), this.getY(), this.getZ() + 1.0, setWidth, setHeight, setDepth);
        }
        if (direction.getAxis() == Direction.Axis.Z) {
            setWidth = width;
            setDepth = depth;
            return this.makeBoundingBox(this.getX(), this.getY(), this.getZ(), setWidth, setHeight, setDepth);
        }
        if (direction.getAxis() == Direction.Axis.X) {
            setWidth = depth;
            setDepth = width;
            return this.makeBoundingBox(this.getX(), this.getY(), this.getZ(), setWidth, setHeight, setDepth);
        }
        return this.makeBoundingBox(this.getX(), this.getY(), this.getZ(), width, height, depth);
    }

    private AABB makeBoundingBox(double x, double y, double z, float width, float height, float depth) {
        float halfWidth = width / 2.0f;
        float halfDepth = depth / 2.0f;
        return new AABB(x - (double)halfWidth, y, z - (double)halfDepth, x + (double)halfWidth, y + (double)height, z + (double)halfDepth);
    }

    public PortalEntity findPartnerPortal(MinecraftServer server) {
        for (ServerLevel serverLevel : server.getAllLevels()) {
            List customEntities = serverLevel.getEntities((EntityTypeTest)Registration.PortalEntity.get(), k -> k.getUUID().equals(this.linkedPortalUUID));
            if (customEntities.isEmpty()) continue;
            return (PortalEntity)((Object)customEntities.getFirst());
        }
        return null;
    }

    public PortalEntity getLinkedPortal() {
        if (this.level().isClientSide) {
            return null;
        }
        if (this.linkedPortal == null && this.linkedPortalUUID != null) {
            this.linkedPortal = this.findPartnerPortal(this.level().getServer());
        }
        return this.linkedPortal;
    }

    public void setLinkedPortal(PortalEntity linkedPortal) {
        this.linkedPortalUUID = linkedPortal.getUUID();
        this.linkedPortal = null;
    }

    public Vec3 getTeleportTo(Entity entity, PortalEntity matchingPortal) {
        AABB entityBB = entity.getBoundingBox();
        AABB portalBB = this.getBoundingBox();
        double entityHeightFraction = this.getDirection().getAxis() == Direction.Axis.Y ? (this.getAlignment() == Direction.Axis.X ? Math.abs(((entityBB.maxX + entityBB.minX) / 2.0 - portalBB.minX) / portalBB.getXsize()) : Math.abs(((entityBB.maxZ + entityBB.minZ) / 2.0 - portalBB.minZ) / portalBB.getZsize())) : (entityBB.minY - portalBB.minY) / portalBB.getYsize();
        Vec3 teleportTo = matchingPortal.getDirection().getAxis() == Direction.Axis.Y ? (matchingPortal.getAlignment() == Direction.Axis.X ? new Vec3(this.linkedPortal.getBoundingBox().minX + entityHeightFraction * this.linkedPortal.getBoundingBox().getXsize(), this.linkedPortal.getY(), this.linkedPortal.getZ()).relative(this.linkedPortal.getDirection(), 0.5) : new Vec3(this.linkedPortal.getX(), this.linkedPortal.getY(), this.linkedPortal.getBoundingBox().minZ + entityHeightFraction * this.linkedPortal.getBoundingBox().getZsize()).relative(this.linkedPortal.getDirection(), 0.5)) : new Vec3(this.linkedPortal.getX(), this.linkedPortal.getBoundingBox().minY + entityHeightFraction * this.linkedPortal.getBoundingBox().getYsize(), this.linkedPortal.getZ()).relative(this.linkedPortal.getDirection(), 0.5);
        if (this.linkedPortal.getDirection() == Direction.DOWN) {
            teleportTo = teleportTo.relative(Direction.DOWN, 1.0);
        }
        return teleportTo;
    }

    public Vec3 calculateVelocity(Entity entity) {
        Vec3 newMotion = Vec3.ZERO;
        UUID entityUUID = entity.getUUID();
        if (this.entityLastPosition.containsKey(entityUUID)) {
            Vec3 velocity;
            double threshold = 0.2;
            Vec3 previousPos = this.entityLastPosition.get(entityUUID);
            Vec3 currentPos = entity.position();
            Vec3 thisVelocity = currentPos.subtract(previousPos);
            Vec3 lastVelocity = Vec3.ZERO;
            if (this.entityLastLastPosition.containsKey(entityUUID)) {
                Vec3 lastLastPos = this.entityLastLastPosition.get(entityUUID);
                Vec3 lastPos = this.entityLastPosition.get(entityUUID);
                lastVelocity = lastPos.subtract(lastLastPos);
            }
            Vec3 vec3 = velocity = lastVelocity.equals((Object)Vec3.ZERO) ? thisVelocity : lastVelocity;
            if (Math.abs(velocity.x) > threshold || Math.abs(velocity.y) > threshold || Math.abs(velocity.z) > threshold || velocity.y > 0.0) {
                newMotion = PortalEntity.transformMotion(velocity, this.getDirection(), this.linkedPortal.getDirection().getOpposite());
            }
            this.entityLastPosition.remove(entityUUID);
            this.entityLastLastPosition.remove(entityUUID);
        }
        return newMotion;
    }

    public void teleport(Entity entity) {
        if (entity.level().isClientSide) {
            return;
        }
        if (this.getLinkedPortal() != null) {
            Vec3 teleportTo = this.getTeleportTo(entity, this.linkedPortal);
            float newYaw = this.getYawFromDirection(this.linkedPortal.getDirection());
            float newPitch = entity.getXRot();
            entity.resetFallDistance();
            Vec3 newMotion = this.calculateVelocity(entity);
            boolean success = entity.teleportTo((ServerLevel)this.linkedPortal.level(), teleportTo.x(), teleportTo.y(), teleportTo.z(), new HashSet(), newYaw, newPitch);
            if (success) {
                entity.resetFallDistance();
                if (!newMotion.equals((Object)Vec3.ZERO)) {
                    entity.setDeltaMovement(newMotion);
                    entity.hasImpulse = true;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        ((ServerPlayer)player).connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                    } else {
                        ((ServerLevel)entity.level()).getChunkSource().broadcast(entity, (Packet)new ClientboundSetEntityMotionPacket(entity));
                    }
                }
                this.linkedPortal.entityCooldowns.put(entity.getUUID(), 10);
            }
        }
    }

    public boolean isValidEntity(Entity entity) {
        if (entity.getType().equals(Registration.PortalEntity.get())) {
            return false;
        }
        if (this.entityCooldowns.containsKey(entity.getUUID())) {
            return false;
        }
        if (entity.isMultipartEntity()) {
            return false;
        }
        if (entity instanceof PartEntity) {
            return false;
        }
        if (!entity.canChangeDimensions(this.level(), this.getLinkedPortal().level()) && !this.isSameLevel()) {
            return false;
        }
        return !entity.getType().is(Tags.EntityTypes.TELEPORTING_NOT_SUPPORTED);
    }

    public boolean isSameLevel() {
        return this.level().equals(this.getLinkedPortal().level());
    }

    public static Vec3 transformMotion(Vec3 motion, Direction from, Direction to) {
        Quaternionf fromRotation = from.getRotation();
        Quaternionf toRotation = to.getRotation();
        fromRotation.invert();
        Vector3f motionVec = new Vector3f((float)motion.x, (float)motion.y, (float)motion.z);
        fromRotation.transform(motionVec);
        toRotation.transform(motionVec);
        return new Vec3((double)motionVec.x(), (double)motionVec.y(), (double)motionVec.z());
    }

    private float getYawFromDirection(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
    }
}

